#!/bin/sh
AVAYAHOME=/opt/Avaya
CAMHOME=$AVAYAHOME/OneXAgentCM
CAMJBOSSHOME=$CAMHOME/jboss-4.2.3.GA/server/default
UTILDIR=$CAMHOME/bin
basedir=/tmp/Avaya/backup
SCRIPT_PATH="${BASH_SOURCE[0]}";
if([ -h "${SCRIPT_PATH}" ]) then
  while([ -h "${SCRIPT_PATH}" ]) do SCRIPT_PATH=`readlink "${SCRIPT_PATH}"`; done
fi
pushd . > /dev/null
cd `dirname ${SCRIPT_PATH}` > /dev/null
SCRIPT_PATH=`pwd`;
popd  > /dev/null
#echo "SCRIPT_PATH=[$SCRIPT_PATH]"
WKDIR=$SCRIPT_PATH
###########################################
#
#
###########################################
saveall()
{
  datesfix=`date '+%F-%H-%M'`
  BACKUP_FILE=${backupdir}/OneXAgentCM-DB_${verscur}-${datesfix}.dump
  echo "" > ${BACKUP_FILE}
  chmod 666  ${BACKUP_FILE}
  sudo -u postgres -P pg_dump -b -o -f ${BACKUP_FILE} camdb
  if [ -f $CAMHOME/backup.log ]; then
        echo ${BACKUP_FILE}>>$CAMHOME/backup.log
  else
        echo "Backup of of the One-X Agent CM Database" >$CAMHOME/backup.log
        echo ${BACKUP_FILE}>>$CAMHOME/backup.log
  fi
  chmod 644 $BACKUP_FILE
  cd $AVAYAHOME/installdata
  zip ${backupdir}/installdata-DIR_${verscur}-${datesfix}.zip * >/dev/null
  if [ -f /etc/init.d/spiritAgent ]; then
     echo "found spiritAgent"
     service spiritAgent stop
     spiritdir=`grep "WRAPPER_CONF=" /etc/init.d/spiritAgent|grep "/opt"|sed "s/WRAPPER_CONF=//"|sed "s/wrapper.config//"|sed "s/\"//g"`
echo [spiritdir=$spiritdir]
     if [ -d $spiritdir ]; then
	cd $spiritdir
	dirprint=`echo $spiritdir|sed -e "s/\//_/g"`
	spiritvers=`grep "APP_VERSION=" /etc/init.d/spiritAgent|sed -e "s/APP_VERSION=//"`
	rm -rf $spiritdir/logging
	rm -rf $spiritdir/*.logbuff
	rm -rf $spiritdir/persist/messages
	logfiles=`find $spiritdir -depth -name *.log`
	if [ "$logfiles" ]; then
	   rm -rf $logfiles
	fi
	zip -r ${backupdir}/SPIRIT_${spiritvers}-DIR[${dirprint}]_${verscur}-${datesfix}.zip * >/dev/null
     fi
  fi
  if [ "$verscur" == "2.0.1012.0" -o "$verscur" == "2.0.1017.0" ]; then
        if [ -f  /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy/camdeploy-ds.xml ]; then
                mkdir -p ${backupdir}/smgrdeploy_${verscur}-${datesfix}
                cp /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy/camdeploy-ds.xml ${backupdir}/smgrdeploy_${verscur}-${datesfix}
        fi
        if [ -f  /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy/HostedCC* ]; then
                mkdir -p ${backupdir}/smgrdeploy_${verscur}-${datesfix}
                cp /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy/HostedCC* ${backupdir}/smgrdeploy_${verscur}-${datesfix}
        fi
  else
    if [ -d $CAMJBOSSHOME ]; then
        service oxacm stop
        cd $CAMJBOSSHOME
        rm -rf log
        rm -rf tmp
        rm -rf work
    fi
  fi
  cd $CAMHOME
  zip -r ${backupdir}/OneXAgentCM-DIR_${verscur}-${datesfix}.zip * >/dev/null
  cd $WKDIR
  echo "One-X Agent CM $verscur Environment has been successfully saved in $backupdir"
  echo $backupdir>> 4rollback.txt
}
##########################################
#
#
#########################################
getversion()
{
  tmpfile=/tmp/tt.xml
  rm -rf $tmpfile
  if [ -f $AVAYAHOME/installdata/inventory.xml ]; then
        sed -e "/<pack name=\"one-X Agent Central Management\" id=\"OneXAgentCM\"/,/<\/pack/w $tmpfile" $AVAYAHOME/installdata/inventory.xml >/dev/null
        lines=`cat $tmpfile|wc -l`
        if [ ! "$lines" == "0" ]; then
                echo $BUILD> pp.xml
                grep "version date" $tmpfile >> pp.xml
                verscur=`awk 'NR == 2 {split($0,a,"\"");print a[4];}' pp.xml`
        fi
  fi
echo "[verscur=$verscur]"
}
########################################
#
#
########################################
checkspace()
{
  while true; do
    backupdir=$basedir/${verscur}
    if [ -d $backupdir ]; then
      rm -rf $backupdir/*
    else
      mkdir -p $backupdir
    fi
    if [ $? == 0 ]; then
        avalsize=`df -h $backupdir|grep -v "Size"|awk 'BEGIN { FS="%"} {len=split($0,a," ");if (len ==6) print "|"a[4]"|";if (len == 5) print "|"a[3]"|"}'|grep -v "||"|sed -e "s/|//g"`
#echo [avalsize=$avalsize]
        dotsize=`echo $avalsize|grep "."`
#echo [dotsize=$dotsize]
        if [ "$dotsize" ]; then
                avalsize=`echo $dotsize|sed -e "s/\.//" -e "s/G/00000/" -e "s/M/00/" -e "s/K//"`
        else
                avalsize=`echo $dotsize|sed -e "s/G/000000/" -e "s/M/000/" -e "s/K//"`
        fi
#echo new [avalsize=$avalsize]
#du -hs /var/lib/pgsql
        needsize=`du -hs /var/lib/pgsql/data|awk '{split($0,a," ");print a[1]}'`
        dotsize=`echo $needsize|grep "."`
        if [ "$dotsize" ]; then
                needsize=`echo $dotsize|sed -e "s/\.//" -e "s/G/00000/" -e "s/M/00/" -e "s/K//"`
        else
                needsize=`echo $dotsize|sed -e "s/G/000000/" -e "s/M/000/" -e "s/K//"`
        fi
#echo [needsize no jboss=$needsize]
        needsize=`echo uu|awk -v a1=$needsize -v a2=300000 '{sum=a1+a2;print sum;}'`
        echo "Backup of of the One-X Agent CM $verscur Environment:"
        echo "  requires $needsize Kb"
        echo " available $avalsize Kb"

        if [ "$needsize" -le "$avalsize" ]; then
                 break
        fi
        echo "Filesystem $bckupdir has no enough disk space."
    else
        echo " Cannot create directory $backupdir"
    fi
    backupdir=abort
    read -p "Set another directory on device with more available disk space or abort: [${backupdir}]" input
    if [ ! "$input" ]; then
        echo "Aborting..."
        exit 1
    fi
    backupdir=$input
    if [ "$backupdir" == "abort" ]; then
        echo "Aborting..."
        exit 1
    fi
  done

}
########################################
#
#
########################################
badbuildinfo()
{
	echo "Rollback requires location of saved files. It must be <backup directory>/<Release number>, where Release number is:"
	echo "2.0.1012.0 for CAM 2.0"
	echo "2.0.1017.0 for CAM 2.0 SP1"
	echo "2.0.1901.0 for CAM 2.0 SP2"
	echo "2.0.3102.0 for CAM 2.0 SP3"
	echo "backup directory could be /tmp/Avaya/backup or any other location"
	echo "Aborting..."
	exit 2
}
########################################
# Script logic starts here
########################################
if [ -z $1 ]; then
        badbuildinfo
fi
if [ "$1" == "install" ]; then
	action=backup
else
  	if [ ! -d $1 ]; then
        	echo "Directory $1 does not exist."
        	badbuildinfo
  	fi
	buildsize=`basename $1|awk '{len=split($0,c,".");if (c[1] != "2") {len=len-1;}print len;}'`
	#echo [buildsize=$buildsize]		
	if [ $buildsize -ne 4 ]; then
        	badbuildinfo
	fi
        restoredir=$1
	action=rollback
fi
if [ "$action" == "rollback" ]; then
  if [ ! -d $1 ]; then
        echo restore directory $1 does not exist
        exit 2
  fi

  echo "Note: The rollback operation will delete all current data!"
  echo 
  versold=`basename $restoredir`
  getversion
  if [ "$verscur" == "$versold" ];then
        echo "Rollback will not save your One-X Central Management, because you are trying to restore the same version"
  else
        if [ ! "$verscur" ]; then
                echo "Rollback can't find One-X Central Management installed"
        else
                checkspace
                echo "passed checkspace"
                saveall
                echo "passed saveall"
        fi
  fi
  echo "Rolling back one-X Central Management $versold Environment"  
  read -p "Do you want to proceed: [y/N]" proceed

  if [ "$proceed" == "y" -o "$proceed" == "Y" ] ; then
        service postgresql restart
  	if [ "$versold" == "2.0.1012.0" -o "$versold" == "2.0.1017.0" ]; then
		service jboss stop
		camfile=`find $restoredir -depth -name camdeploy-ds.xml`
        	if [ ! -f  /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy/camdeploy-ds.xml ]; then
                	cp $camfile /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy
        	fi
		camfile=`find $restoredir -depth -name HostedCC*`
        	if [ ! -f  /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy/HostedCC* ]; then
                	cp $camfile /opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy
        	fi
	else
        	service oxacm stop
	fi
        echo Renaming current $CAMHOME and restore backed up $CAMHOME
        rm -rf ${CAMHOME}cur
        rm -rf $AVAYAHOME/installdatacur
        if [ -d $CAMHOME ]; then
	  mv $CAMHOME ${CAMHOME}cur
	fi
        mkdir -p $CAMHOME
        cd $CAMHOME
        unzip ${restoredir}/OneXAgentCM-DIR* >/dev/null
        if [ -d $AVAYAHOME/installdata ]; then
	  mv $AVAYAHOME/installdata $AVAYAHOME/installdatacur
	fi
        mkdir $AVAYAHOME/installdata
        cd $AVAYAHOME/installdata
        unzip ${restoredir}/installdata-DIR* >/dev/null
	spiritdir=`ls ${restoredir}/SPIRIT*|awk '{split($0,a,"[");split(a[2],b,"]");print b[1];}'|sed -e "s/_/\//g"|sed -e "s/$\///"|sed -e "s/\/$//"`
echo [spiritdir=$spiritdir]
	service spiritAgent stop
	rm -rf ${spiritdir}cur
	if [ -d $spiritdir ]; then
	    mv $spiritdir ${spiritdir}cur
	fi
	mkdir -p $spiritdir
	cd $spiritdir
	unzip ${restoredir}/SPIRIT* >/dev/null
	rm -rf /etc/init.d/spiritAgent
	cp $spiritdir/scripts/spiritAgent /etc/init.d
	chmod 755 /etc/init.d/spiritAgent
        dbfile=`find $restoredir -name OneXAgentCM-DB*`
        echo Dropping old database
        sudo -u postgres dropdb camdb
        echo Restoring the database
	if [ -f $CAMHOME/utils/bin/setupdb.sh ]; then 
		chmod 755 $CAMHOME/utils/bin/setupdb.sh
	fi
	if [ -f $CAMHOME/utils/bin/dropdb.sh ]; then
		chmod 755 $CAMHOME/utils/bin/dropdb.sh
	fi
	if  [ -f $CAMHOME/utils/bin/setupdb.sh ]; then
		chmod 755 $CAMHOME/utils/bin/runsql.sh
	fi
        if [ "$versold" == "2.0.1012.0" -o "$versold" == "2.0.1017.0" ]; then
                sudo -u postgres createdb -O camuser -E UTF8 -q camdb
        else
                sudo -u postgres $CAMHOME/utils/bin/setupdb.sh
        fi
        sudo -u postgres psql camdb < $dbfile >/dev/null
        echo Restore complete
        if [ "$versold" == "2.0.1012.0" -o "$versold" == "2.0.1017.0" ]; then
                service jboss start
	else
        	service oxacm start
	fi
	service spiritAgent start
  else
        echo "Exiting without rollbacking."
  fi
else
  getversion
  checkspace
  saveall
  exit 0
fi

