#!/bin/sh
#
# oneXAgentCM-install.sh
#
# This script checks for necessary dependencies, and installs OxACM.
#
###########################################################################################################################
#
# SCRIPT VARIABLES
#
AVAYAHOME=/opt/Avaya
CAMHOME=$AVAYAHOME/OneXAgentCM
CAMJBOSSHOME=$CAMHOME/jboss-4.2.3.GA/server/default
APPNAME=OneXAgentCM
PROGNAME=`basename $0`
SMGR_HOME=/opt/Avaya/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt
LDAP_uid=sAMAccountName

# The usage string for the script.
USAGE_STRING="oneXAgentCM-install.sh [-h <install_configuration_file>]"

# Whether we are running the install script headless or not.
HEADLESS=false

# The dependency on X11 library (for the oxacm installer. Minimum version:1.1)
XORG_DEP="xorg-x11-server-Xorg"
XORG_MAJOR="1"
XORG_MINOR="1"
XORG_BUILD="0"

# The dependency on postgresql server. (Minimum version: 8.3.11 for new and no check for CAM 2.0)
POSTGRES_DEP="postgresql-server"
POSTGRES_MAJOR="8"
POSTGRES_MINOR="3"
POSTGRES_BUILD="0"

# The dependency on Sun JDK (Minimum version: 1.6.21 for new and no check for CAM 2.0)
SUNJDK_DEP="jdk"
SUNJDK_MAJOR="1"
SUNJDK_MINOR="6"
SUNJDK_BUILD="0"
#
##############################################################################################
#
# SCRIPT FUNCTIONS
#
##############################################################################################################
# Checks if Application been already installed and, if installed, version must be less then new one.         #
# This way we protect against downgrading. User will be asked to agree before overwriting installed version. #
#############################################################################################################
function checkInstalledVersion()
{
  tmpfile=/tmp/tt.xml
  rm -rf $tmpfile
  isold=0
  if [ -f $AVAYAHOME/installdata/inventory.xml ]; then
        sed -e "/<pack name=\"one-X Agent Central Management\" id=\"OneXAgentCM\"/,/<\/pack/w $tmpfile" $AVAYAHOME/installdata/inventory.xml >null
        lines=`cat $tmpfile|wc -l`
        if [ ! "$lines" == "0" ]; then
                echo $BUILD> pp.xml
                grep "version date" $tmpfile >> pp.xml
                isold=`awk ' NR == 1 {split($0,c,"."); removecam=0;}
                     NR >1 {split($0,a,"\""); split(a[4],b,".");
                        comp=0;
                        if ( comp == 0 && b[1] > c[1] ) comp=1;
                        if ( comp == 0 && b[1] == c[1] ) comp=0;
                        if ( comp == 0 && b[1] < c[1] ) comp=2;
                        if ( comp == 0 && b[2] > c[2] ) comp=1;
                        if ( comp == 0 && b[2] == c[2] ) comp=0;
                        if ( comp == 0 && b[2] < c[2] ) comp=2;
                        if ( comp == 0 && b[3] > c[3] ) comp=1;
                        if ( comp == 0 && b[3] == c[3] ) comp=0;
                        if ( comp == 0 && b[3] < c[3] ) comp=2;
                        if ( comp == 0 && b[4] > c[4] ) comp=1;
                        if (comp == 1) removecam=1;}
                        END {print removecam}' pp.xml`
		versold=`awk 'NR == 2 {split($0,a,"\"");print a[4];}' pp.xml`
        fi
  fi
  rm -rf pp.xml
  rm -rf null
#echo "[isold=$isold] [versold=$versold]"
  if [ "$isold" == "1" ]; then
        echo "Found installed one-X Agent Central Management $versold cannot be overwritten with $BUILD.Aborting..."
        exit 1
  else
	echo "Found installed one-X Agent Central Management $versold. Upgrading..."
#	read -p "Found installed one-X Agent Central Management $versold. Do you like to overwrite it?: [y/N]" proceed
#	if [ "$proceed" == "y" -o "$proceed" == "Y" ] ; then
#        	echo Continue with  one-X Agent Central Management $BUILD install.
#	else
#        	echo "Exiting without installing."
#        	exit 1
#	fi

        # Remove the 'stanza' related to one-X Agent CM from $AVAYAHOME/installdata/inventory.xml

        sed -i -f - $AVAYAHOME/installdata/inventory.xml <<EOF
        /<pack name="one-X Agent Central Management" id="OneXAgentCM">/,/<\/pack>/ d
EOF

        sed -i -f - $AVAYAHOME/installdata/inventory.xml <<EOF
        /<pack name="one-X Agent Central Management JBoss" id="OneXAgentCMJBoss">/,/<\/pack>/ d
EOF
  fi
}
##############################################
#                                            #
# Prints the script usage string and exits.  #
#############################################
function printUsage()
{
        /bin/echo "You called  : $PROGNAME"
	/bin/echo "Correct call: ${USAGE_STRING}"
        exit 1
}

####################################
# Determines if an RPM exists      #
# Arg1: The RPM to check.          #
# Exits if the RPM is not found.   #
###################################
function rpmExists()
{
        RPM_NAME="$1"
        RPM_VERSION_MAJ=0
        RPM_VERSION_MIN=0
	RPM_VERSION_BUILD=0
        REQUIRED=0
        if [ "$#" -gt 1 ]; then
                RPM_VERSION_MAJ=$2
        fi
        if [ "$#" -gt 2 ]; then
                RPM_VERSION_MIN=$3
        fi
        if [ "$#" -gt 3 ]; then
                RPM_VERSION_BUILD=$4
        fi
        INSTALLED=0
        RPM_VERSION=`/bin/rpm -q "$RPM_NAME"|tail -1|sed -e "s/$RPM_NAME//"|sed -e "s/^-//"`
        PACKAGE_STATUS=`echo "$RPM_VERSION"|grep "not installed"`
        if [ ! "$PACKAGE_STATUS" ]; then
		INSTALLED=1
                echo "Looking for $RPM_NAME ${RPM_VERSION_MAJ}.${RPM_VERSION_MIN}"
                CURMAJOR=`echo "$RPM_VERSION"|awk '{split($0,a,"."); print a[1]}'`
                CURMINOR=`echo "$RPM_VERSION"|awk '{split($0,a,"."); print a[2]}'`
		CURBUILD=`echo "$RPM_VERSION"|awk '{split($0,a,"."); print a[3]}'`
                if [ "$CURMAJOR" -eq "$RPM_VERSION_MAJ" ]; then
                        if [ "$CURMINOR" -eq "$RPM_VERSION_MIN" ]; then
				if [ "$RPM_VERSION_BUILD" -eq 0 ];then
					INSTALLED=2
				else
				   if [ "$CURBUILD" -eq "$RPM_VERSION_BUILD" ]; then
                                	INSTALLED=2
				   fi
				fi
                        fi
                fi
        fi
        if [ "$INSTALLED" == "0" ]; then
        	echo "Required software ${RPM_NAME}-${RPM_VERSION_MAJ}.${RPM_VERSION_MIN} will be installed on this machine."
	fi
	if [ "$INSTALLED" == "1" ]; then
		echo "Found here  ${RPM_NAME} $RPM_VERSION   ***** Wrong Version ********"
	fi
        if [ "$INSTALLED" == "2" ]; then
                echo "Found here  ${RPM_NAME} $RPM_VERSION"
        fi
        return $INSTALLED
}

#
#####################################################################
#
# SCRIPT LOGIC
#
#####################################################################
# Here we check the script arguments.
NUM_ARGS=$#
if [ $NUM_ARGS -ne 0 -a $NUM_ARGS -ne 2 ]; then
     printUsage
fi
if [ $NUM_ARGS -eq 2 ]; then
    FLAG="$1"
    CONFIG_FILE="$2"
    if [ "${FLAG}" != "-h" ]; then
        printUsage
    fi
    if [ ! -e "${CONFIG_FILE}" ]; then
        /bin/echo "The headless configuration file ${CONFIG FILE} does not exist."
        printUsage
    fi
    HEADLESS="true"
fi

# If the current user is not root, do not allow the install to continue.
if [ "$(/usr/bin/whoami)" != "root" ]; then
	/bin/echo "Must be root to perform install."
	exit -1
fi
badip=`hostname -i|grep -i unknown`
if [ "$badip" ]; then
	echo "This machine can not recognize own IP Address. Aborting..."
	exit 1
fi  

oxasuccess=
if [ ! -f /tmp/oxasuccess ]; then
	oxasuccess=no
else
	oxasuccess=yes
fi

# Here we recognizing Application and comparing version of current release
#  with already installed if any.
 
SCRIPT_PATH="${BASH_SOURCE[0]}";
if([ -h "${SCRIPT_PATH}" ]) then
  while([ -h "${SCRIPT_PATH}" ]) do SCRIPT_PATH=`readlink "${SCRIPT_PATH}"`; done
fi
pushd . > /dev/null
cd `dirname ${SCRIPT_PATH}` > /dev/null
SCRIPT_PATH=`pwd`;
popd  > /dev/null
#echo "SCRIPT_PATH=[$SCRIPT_PATH]"
DIR=`basename $SCRIPT_PATH`
BUILD=`echo $DIR|awk '{split($0,a,"-");print a[2];}'`
#echo BUILD=$BUILD
#########################
# prepare current CAM Environment for rollback
if [ ! -f ${SCRIPT_PATH}/4rollback.txt ]; then
        if [ -d $AVAYAHOME/OneXAgentCM ]; then
                bash ${SCRIPT_PATH}/oxacmrollback.sh install
        fi
fi
if [ ! -d $AVAYAHOME/Uninstaller ]; then
        mkdir -p $AVAYAHOME/Uninstaller
fi
if [ -f $AVAYAHOME/Uninstaller/oxacmrollback.sh ]; then
     rm -rf $AVAYAHOME/Uninstaller/oxacmrollback.sh
fi
cp ${SCRIPT_PATH}/oxacmrollback.sh $AVAYAHOME/Uninstaller
chmod +x $AVAYAHOME/Uninstaller/oxacmrollback.sh
#######################
checkInstalledVersion

# Determine if the prerequisite RPMs are installed.
if [ ! -d $SMGR_HOME/deploy/asmelementmgr.ear ]; then
  echo "SMGR 1.0 not found" 
  notinstalled=1
  rpmExists "$XORG_DEP" "$XORG_MAJOR" "$XORG_MINOR" "$XORG_BUILD"
  if [ $? -lt 1 ]; then
        notinstalled=0;
  fi
  rpmExists "$POSTGRES_DEP" "$POSTGRES_MAJOR" "$POSTGRES_MINOR" "$POSTGRES_BUILD"
  ret=$?
  if [ $ret -eq 0 ]; then
        echo "Installing Postgres 8.3.11"
        pglib=`rpm -q -a|grep postgresql-lib`
        pglibver=`echo $pglib|grep "postgresql-libs-8.3"`
        if [ ! "$pglibver" ]; then
                rpm -e $pglib --nodeps
        fi
        rpm -i etc/postgresql-libs-8.3.11-1PGDG.rhel5.i386.rpm
        rpm -i etc/postgresql-8.3.11-1PGDG.rhel5.i386.rpm
        rpm -i etc/postgresql-server-8.3.11-1PGDG.rhel5.i386.rpm
  fi
  if [ $ret -eq 1 ]; then
	notinstalled=0
  fi
 
  rpmExists "$SUNJDK_DEP" "$SUNJDK_MAJOR" "$SUNJDK_MINOR" "$SUNJDK_BUILD"
  ret=$?
  if [ $ret -eq 0 ]; then
        echo "Installing JDK 1.6.21"
        rpm -i etc/jdk-6u21-linux-i586.rpm
        havejdkpath=`grep "/usr/java/latest/bin" ~/.bash_profile`
        if [ ! "$havejdkpath" ]; then
                sed -i -e "/^PATH=/ s#=#=\/usr\/java\/latest\/bin:#" $HOME/.bash_profile
		JDK_BIN_DIR=/usr/java/latest/bin
        fi
  fi
  if [ $ret -eq 1 ]; then
        notinstalled=0
  fi
  if [ $notinstalled -eq 0 ]; then
        echo "Wrong version of prerequisite software has been found on this machine. Aborting..."
	exit 1
  fi
else
	echo "Found SMGR 1.0. Skipping check of Postgres and JDK versions"
fi


# Determine if Postgres' pg_hba.conf file exists - It is created the first time Postgres is started.
PG_HBA_CONF="/var/lib/pgsql/data/pg_hba.conf"
if [ ! -f "$PG_HBA_CONF" ]; then
	/bin/echo "Starting postgresql for the first time"
	/sbin/service postgresql initdb
	/sbin/service postgresql start
	if [ ! -f "$PG_HBA_CONF" ]; then
		/bin/echo "Cannot find $PG_HBA_CONF"
		exit 1
	fi
fi

# Modify Postgres' pg_hba.conf to support md5 password authentication from localhost.
/bin/echo "Modifying '$PG_HBA_CONF' to support md5 authentication from localhost."
/bin/sed -i -e "s#^\(host[[:blank:]]*all[[:blank:]]*all[[:blank:]]*.*\)ident[[:blank:]]sameuser#\1 md5#g" "$PG_HBA_CONF"

# Restart Postgres (so changes take effect)
/bin/echo "Restarting postgresql"
/sbin/service postgresql restart

# Configure Postgres to start automatically on boot
/bin/echo "Configuring postgresql to start automatically on boot"
/sbin/chkconfig --level 2345 postgresql on

# Find the JDK's bin directory
if [ ! "$JDK_BIN_DIR" ]; then
	JDK_BIN_DIR=$(/bin/rpm -q --last "$SUNJDK_DEP" | /bin/cut --fields=1 --delimiter=' ' | /usr/bin/xargs /bin/rpm -q -l | /bin/grep '/bin$' | /usr/bin/head -1)
fi
/bin/echo "Found Sun JDK in '$JDK_BIN_DIR'"

# Add JDK's bin directory to the PATH (necessary for the installer)
export "PATH=$JDK_BIN_DIR:$PATH"

# Add JAVA_HOME environment required by SPIRIT connector
pushd $JDK_BIN_DIR>/dev/null
cd ..
JAVA_HOME=`pwd`
echo "JAVA_HOME=$JAVA_HOME"
export "JAVA_HOME"
popd

# Requesting Encryption Key to protect passwords
oldmodes=`stty -g`
while true; do
   stty -echo
   read -p "Set Encryption Key for secure data:" ENCRYPTKEY
   if [ $ENCRYPTKEY ]; then
        break
   else
        stty $oldmodes
        echo "Encryption Key can not be empty. Try again"
   fi
done
stty $oldmodes
echo "**********"

if [ -f /etc/init.d/oxacm ]; then
	echo "Found installed version of CAM. Trying to stop it before upgrading..."
	if [ -d $AVAYAHOME/$APPNAME/jboss-4.2.3.GA/bin ]; then
		service oxacm stop
	fi
fi

# these parameters should be recognized by script on run
rm -rf /tmp/oxa*
smgr10installed=no
if [ -d $AVAYAHOME/JBoss/4.3.0/jboss-eap-4.3/jboss-as/server/avmgmt/deploy/asmelementmgr.ear ]; then
  if [ -f /etc/init.d/spiritAgent ]; then
     echo "found spiritAgent"
     spiritdir=`grep "WRAPPER_CONF=" /etc/init.d/spiritAgent|grep "/opt"|sed "s/WRAPPER_CONF=//"|sed "s/wrapper.config//"|sed "s/\"//g"`
     if [ -f $spiritdir/config/agent/OXACM_1.0_0_EPBaseRules_orig.xml ]; then
        if [ ! -f $spiritdir/config/agent/SPIRITAgent_1_0_DataTransportConfig_orig.xml ]; then
                smgr10installed=yes
        else
                smgrfqdn=`awk '/AvayaBase.URL.0/ {split($0,a,"/");print a[3];}' $spiritdir/config/agent/SPIRITAgent_1_0_DataTransportConfig_orig.xml`
                localfqdn=`hostname -f`
                if [ "$smgrfqdn" == "$localfqdn" ]; then
                        smgr10installed=yes
                else
                        smgr10installed=no
                fi
        fi
     fi
  fi
fi

ldapdone=no

if [ ! -f defConfParam.properties ]; then
        echo "########### Added properies" > defConfParam.properties
fi

if [ -f $AVAYAHOME/$APPNAME/jboss-4.2.3.GA/server/default/conf/login-config.xml ]; then
        rm -rf /tmp/oxaldap.xml
	xmlfile=$AVAYAHOME/$APPNAME/jboss-4.2.3.GA/server/default/conf/login-config.xml
	sed -i -e "/AUSTEST/,/<\/application-policy>/w /tmp/oxaldap.xml" $xmlfile	
else
	if [ -f $SMGR_HOME/conf/login-config.xml ]; then
		xmlfile=$SMGR_HOME/conf/login-config.xml
		sed -i -e "/AUSTEST/,/<\/application-policy>/w /tmp/oxaldap.xml" $xmlfile
	fi
fi
if [ -f /tmp/oxaldap.xml ]; then	
        ldapdone=yes
	LDAP_bindDN=`grep "name=\"bindDN\"" /tmp/oxaldap.xml|awk '{split($0,a,">");split(a[2],b,"<");print b[1];}'`
        LDAP_Credential=`grep "name=\"bindCredential\"" /tmp/oxaldap.xml|awk '{split($0,a,">");split(a[2],b,"<");print b[1];}'`
        LDAP_url=`grep "name=\"java.naming.provider.url\"" /tmp/oxaldap.xml|awk '{split($0,a,">");split(a[2],b,"<");print b[1];}'`
        LDAP_baseCtxDN=`grep "name=\"baseCtxDN\"" /tmp/oxaldap.xml|awk '{split($0,a,">");split(a[2],b,"<");print b[1];}'`
	LDAP_uid=`grep "name=\"baseFilter\"" /tmp/oxaldap.xml|awk '{split($0,a,">");split(a[2],b,"<")split(b[1],c,"=");print substr(c[1],2);}'`
	rm -rf /tmp/oxaldap.xml
        sed -i -e "s/^LDAP.bindDN=/\#LDAP.bindDN/" defConfParam.properties
        sed -i -e "s/^LDAP.url=/\#LDAP.url/" defConfParam.properties
        sed -i -e "s/^LDAP.baseCtxDN=/\#LDAP.baseCtxDN/" defConfParam.properties
        echo LDAP.bindDN=${LDAP_bindDN}>> defConfParam.properties
        echo LDAP.url=${LDAP_url}>> defConfParam.properties
        echo LDAP.baseCtxDN=${LDAP_baseCtxDN}>> defConfParam.properties
        echo LDAP.bindCredential=${LDAP_Credential}> /tmp/oxas
fi
dbconfigured=no
xmlfile=$SMGR_HOME/deploy/camdeploy-ds.xml
rm -rf /tmp/oxadb.xml
if [ -f $xmlfile ]; then
	cp $xmlfile /tmp/oxadb.xml
else
        xmlfile=/opt/Avaya/OneXAgentCM/jboss-4.2.3.GA/server/default/deploy/camdeploy-ds.xml
        if [ -f $xmlfile ]; then
                cp $xmlfile /tmp/oxadb.xml
        fi
fi
xmlfile=/tmp/oxadb.xml
if [ -f $xmlfile ]; then
        camuser=`grep "<user-name>" $xmlfile|tail -1|sed -e "s#^ *##"|sed -e "s#<user-name>##"|sed -e "s#<\/user-name>##"|sed -e "s#$ *##"`
#echo camuser=[$camuser]
        campassword=`grep "<password>" $xmlfile|tail -1|sed -e "s#^ *##"|sed -e "s#<password>##"|sed -e "s#<\/password>##"|sed -e "s#$ *##"`
#echo campassword=$campassword
fi
if [ "$camuser" ]; then
	dbconfigured=yes
fi
rm -rf /tmp/oxadb.sh


sed -i -e "s/^smgr10installed=/\#smgr10installed=/" defConfParam.properties
echo smgr10installed=$smgr10installed>> defConfParam.properties
sed -i -e "s/^smgrversion=/\#smgrversion=/" defConfParam.properties
echo smgrversion=61>> defConfParam.properties
sed -i -e "s/^ldapdone=/\#ldapdone=/" defConfParam.properties
echo ldapdone=$ldapdone>> defConfParam.properties
sed -i -e "s/^LDAP.uid=/\#LDAP.uid/" defConfParam.properties
echo LDAP.uid=${LDAP_uid}>> defConfParam.properties
sed -i -e "s/^dbconfigured=/\#dbconfigured=/" defConfParam.properties
echo dbconfigured=$dbconfigured>> defConfParam.properties
sed -i -e "s/^DB.camuser=/\#DB.camuser=/" defConfParam.properties
echo DB.camuser=camuser>> defConfParam.properties
echo DB.campassword=$campassword>> /tmp/oxas

if [ "$smgrfqdn" ]; then
        echo SMGR_HOST_FQDN=$smgrfqdn>> defConfParam.properties
fi
rm -rf /tmp/oxasuccess
if [ "${HEADLESS}" == "true" ]; then
     "$JDK_BIN_DIR/java" -jar install.jar -m unattended -t true -i "${CONFIG_FILE}" <<EOF
$ENCRYPTKEY
EOF
else
     "$JDK_BIN_DIR/java" -jar install.jar <<EOF
$ENCRYPTKEY
EOF
fi

if [ -f /tmp/oxasuccess ]; then
        xmlfile=$SMGR_HOME/deploy/camdeploy-ds.xml
        if [ -f $xmlfile ]; then
           service jboss stop
           mkdir -p /tmp/Avaya/backup
           if [ -f $SMGR_HOME/deploy/HostedCC* ];then
                mv -f $SMGR_HOME/deploy/HostedCC* /tmp/Avaya/backup
           fi
           mv -f $xmlfile /tmp/Avaya/backup
           service jboss start
        fi
fi

wait
if [ -f /etc/init.d/oxacm ]; then
        if [ -d $AVAYAHOME/$APPNAME/jboss-4.2.3.GA/bin ]; then
		echo "Found installed version of CAM. Restarting it..."
                service oxacm restart
        fi
fi
wait
if [ -f /etc/init.d/spiritAgent ]; then
        echo "Found installed version of Spirit. Restarting it..."
        service spiritAgent restart
fi

