/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.avaya.panther.panels.SimpleProcessingClient;
import com.avaya.panther.util.ValidatorUtil;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.Validator;

public class SocketValidator
implements Validator {
    public boolean validate(ProcessingClient client) {
        RuleInputField field = (RuleInputField)client;
        String wasHostName = null;
        String wasPath = null;
        String wasNodeName = null;
        String wasUserName = null;
        String wasPassword = null;
        AutomatedInstallData installData = AutomatedInstallData.getInstance();
        wasPath = installData.getVariable("WASDIR");
        wasNodeName = installData.getVariable("WASNodeName");
        wasUserName = installData.getVariable("WASUserName");
        wasPassword = installData.getVariable("WASPassword");
        String portNumber = field.getText();
        if (portNumber == null || portNumber.length() <= 0) {
            SimpleProcessingClient.setErrorMsg(installData.getVariable("isportvalidator.error"));
            return false;
        }
        if (!new ValidatorUtil().validatePortFormat(portNumber)) {
            return false;
        }
        if (wasNodeName != null && !"null".equalsIgnoreCase(wasNodeName) && wasNodeName.length() > 0 && wasUserName != null && wasUserName.length() > 0) {
            if (wasPath == null || "null".equalsIgnoreCase(wasPath) || wasPath.length() <= 0 || wasPassword == null || wasPassword.length() <= 0) {
                return false;
            }
        } else {
            return false;
        }
        wasHostName = ValidatorUtil.getWASHostName(wasPath, wasNodeName, wasUserName, wasPassword);
        if (wasHostName != null && !"null".equalsIgnoreCase(wasHostName) && wasHostName.trim().length() > 0) {
            return ValidatorUtil.validatePort(wasHostName.trim(), portNumber);
        }
        return false;
    }
}

