/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.avaya.panther.panels.SimpleProcessingClient;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.Validator;
import java.util.Map;
import java.util.regex.Pattern;

public class RegularExpressionValidator
implements Validator {
    public static final String STR_PATTERN_DEFAULT = "[a-zA-Z0-9._-]{3,}@[a-zA-Z0-9._-]+([.][a-zA-Z0-9_-]+)*[.][a-zA-Z0-9._-]{2,4}";
    private static final String PATTERN_PARAM = "pattern";

    public boolean validate(ProcessingClient client) {
        Pattern pattern;
        String patternString = null;
        if (client instanceof RuleInputField) {
            RuleInputField field = (RuleInputField)client;
            if (field.hasParams()) {
                Map paramMap = field.getValidatorParams();
                patternString = (String)paramMap.get(PATTERN_PARAM);
            }
        } else if (client instanceof SimpleProcessingClient) {
            SimpleProcessingClient defaultProcessingClient = (SimpleProcessingClient)client;
            patternString = (String)defaultProcessingClient.getValidatorParams().get(PATTERN_PARAM);
        }
        if (patternString == null) {
            patternString = STR_PATTERN_DEFAULT;
        }
        if (!(pattern = Pattern.compile(patternString)).matcher(client.getFieldContents(0)).matches()) {
            SimpleProcessingClient.setErrorMsg(AutomatedInstallData.getInstance().langpack.getString("pattern.match.fail") + " " + patternString);
        }
        return pattern.matcher(client.getFieldContents(0)).matches();
    }
}

