/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.avaya.panther.installer.AvayaInstaller;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import java.util.Vector;

public class Housekeeper {
    private static Housekeeper me = null;
    private Vector cleanupClients = new Vector();
    private AutomatedInstallData idata;

    private Housekeeper() {
    }

    public static Housekeeper getInstance() {
        if (me == null) {
            me = new Housekeeper();
        }
        return me;
    }

    public void registerForCleanup(CleanupClient client) {
        this.cleanupClients.add(client);
    }

    public void shutDown(int exitCode) {
        int eCode = 0;
        if ("warning".equals(AvayaInstaller.panther.getInstallStatus())) {
            if (this.idata != null) {
                System.out.println(this.idata.langpack.getString("installation.warning"));
                Debug.log(this.idata.logMessages.getString("mode") + this.idata.logMessages.getString("warning"));
            }
            eCode = 1;
        } else if ("error".equals(AvayaInstaller.panther.getInstallStatus())) {
            if (this.idata != null) {
                if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                    System.out.println(this.idata.langpack.getString("automated") + " " + this.idata.langpack.getString("installation.error"));
                    Debug.log(this.idata.langpack.getString("automated") + " " + this.idata.logMessages.getString("mode") + this.idata.logMessages.getString("error"));
                } else {
                    System.out.println(this.idata.langpack.getString("installation.error"));
                    Debug.log(this.idata.logMessages.getString("mode") + this.idata.logMessages.getString("error"));
                }
            }
            eCode = 2;
        } else {
            if (this.idata != null) {
                System.out.println(this.idata.langpack.getString("installation.successful"));
                Debug.log(this.idata.logMessages.getString("mode") + this.idata.logMessages.getString("successful"));
            }
            eCode = 0;
        }
        for (int i = 0; i < this.cleanupClients.size(); ++i) {
            try {
                ((CleanupClient)this.cleanupClients.elementAt(i)).cleanUp();
                continue;
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        System.exit(eCode);
    }

    public void setAutomatedInstallData(AutomatedInstallData idata) {
        this.idata = idata;
    }
}

