/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class FileUtil {
    public static ArrayList getFileContent(String fileName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File aFile = new File(fileName);
        if (!aFile.isFile()) {
            return result;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(aFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return result;
        }
        String aLine = null;
        while ((aLine = reader.readLine()) != null) {
            result.add(aLine + "\n");
        }
        reader.close();
        return result;
    }

    public static boolean fileContains(String aFileName, String aSearchString) {
        return FileUtil.fileContains(aFileName, aSearchString, false);
    }

    public static boolean fileContains(String aFileName, String aSearchString, boolean caseInSensitiveSearch) {
        boolean result = false;
        String searchString = caseInSensitiveSearch ? aSearchString.toLowerCase() : aSearchString;
        ArrayList fileContent = new ArrayList();
        try {
            fileContent = FileUtil.getFileContent(aFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String currentline : fileContent) {
            if (caseInSensitiveSearch) {
                currentline = currentline.toLowerCase();
            }
            if (currentline.indexOf(searchString) <= -1) continue;
            result = true;
            break;
        }
        return result;
    }

    public static long getFileDateTime(URL url) {
        if (url == null) {
            return -1L;
        }
        String fileName = url.getFile();
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            fileName = fileName.substring(1, fileName.length());
        }
        try {
            File file = new File(fileName);
            if (!file.isDirectory() && !file.isFile()) {
                return -1L;
            }
            return file.lastModified();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String[] getFileNames(String dirPath) throws Exception {
        return FileUtil.getFileNames(dirPath, null);
    }

    public static String[] getFileNames(String dirPath, FilenameFilter fileNameFilter) throws Exception {
        String[] fileNames = null;
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            fileNames = fileNameFilter != null ? dir.list(fileNameFilter) : dir.list();
        }
        return fileNames;
    }

    public static void deleteEmptyDirectories(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        File[] children = directory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            FileUtil.deleteEmptyDirectories(child);
        }
        children = directory.listFiles();
        if (children.length == 0) {
            directory.delete();
        }
    }

    public static void main(String[] args) {
    }
}

