/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.panels.AvAvayaUninstallPanelAutomationHelper;
import com.avaya.panther.util.IExecutableClass;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.AvayaUninstallPanel;
import com.izforge.izpack.panels.InstallPanel;
import com.izforge.izpack.panels.InstallPanelAutomationHelper;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.MonitorInputStream;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileExecutor {
    private static final String JAR_FILE_SUFFIX = ".jar";
    AbstractUIProgressHandler handler;
    int noOfParsableFiles;
    protected LocaleDatabase langpack = null;
    private Collection files;

    private boolean stopThread(Thread t, MonitorInputStream m) {
        m.doStop();
        long softTimeout = 1000L;
        try {
            t.join(softTimeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!t.isAlive()) {
            return true;
        }
        t.interrupt();
        long hardTimeout = 1000L;
        try {
            t.join(hardTimeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return !t.isAlive();
    }

    public FileExecutor(Collection files) {
        this.files = files;
    }

    public FileExecutor(Collection files, LocaleDatabase langpack) {
        this.files = files;
        this.langpack = langpack;
    }

    public FileExecutor() {
        this.files = null;
    }

    public static String getExecOutput(String[] aCommandLine) {
        return FileExecutor.getExecOutput(aCommandLine, false);
    }

    public static String getExecOutput(String[] aCommandLine, boolean forceToGetStdOut) {
        FileExecutor fe = new FileExecutor();
        String[] execOut = new String[2];
        int execResult = fe.executeCommand(aCommandLine, execOut);
        if (execResult == 0) {
            return execOut[0];
        }
        if (forceToGetStdOut) {
            return execOut[0];
        }
        return execOut[1];
    }

    public int executeCommand(String[] params, String[] output) {
        return this.executeCommand(params, output, null, true, 0, new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String[] params, String[] output, String executionPath, boolean isMonitorOutput, int sleepTime, int ... type) {
        int exitStatus = 0;
        if (type != null && type.length > 0 && type[0] == 2) {
            Class<?> objectClass = null;
            try {
                objectClass = Class.forName(params[0]);
            }
            catch (ClassNotFoundException e) {
                output[0] = "";
                output[1] = e + "\n";
                exitStatus = -1;
            }
            Debug.trace("exit status: " + Integer.toString(exitStatus));
            Constructor<?> constructor = null;
            try {
                constructor = objectClass.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                output[0] = "";
                output[1] = e + "\n";
                exitStatus = -1;
            }
            try {
                IExecutableClass executableClass = (IExecutableClass)constructor.newInstance(new Object[0]);
                ArrayList<String> paramList = new ArrayList<String>();
                for (int i = 0; i < params.length; ++i) {
                    paramList.add(params[i]);
                }
                paramList.remove(0);
                exitStatus = executableClass.execute(paramList.toArray(new String[paramList.size()]));
            }
            catch (Exception e) {
                output[0] = "";
                output[1] = e + "\n";
                exitStatus = -1;
            }
        } else {
            StringBuffer retval = new StringBuffer();
            retval.append("executeCommand\n");
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    retval.append("\tparams: ").append(params[i]);
                    retval.append("\n");
                }
            }
            File path = executionPath != null ? new File(executionPath) : new File(".");
            Process process = null;
            MonitorInputStream outMonitor = null;
            MonitorInputStream errMonitor = null;
            Thread t1 = null;
            Thread t2 = null;
            exitStatus = -1;
            Debug.trace(retval);
            try {
                process = path.exists() ? Runtime.getRuntime().exec(params, null, path) : Runtime.getRuntime().exec(params);
                boolean console = false;
                if (console) {
                    Console c = new Console(process);
                    output[0] = c.getOutputData();
                    output[1] = c.getErrorData();
                    exitStatus = process.exitValue();
                } else if (!isMonitorOutput) {
                    Debug.log("Monitor Output is false with sleep time " + sleepTime);
                    if (sleepTime > 0) {
                        Thread.sleep(sleepTime);
                    }
                    exitStatus = 0;
                } else {
                    StringWriter outWriter = new StringWriter();
                    StringWriter errWriter = new StringWriter();
                    InputStreamReader or = new InputStreamReader(process.getInputStream());
                    InputStreamReader er = new InputStreamReader(process.getErrorStream());
                    outMonitor = new MonitorInputStream(or, outWriter);
                    errMonitor = new MonitorInputStream(er, errWriter);
                    t1 = new Thread(outMonitor);
                    t2 = new Thread(errMonitor);
                    t1.setDaemon(true);
                    t2.setDaemon(true);
                    t1.start();
                    t2.start();
                    exitStatus = process.waitFor();
                    t1.join();
                    t2.join();
                    output[0] = outWriter.toString();
                    Debug.trace("stdout:");
                    Debug.trace(output[0]);
                    output[1] = errWriter.toString();
                    Debug.trace("stderr:");
                    Debug.trace(output[1]);
                }
                Debug.trace("exit status: " + Integer.toString(exitStatus));
            }
            catch (InterruptedException e) {
                if (Debug.tracing()) {
                    e.printStackTrace(System.err);
                }
                if (isMonitorOutput) {
                    this.stopThread(t1, outMonitor);
                    this.stopThread(t2, errMonitor);
                }
                output[0] = "";
                output[1] = e.getMessage() + "\n";
            }
            catch (IOException e) {
                if (Debug.tracing()) {
                    e.printStackTrace(System.err);
                }
                output[0] = "";
                output[1] = e.getMessage() + "\n";
            }
            finally {
                if (process != null && isMonitorOutput) {
                    process.destroy();
                }
            }
        }
        return exitStatus;
    }

    public int executeFiles(int currentStage, AbstractUIHandler handler) {
        int exitStatus = 0;
        int count = 0;
        String[] output = new String[2];
        String permissions = "ug+x";
        AutomatedInstallData iData = null;
        if (handler instanceof IzPanel) {
            iData = ((IzPanel)handler).idata;
        }
        if (handler instanceof InstallPanelAutomationHelper) {
            iData = ((InstallPanelAutomationHelper)handler).iData;
        }
        if (handler instanceof AvayaUninstallPanel) {
            iData = ((AvayaUninstallPanel)handler).idata;
        }
        if (handler instanceof AvAvayaUninstallPanelAutomationHelper) {
            iData = ((AvAvayaUninstallPanelAutomationHelper)handler).idata;
        }
        Iterator efileIterator = this.files.iterator();
        Object oldPackId = null;
        int pcount = 0;
        while (exitStatus == 0 && efileIterator.hasNext()) {
            ++pcount;
            if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                if (pcount >= 20) {
                    System.out.print("\r                    \r");
                    pcount = 0;
                }
                System.out.print(".");
            }
            ExecutableFile efile = (ExecutableFile)efileIterator.next();
            boolean deleteAfterwards = !efile.keepFile;
            File file = new File(efile.path);
            String displayMessage = "";
            String correctiveActionMessage = "";
            if (this.langpack != null) {
                displayMessage = efile.displayMessage != null ? this.langpack.getString(efile.displayMessage) : this.langpack.getString("file.execute") + " " + efile.path;
                String string = correctiveActionMessage = efile.correctiveAction != null ? "\nCorrective Action:" + this.langpack.getString(efile.correctiveAction) + "\n" : "";
            }
            if (!OsConstraint.oneMatchesCurrentSystem(efile.osList)) {
                if (handler instanceof InstallPanel) {
                    ((InstallPanel)handler).fileProgress(this.noOfParsableFiles + count, displayMessage + "...");
                    ++count;
                }
                if (!(handler instanceof AvayaUninstallPanel)) continue;
                ((AvayaUninstallPanel)handler).fileProgress(count, displayMessage + "...");
                ++count;
                continue;
            }
            String excinfo = efile.toString();
            Debug.log("executing file: " + excinfo);
            if (0 == efile.type && OsVersion.IS_UNIX) {
                exitStatus = 0;
                permissions = efile.getPermission() == null ? "ug+x" : efile.getPermission();
                String[] params = new String[]{"/bin/chmod", permissions, file.toString()};
                if (!permissions.equalsIgnoreCase("no")) {
                    Debug.trace("making file executable (setting executable flag)");
                    exitStatus = this.executeCommand(params, output, efile.workingDirectory, true, 0, new int[0]);
                }
                if (exitStatus != 0) {
                    String fileOwner = FileExecutor.getExecOutput(new String[]{"/bin/bash", "-c", "/bin/ls -l \"" + file.getAbsolutePath() + "\" | " + "cut -d \" \" -f 3"});
                    if (fileOwner != null) {
                        fileOwner = fileOwner.trim();
                    }
                    String currentUser = System.getProperty("user.name");
                    Debug.warn("Error executing \n" + params[0] + " " + params[1] + " " + params[2]);
                    ++AvayaInstallData.install_warnings_count;
                    if (currentUser.equals(fileOwner)) {
                        handler.emitError("file execution error", "Error executing \n" + params[0] + " " + params[1] + " " + params[2] + correctiveActionMessage);
                    }
                    exitStatus = 0;
                }
            }
            if (handler instanceof InstallPanel) {
                ((InstallPanel)handler).fileProgress(this.noOfParsableFiles + count, displayMessage);
                ++count;
            }
            if (handler instanceof AvayaUninstallPanel) {
                ((AvayaUninstallPanel)handler).fileProgress(count, displayMessage);
                ++count;
            }
            if (exitStatus == 0 && efile.executionStage != 1 && exitStatus == 0) {
                ArrayList<String> paramList = new ArrayList<String>();
                if (0 == efile.type) {
                    paramList.add(file.toString());
                } else if (1 == efile.type && null == efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    paramList.add("-jar");
                    paramList.add(file.toString());
                } else if (1 == efile.type && null != efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    paramList.add("-cp");
                    try {
                        paramList.add(this.buildClassPath(file.toString()));
                    }
                    catch (Exception e) {
                        exitStatus = -1;
                        Debug.error(e);
                    }
                    paramList.add(efile.mainClass);
                } else if (2 == efile.type) {
                    paramList.add(efile.path);
                }
                if (null != efile.argList && !efile.argList.isEmpty()) {
                    paramList.addAll(efile.argList);
                }
                String[] params = new String[paramList.size()];
                for (int i = 0; i < paramList.size(); ++i) {
                    params[i] = (String)paramList.get(i);
                }
                exitStatus = this.executeCommand(params, output, efile.workingDirectory, efile.isMonitorOutput(), efile.getSleepTime(), efile.type);
                if (exitStatus != 0) {
                    int answer;
                    Debug.log("Exit Status for: " + params[0] + ": " + exitStatus);
                    deleteAfterwards = false;
                    String command = output[0];
                    String message = this.langpack.getString("file.execution.affect");
                    String displayMsg = message + this.langpack.getString("refer.log.file");
                    message = message + command + "\n" + output[1];
                    message = AvayaInstallerBase.replacePassword(message);
                    if (message.length() == 1) {
                        displayMsg = message = this.langpack.getString("file.execute.fail.message") + file.toString() + ".";
                    }
                    if (efile.onFailure == 0) {
                        AvayaInstaller.panther.setInstallStatus("error");
                        ++AvayaInstallData.install_faliure_count;
                        message = message + this.langpack.getString("file.fail.error");
                        handler.emitError(this.langpack.getString("fatal.error"), message);
                        Debug.error(message);
                        iData.installSuccess = false;
                    } else if (efile.onFailure == 2) {
                        message = message + this.langpack.getString("file.fail.warn") + correctiveActionMessage;
                        displayMsg = displayMsg + correctiveActionMessage + this.langpack.getString("file.fail.warn");
                        if (AutomatedInstallData.getInstance().getVariable("installationCancelled") != null && AutomatedInstallData.getInstance().getVariable("installationCancelled").equals("true")) {
                            AvayaInstaller.panther.setInstallStatus("warning");
                            ++AvayaInstallData.install_warnings_count;
                            Debug.warn(displayMsg);
                            exitStatus = 0;
                            continue;
                        }
                        answer = handler.askQuestion(this.langpack.getString("file.execute.fail") != null ? this.langpack.getString("file.execute.fail") : "", displayMsg, 37);
                        if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                            boolean ans = AvayaInstaller.panther.isContinueOnFailure();
                            answer = ans ? 47 : 49;
                        }
                        if (answer == 47) {
                            if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
                                AvayaInstaller.panther.setInstallStatus("warning");
                                ++AvayaInstallData.install_warnings_count;
                                Debug.warn(message);
                                exitStatus = 0;
                            } else {
                                AvayaInstaller.panther.setInstallStatus("warning");
                                ++AvayaInstallData.install_warnings_count;
                                Debug.warn(message);
                                exitStatus = 0;
                            }
                        } else {
                            AvayaInstaller.panther.setInstallStatus(" Cancelled");
                            ++AvayaInstallData.install_faliure_count;
                            Debug.error(message);
                            iData.installSuccess = false;
                        }
                    } else if (efile.onFailure == 3) {
                        AvayaInstaller.panther.setInstallStatus("warning");
                        ++AvayaInstallData.install_warnings_count;
                        Debug.warn(message);
                        exitStatus = 0;
                    } else {
                        answer = handler.askQuestion(this.langpack.getString("file.execute.fail"), displayMsg, 37);
                        if (answer == 47) {
                            if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
                                AvayaInstaller.panther.setInstallStatus("warning");
                                ++AvayaInstallData.install_warnings_count;
                                Debug.warn(message);
                                exitStatus = 0;
                            } else {
                                AvayaInstaller.panther.setInstallStatus("error");
                                ++AvayaInstallData.install_faliure_count;
                                Debug.error(message);
                                iData.installSuccess = false;
                            }
                        } else {
                            AvayaInstaller.panther.setInstallStatus(" Cancelled");
                            ++AvayaInstallData.install_faliure_count;
                            Debug.error(message);
                            iData.installSuccess = false;
                        }
                    }
                } else {
                    ++AvayaInstallData.install_success_count;
                    Debug.log("Execution of " + params[0] + " Completed");
                    Debug.log("Exit Status for: " + params[0] + ": " + exitStatus);
                }
            }
            if (efile.executionStage != 0 || !deleteAfterwards || !file.canWrite()) continue;
            file.delete();
        }
        return exitStatus;
    }

    private String buildClassPath(String targetFile) throws Exception {
        StringBuffer classPath = new StringBuffer();
        ArrayList<String> jars = new ArrayList<String>();
        String rawClassPath = targetFile.replace(':', File.pathSeparatorChar).replace(';', File.pathSeparatorChar);
        String[] rawJars = rawClassPath.split("" + File.pathSeparatorChar);
        for (int i = 0; i < rawJars.length; ++i) {
            String[] subDirJars;
            File file = new File(rawJars[i]);
            jars.add(rawJars[i]);
            if (!file.isDirectory() || (subDirJars = FileUtil.getFileNames(rawJars[i], new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(FileExecutor.JAR_FILE_SUFFIX);
                }
            })) == null) continue;
            for (int j = 0; j < subDirJars.length; ++j) {
                jars.add(rawJars[i] + File.separator + subDirJars[j]);
            }
        }
        Iterator iter = jars.iterator();
        if (iter.hasNext()) {
            classPath.append(iter.next());
        }
        while (iter.hasNext()) {
            classPath.append(File.pathSeparatorChar).append(iter.next());
        }
        return classPath.toString();
    }

    public void setProperties(AbstractUIProgressHandler handler, int noOfParsableFiles, LocaleDatabase langpack) {
        this.handler = handler;
        this.noOfParsableFiles = noOfParsableFiles;
        this.langpack = langpack;
    }
}

