/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.avaya.common.logging.client.CommonLogManager;
import com.avaya.common.logging.client.Logger;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.util.ConsoleProgressBar;
import com.izforge.izpack.Info;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Debug {
    public static final String DLOG = "LOG";
    public static final String DSTACKTRACE = "STACKTRACE";
    public static final String DTRACE = "TRACE";
    public static final String IZPACK_LOGFILE = "izpack.logfile";
    public static final int LOG_WITHOUT_DATE = 0;
    public static final int LOG_WITH_DATE = 1;
    public static final int LOG_WITH_TIME_STAMP = 2;
    public static final int LOG_WITH_TIME_AND_DATE = 3;
    private static boolean TRACE;
    private static boolean STACKTRACE;
    private static boolean LOG;
    public static String LOGFILE_PREFIX;
    public static String LOGFILE_EXTENSION;
    public static String LOGFILENAME;
    public static Logger lgr;

    public static void init() {
        String logType;
        String appName;
        boolean st = true;
        try {
            st = Boolean.getBoolean(DSTACKTRACE);
        }
        catch (Exception ex) {
            // empty catch block
        }
        STACKTRACE = st;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_hh.mm.ss");
        Date date = new Date();
        String hostname = "hostname";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Info info = null;
        try {
            InputStream infoInputStream = InstallerBase.class.getResourceAsStream("/info");
            ObjectInputStream infoObjectInputStream = new ObjectInputStream(infoInputStream);
            info = (Info)infoObjectInputStream.readObject();
            infoObjectInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (info != null) {
            appName = info.getAppName();
            appName = appName.replaceAll("[^-a-zA-z0-9_]", "_").replaceAll("\\\\", "_");
        } else {
            appName = "";
        }
        appName = appName.toLowerCase();
        if (AvayaInstallerBase.isUninstall()) {
            logType = "uninstall-log";
            appName = "avaya_uninstaller";
        } else {
            logType = "install-log";
        }
        String logFileName = appName + "_" + logType + "_" + dateFormat.format(date) + LOGFILE_EXTENSION;
        String logFilePath = new File(System.getProperty("java.io.tmpdir"), logFileName).getAbsolutePath();
        System.setProperty("logfile", logFilePath);
        CommonLogManager.initializeJDO("com.avaya.installer", hostname, null, "Installer", TimeZone.getDefault(), "Avaya Installer Framework");
        lgr = Logger.getLogger("com.avaya.installer");
        lgr.setLogProductType("com.avaya.mgmt");
        ConsoleProgressBar.setInitMessages("Log file has been created at location: " + logFilePath);
        boolean log = true;
        try {
            log = Boolean.getBoolean(DLOG);
        }
        catch (Exception ex) {
            // empty catch block
        }
        LOG = log = true;
        boolean t = true;
        try {
            t = STACKTRACE ? true : Boolean.getBoolean(DTRACE);
        }
        catch (Exception ex) {
            // empty catch block
        }
        TRACE = t;
        if (LOG) {
            // empty if block
        }
        if (TRACE) {
            System.out.println("TRACE enabled.");
        }
        if (STACKTRACE) {
            System.out.println("STACKTRACE enabled.");
        }
        Debug.log(OsVersion.getOsDetails());
        Debug.log("Invoker's Login ID: " + System.getProperty("user.name"));
    }

    public static void trace(Object s) {
        if (TRACE) {
            System.out.println(s);
            if (STACKTRACE && s instanceof Throwable) {
                ((Throwable)s).printStackTrace();
            }
            System.out.flush();
        }
    }

    public static void error(Object s) {
        Debug.trace(s);
        lgr.error(s);
    }

    public static void log(Object o) {
        lgr.info(o.toString());
    }

    public static void log(Object o, int withWhatFormat) {
        if (LOG) {
            if (o == null) {
                o = "null";
            }
            StringBuffer entry = new StringBuffer();
            if (Debug.logWithTimeStamp(withWhatFormat)) {
                entry.append(System.currentTimeMillis());
                entry.append(';');
                entry.append(' ');
            }
            if (Debug.logWithDate(withWhatFormat)) {
                entry.append(new Date());
                entry.append(';');
                entry.append(' ');
            }
            entry.append(o);
            lgr.info(entry.toString());
            if (o instanceof Throwable) {
                lgr.info(((Throwable)o).getStackTrace().toString());
            }
        }
    }

    private static boolean logWithDate(int withWhatFormat) {
        return (withWhatFormat & 1) == 1;
    }

    private static boolean logWithTimeStamp(int withWhatFormat) {
        return (withWhatFormat & 1) == 1;
    }

    private static PrintWriter createLogFile() {
        PrintWriter logfile;
        String tempDir = System.getProperty("java.io.tmpdir");
        File tempDirFile = new File(tempDir);
        try {
            tempDirFile.mkdirs();
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
        }
        String logfilename = LOGFILENAME;
        System.out.println("creating Logfile: '" + logfilename + "' in: '" + tempDir + "'");
        File out = new File(tempDir, logfilename);
        if (tempDirFile.canWrite()) {
            try {
                BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), "UTF-8"));
                logfile = Debug.setLogFile(new PrintWriter(fw));
            }
            catch (Exception e) {
                logfile = null;
                e.printStackTrace();
            }
        } else {
            logfile = null;
            System.err.println("Fatal: cannot write File: '" + logfilename + "' into: " + tempDirFile);
        }
        return logfile;
    }

    public static boolean tracing() {
        return TRACE;
    }

    public static boolean stackTracing() {
        return STACKTRACE;
    }

    public static boolean isLOG() {
        return LOG;
    }

    public static void setLOG(boolean aFlag) {
        System.out.println("LOG = " + aFlag);
        LOG = aFlag;
    }

    public static boolean isSTACKTRACE() {
        return STACKTRACE;
    }

    public static void setSTACKTRACE(boolean aFlag) {
        System.out.println("STACKTRACE = " + aFlag);
        STACKTRACE = aFlag;
    }

    public static boolean isTRACE() {
        return TRACE;
    }

    public static void setTRACE(boolean aFlag) {
        System.out.println("TRACE = " + aFlag);
        TRACE = aFlag;
    }

    public static PrintWriter getLogFile() {
        PrintWriter logfile = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        return logfile;
    }

    public static synchronized PrintWriter setLogFile(PrintWriter aLogFile) {
        System.getProperties().put(IZPACK_LOGFILE, aLogFile);
        PrintWriter logfile = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        if (logfile == null) {
            System.err.println("Set::logfile == null");
        }
        return logfile;
    }

    public static void warn(Object o) {
        lgr.warn(o.toString());
    }

    public static void fatal(Object o) {
        lgr.fatal(o.toString());
    }

    static {
        LOGFILE_PREFIX = "IzPack_Logfile_at_";
        LOGFILE_EXTENSION = ".txt";
        LOGFILENAME = LOGFILE_PREFIX + System.currentTimeMillis() + LOGFILE_EXTENSION;
    }
}

