/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.uninstaller.Destroyer;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class UninstallerFrame
extends JFrame {
    private static final long serialVersionUID = 3257281444152684850L;
    private IconsDatabase icons;
    protected static LocaleDatabase langpack;
    protected JCheckBox targetDestroyCheckbox;
    protected JProgressBar progressBar;
    protected JButton destroyButton;
    protected JButton quitButton;
    private Color buttonsHColor = new Color(230, 230, 230);
    protected String installPath;

    public UninstallerFrame(boolean displayForceOption, boolean forceOptionState) throws Exception {
        super("IzPack - Uninstaller");
        langpack = new LocaleDatabase(UninstallerFrame.class.getResourceAsStream("/langpack.xml"));
        this.getInstallPath();
        this.icons = new IconsDatabase();
        this.loadIcons();
        UIManager.put("OptionPane.yesButtonText", langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", langpack.getString("installer.cancel"));
        this.buildGUI(displayForceOption, forceOptionState);
        this.addWindowListener(new WindowHandler());
        this.pack();
        this.centerFrame(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void buildGUI(boolean displayForceOption, boolean forceOptionState) {
        JPanel contentPane = (JPanel)this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        ActionsHandler handler = new ActionsHandler();
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        ButtonFactory.useButtonIcons();
        ButtonFactory.useHighlightButtons();
        JLabel warningLabel = new JLabel(langpack.getString("uninstaller.warning"), this.icons.getImageIcon("warning"), 11);
        this.buildConstraints(gbConstraints, 0, 0, 2, 1, 1.0, 0.0);
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        layout.addLayoutComponent(warningLabel, gbConstraints);
        contentPane.add(warningLabel);
        this.targetDestroyCheckbox = new JCheckBox(langpack.getString("uninstaller.destroytarget") + this.installPath, forceOptionState);
        this.buildConstraints(gbConstraints, 0, 1, 2, 1, 1.0, 0.0);
        layout.addLayoutComponent(this.targetDestroyCheckbox, gbConstraints);
        if (displayForceOption) {
            contentPane.add(this.targetDestroyCheckbox);
        }
        gbConstraints.fill = 2;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(langpack.getString("InstallPanel.begin"));
        this.buildConstraints(gbConstraints, 0, 2, 2, 1, 1.0, 0.0);
        layout.addLayoutComponent(this.progressBar, gbConstraints);
        contentPane.add(this.progressBar);
        this.destroyButton = ButtonFactory.createButton(langpack.getString("uninstaller.uninstall"), this.icons.getImageIcon("delete"), this.buttonsHColor);
        this.destroyButton.addActionListener(handler);
        this.buildConstraints(gbConstraints, 0, 3, 1, 1, 0.5, 0.0);
        gbConstraints.fill = 0;
        gbConstraints.anchor = 17;
        layout.addLayoutComponent(this.destroyButton, gbConstraints);
        contentPane.add(this.destroyButton);
        this.quitButton = ButtonFactory.createButton(langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.buttonsHColor);
        this.quitButton.addActionListener(handler);
        this.buildConstraints(gbConstraints, 1, 3, 1, 1, 0.5, 0.0);
        gbConstraints.anchor = 13;
        layout.addLayoutComponent(this.quitButton, gbConstraints);
        contentPane.add(this.quitButton);
    }

    private void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void getInstallPath() throws Exception {
        InputStream in = UninstallerFrame.class.getResourceAsStream("/install.log");
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        this.installPath = reader.readLine();
        reader.close();
    }

    private void loadIcons() throws Exception {
        this.icons = new IconsDatabase();
        URL url = UninstallerFrame.class.getResource("/img/trash.png");
        ImageIcon img = new ImageIcon(url);
        this.icons.put("delete", img);
        url = UninstallerFrame.class.getResource("/img/stop.png");
        img = new ImageIcon(url);
        this.icons.put("stop", img);
        url = UninstallerFrame.class.getResource("/img/flag.png");
        img = new ImageIcon(url);
        this.icons.put("warning", img);
        url = UninstallerFrame.class.getResource("/img/JFrameIcon.png");
        img = new ImageIcon(url);
        this.icons.put("JFrameIcon", img);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static LocaleDatabase getLangpack() {
        return langpack;
    }

    class ActionsHandler
    implements ActionListener {
        ActionsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == UninstallerFrame.this.quitButton) {
                System.exit(0);
            } else if (src == UninstallerFrame.this.destroyButton) {
                UninstallerFrame.this.destroyButton.setEnabled(false);
                Destroyer destroyer = new Destroyer(UninstallerFrame.this.installPath, UninstallerFrame.this.targetDestroyCheckbox.isSelected(), new DestroyerHandler());
                destroyer.start();
            }
        }
    }

    private final class DestroyerHandler
    implements AbstractUIProgressHandler {
        private DestroyerHandler() {
        }

        public void startAction(String name, final int max) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UninstallerFrame.this.progressBar.setMinimum(0);
                    UninstallerFrame.this.progressBar.setMaximum(max);
                    UninstallerFrame.this.blockGUI();
                }
            });
        }

        public void stopAction() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UninstallerFrame.this.progressBar.setString(langpack.getString("InstallPanel.finished"));
                    UninstallerFrame.this.targetDestroyCheckbox.setEnabled(false);
                    UninstallerFrame.this.destroyButton.setEnabled(false);
                    UninstallerFrame.this.releaseGUI();
                }
            });
        }

        public void progress(final int pos, final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UninstallerFrame.this.progressBar.setValue(pos);
                    UninstallerFrame.this.progressBar.setString(message);
                }
            });
        }

        public void nextStep(String step_name, int step_no, int no_of_substeps) {
        }

        public void setSubStepNo(int no_of_substeps) {
        }

        public void emitNotification(String text) {
        }

        public boolean emitWarning(String title, String text) {
            return JOptionPane.showConfirmDialog(null, text, title, 2, 2) == 0;
        }

        public void emitError(String title, String error) {
            UninstallerFrame.this.progressBar.setString(error);
            JOptionPane.showMessageDialog(null, error, title, 2);
        }

        public int askQuestion(String title, String question, int choices) {
            return this.askQuestion(title, question, choices, -1);
        }

        public int askQuestion(String title, String question, int choices, int default_choice) {
            int jo_choices = 0;
            if (choices == 37) {
                jo_choices = 0;
            } else if (choices == 38) {
                jo_choices = 1;
            }
            int user_choice = JOptionPane.showConfirmDialog(null, question, title, jo_choices, 3);
            if (user_choice == 2) {
                return 45;
            }
            if (user_choice == 0) {
                return 47;
            }
            if (user_choice == 1) {
                return 49;
            }
            return default_choice;
        }
    }

    private final class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

