/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.panels.AvAvayaUninstallPanelAutomationHelper;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.panels.AvayaUninstallPanel;
import com.izforge.izpack.uninstaller.Destroyer;
import com.izforge.izpack.uninstaller.UninstallerFrame;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.util.jar.JarFile;

public class UninstallerConsole {
    protected String installPath;
    protected static LocaleDatabase langpack;
    private AbstractUIProgressHandler handler = null;

    public UninstallerConsole() throws Exception {
        langpack = new LocaleDatabase(UninstallerFrame.class.getResourceAsStream("/langpack.xml"));
        this.getInstallPath();
    }

    public UninstallerConsole(AbstractUIProgressHandler handler) throws Exception {
        String packUninstallerURL = null;
        if (handler instanceof AvayaUninstallPanel) {
            packUninstallerURL = ((AvayaUninstallPanel)handler).getPackUninstallerURL();
        }
        if (handler instanceof AvAvayaUninstallPanelAutomationHelper) {
            packUninstallerURL = ((AvAvayaUninstallPanelAutomationHelper)handler).getPackUninstallerURL();
        }
        JarFile jarFile = new JarFile(packUninstallerURL);
        langpack = new LocaleDatabase(jarFile.getInputStream(jarFile.getJarEntry("langpack.xml")));
        this.getInstallPath();
        this.handler = handler;
    }

    private void getInstallPath() throws Exception {
        this.installPath = InventoryUtil.getInventory().getInstallPath();
    }

    public void runUninstall(boolean destroy) {
        Destroyer destroyer = new Destroyer(this.installPath, destroy, this.handler);
        destroyer.execute();
    }

    private final class DestroyerHandler
    implements AbstractUIProgressHandler {
        private int AUTO_ANSWER_MODE = -2;

        private DestroyerHandler() {
        }

        private void out(String str) {
            System.out.println(str);
        }

        private boolean askOKCancel(String question, int defaultchoice) {
            if (defaultchoice == this.AUTO_ANSWER_MODE) {
                return true;
            }
            boolean defaultanswer = defaultchoice == 1;
            try {
                System.out.print(question + " (Ok/Cancel) [" + (defaultanswer ? "O" : "C") + "]:");
                String rline = this.readln();
                if (rline.toLowerCase().startsWith("o")) {
                    return true;
                }
                if (rline.toLowerCase().startsWith("c")) {
                    return false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (defaultchoice == -1) {
                return this.askOKCancel(question, defaultchoice);
            }
            return defaultanswer;
        }

        private int askYesNoCancel(String question, int defaultchoice) {
            if (defaultchoice == this.AUTO_ANSWER_MODE) {
                return 47;
            }
            boolean defaultanswer = defaultchoice == 1;
            try {
                System.out.print(question + " (Yes/No/Cancel) [" + (defaultanswer ? "Y" : "N") + "]:");
                String rline = this.readln();
                if (rline.toLowerCase().equals("y")) {
                    return 47;
                }
                if (rline.toLowerCase().equals("n")) {
                    return 49;
                }
                if (rline.toLowerCase().equals("c")) {
                    return 45;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (defaultchoice == -1) {
                return this.askYesNoCancel(question, defaultchoice);
            }
            return defaultchoice;
        }

        private int askYesNo(String question, int defaultchoice) {
            if (defaultchoice == this.AUTO_ANSWER_MODE) {
                return 47;
            }
            boolean defaultanswer = defaultchoice == 1;
            try {
                System.out.print(question + " (Yes/No) [" + (defaultanswer ? "Y" : "N") + "]:");
                String rline = this.readln();
                if (rline.toLowerCase().equals("y")) {
                    return 47;
                }
                if (rline.toLowerCase().equals("n")) {
                    return 49;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (defaultchoice == -1) {
                return this.askYesNoCancel(question, defaultchoice);
            }
            return defaultchoice;
        }

        private String read() throws Exception {
            byte[] byteArray = new byte[]{(byte)System.in.read()};
            return new String(byteArray);
        }

        private String readln() throws Exception {
            String input = this.read();
            int available = System.in.available();
            if (available > 0) {
                byte[] byteArray = new byte[available];
                System.in.read(byteArray);
                input = input + new String(byteArray);
            }
            return input.trim();
        }

        public void startAction(String name, int max) {
            this.out("Processing " + name);
        }

        public void stopAction() {
            this.out(langpack.getString("InstallPanel.finished"));
        }

        public void progress(int pos, String message) {
            this.out(message);
        }

        public void nextStep(String step_name, int step_no, int no_of_substeps) {
        }

        public void setSubStepNo(int no_of_substeps) {
        }

        public void emitNotification(String text) {
        }

        public boolean emitWarning(String title, String text) {
            return this.askOKCancel(title + ": " + text, this.AUTO_ANSWER_MODE);
        }

        public void emitError(String title, String error) {
            this.out(title + ": " + error);
        }

        public int askQuestion(String title, String question, int choices) {
            return this.askQuestion(title, question, choices, this.AUTO_ANSWER_MODE);
        }

        public int askQuestion(String title, String question, int choices, int default_choice) {
            int choice = 0;
            if (choices == 37) {
                choice = this.askYesNo(title + ": " + question, default_choice);
            } else if (choices == 38) {
                choice = this.askYesNoCancel(title + ": " + question, default_choice);
            }
            return choice;
        }
    }
}

