/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.Pack;
import com.izforge.izpack.uninstaller.UninstallerConsole;
import com.izforge.izpack.uninstaller.UninstallerFrame;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Uninstaller {
    public static Pack selectedPack;
    public static boolean rollback;

    public static void cmduninstall(String[] args) {
        try {
            UninstallerConsole uco = new UninstallerConsole();
            boolean force = false;
            for (int q = 0; q < args.length; ++q) {
                if (!args[q].equals("-f")) continue;
                force = true;
            }
            System.out.println("Force deletion: " + force);
            uco.runUninstall(force);
        }
        catch (Exception err) {
            System.err.println("- Error -");
            err.printStackTrace();
            System.exit(0);
        }
    }

    public void runUninstaller(Pack pack, AbstractUIProgressHandler handler, boolean isRollback) {
        try {
            UninstallerConsole uco = new UninstallerConsole(handler);
            selectedPack = pack;
            rollback = isRollback;
            Debug.log("Rollback for " + pack.name + " : " + rollback);
            uco.runUninstall(false);
        }
        catch (Exception err) {
            System.err.println("- Error -");
            err.printStackTrace();
            System.exit(0);
        }
    }

    public static void uninstall(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    boolean displayForceOption = true;
                    boolean forceOptionState = false;
                    for (int q = 0; q < args.length; ++q) {
                        if (args[q].equals("-f")) {
                            forceOptionState = true;
                            continue;
                        }
                        if (!args[q].equals("-x")) continue;
                        displayForceOption = false;
                    }
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    new UninstallerFrame(displayForceOption, forceOptionState);
                }
                catch (Exception err) {
                    System.err.println("- Error -");
                    err.printStackTrace();
                    System.exit(0);
                }
            }
        });
    }
}

