/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.util.OsVersion;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class SelfModifier {
    public static final String BASE_KEY = "self.mod.base";
    public static final String JAR_KEY = "self.mod.jar";
    public static final String CLASS_KEY = "self.mod.class";
    public static final String METHOD_KEY = "self.mod.method";
    public static final String PHASE_KEY = "self.mod.phase";
    private String prefix = "izpack";
    private Method method = null;
    private File logFile = null;
    private File sandbox = null;
    private File jarFile = null;
    private int phase = 0;
    private SimpleDateFormat isoPoint = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Date date = new Date();
    PrintStream log = null;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String JAVA_HOME = System.getProperty("java.home");

    public static void test(String[] args) {
        try {
            File sandbox = new File(System.getProperty(BASE_KEY) + ".d");
            File randFile = new File(sandbox, "RandomAccess.tmp");
            RandomAccessFile rand = new RandomAccessFile(randFile, "rw");
            rand.writeChars("Just a test: The jvm has to close 'cuz I won't!\n");
            System.err.print("Deleting sandbox: ");
            SelfModifier.deleteTree(sandbox);
            System.err.println(sandbox.exists() ? "FAILED" : "SUCCEEDED");
        }
        catch (Exception x) {
            System.err.println(x.getMessage());
            x.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            SelfModifier selfModifier = new SelfModifier();
            if (selfModifier.phase == 2) {
                selfModifier.invoke2(args);
            } else if (selfModifier.phase == 3) {
                selfModifier.invoke3(args);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error invoking a secondary phase");
            System.err.println("Note that this program is only intended as a secondary process");
            ioe.printStackTrace();
        }
    }

    private SelfModifier() throws IOException {
        this.phase = Integer.parseInt(System.getProperty(PHASE_KEY));
        String cName = System.getProperty(CLASS_KEY);
        String tName = System.getProperty(METHOD_KEY);
        this.jarFile = new File(System.getProperty(JAR_KEY));
        this.logFile = new File(System.getProperty(BASE_KEY) + ".log");
        this.sandbox = new File(System.getProperty(BASE_KEY) + ".d");
        try {
            Class<?> clazz = Class.forName(cName);
            Method method = clazz.getMethod(tName, String[].class);
            this.initMethod(method);
        }
        catch (ClassNotFoundException x1) {
            this.log("No class found for " + cName);
        }
        catch (NoSuchMethodException x2) {
            this.log("No method " + tName + " found in " + cName);
        }
    }

    public SelfModifier(Method method) throws IOException {
        this.phase = 1;
        this.initJavaExec();
        this.initMethod(method);
    }

    private void initMethod(Method method) {
        int mod = method.getModifiers();
        if ((mod & 1) == 0 || (mod & 8) == 0) {
            throw new IllegalArgumentException("Method not public and static");
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1 || !params[0].isArray() || !"java.lang.String".equals(params[0].getComponentType().getName())) {
            throw new IllegalArgumentException("Method must accept String array");
        }
        Class<?> clazz = method.getDeclaringClass();
        mod = clazz.getModifiers();
        if ((mod & 1) == 0 || (mod & 0x200) != 0) {
            throw new IllegalArgumentException("Method must be in a public class");
        }
        this.method = method;
    }

    private void initJavaExec() throws IOException {
        try {
            Process p = Runtime.getRuntime().exec(SelfModifier.javaCommand());
            new StreamProxy(p.getErrorStream(), "err").start();
            new StreamProxy(p.getInputStream(), "out").start();
            p.getOutputStream().close();
            p.waitFor();
        }
        catch (InterruptedException ie) {
            throw new IOException("Unable to create a java subprocess");
        }
    }

    public void invoke(String[] args) throws IOException {
        while (true) {
            this.logFile = File.createTempFile(this.prefix, ".log");
            String f = this.logFile.toString();
            this.sandbox = new File(f.substring(0, f.length() - 4) + ".d");
            if (!this.sandbox.exists()) break;
            this.logFile.delete();
        }
        if (!this.sandbox.mkdir()) {
            throw new RuntimeException("Failed to create temp dir: " + this.sandbox);
        }
        this.sandbox = this.sandbox.getCanonicalFile();
        this.logFile = this.logFile.getCanonicalFile();
        this.jarFile = SelfModifier.findJarFile(this.method.getDeclaringClass()).getCanonicalFile();
        if (this.jarFile == null) {
            throw new IllegalStateException("SelfModifier must be in a jar file");
        }
        this.log("JarFile: " + this.jarFile);
        this.extractJarFile();
        if (args == null) {
            args = new String[]{};
        }
        this.spawn(args, 2);
        this.log("Exit");
        System.exit(0);
    }

    private Process spawn(String[] args, int nextPhase) throws IOException {
        String base = this.logFile.getAbsolutePath();
        base = base.substring(0, base.length() - 4);
        String[] javaCmd = new String[]{SelfModifier.javaCommand(), "-classpath", this.sandbox.getAbsolutePath(), "-Dself.mod.base=" + base, "-Dself.mod.jar=" + this.jarFile.getPath(), "-Dself.mod.class=" + this.method.getDeclaringClass().getName(), "-Dself.mod.method=" + this.method.getName(), "-Dself.mod.phase=" + nextPhase, this.getClass().getName()};
        String[] entireCmd = new String[javaCmd.length + args.length];
        System.arraycopy(javaCmd, 0, entireCmd, 0, javaCmd.length);
        System.arraycopy(args, 0, entireCmd, javaCmd.length, args.length);
        StringBuffer sb = new StringBuffer("Spawning phase ");
        sb.append(nextPhase).append(": ");
        for (int i = 0; i < entireCmd.length; ++i) {
            sb.append("\n\t").append(entireCmd[i]);
        }
        this.log(sb.toString());
        if ((double)JAVA_SPECIFICATION_VERSION < 1.3) {
            return Runtime.getRuntime().exec(entireCmd, null);
        }
        return Runtime.getRuntime().exec(entireCmd, null, null);
    }

    public static File findJarFile(Class clazz) {
        String resource = clazz.getName().replace('.', '/') + ".class";
        URL url = ClassLoader.getSystemResource(resource);
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        String path = url.getFile();
        path = path.substring(0, path.lastIndexOf(33));
        File file = (double)JAVA_SPECIFICATION_VERSION < 1.4 ? new File(SelfModifier.fromURI(path)) : new File(URI.create(path));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractJarFile() throws IOException {
        byte[] buf = new byte[5120];
        int extracted = 0;
        InputStream in = null;
        OutputStream out = null;
        String MANIFEST = "META-INF/MANIFEST.MF";
        JarFile jar = new JarFile(this.jarFile, true);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int n;
                String pathname;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || MANIFEST.equals((pathname = entry.getName()).toUpperCase())) continue;
                in = jar.getInputStream(entry);
                File outFile = new File(this.sandbox, pathname);
                File parent = outFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                out = new BufferedOutputStream(new FileOutputStream(outFile));
                while ((n = in.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, n);
                }
                out.close();
                ++extracted;
            }
            jar.close();
            this.log("Extracted " + extracted + " file" + (extracted > 1 ? "s" : "") + " into " + this.sandbox.getPath());
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException ioe) {}
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private void invoke2(String[] args) {
        int retVal = -1;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception x) {
                // empty catch block
            }
            Process p = this.spawn(args, 3);
            new StreamProxy(p.getErrorStream(), "err", this.log).start();
            new StreamProxy(p.getInputStream(), "out", this.log).start();
            p.getOutputStream().close();
            try {
                retVal = p.waitFor();
            }
            catch (InterruptedException e) {
                this.log(e);
            }
            this.log("deleteing sandbox");
            SelfModifier.deleteTree(this.sandbox);
        }
        catch (Exception e) {
            this.log(e);
        }
        this.log("Phase 3 return value = " + retVal);
    }

    public static boolean deleteTree(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                SelfModifier.deleteTree(files[i]);
            }
        }
        return file.delete();
    }

    private void invoke3(String[] args) {
        try {
            this.errlog("Invoking method: " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + "(String[] args)");
            this.method.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            this.errlog(t.getMessage());
            t.printStackTrace();
            this.errlog("exiting");
            System.err.flush();
            System.exit(31);
        }
        this.errlog("Method returned, waiting for other threads");
        System.err.flush();
    }

    private void errlog(String msg) {
        this.date.setTime(System.currentTimeMillis());
        System.err.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + msg);
    }

    private PrintStream checkLog() {
        try {
            if (this.log == null) {
                this.log = new PrintStream(new FileOutputStream(this.logFile.toString(), true));
            }
        }
        catch (IOException x) {
            System.err.println("Phase " + this.phase + " log err: " + x.getMessage());
            x.printStackTrace();
        }
        this.date.setTime(System.currentTimeMillis());
        return this.log;
    }

    private void log(Throwable t) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + t.getMessage());
            t.printStackTrace(this.log);
        }
    }

    private void log(String msg) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + msg);
        }
    }

    public static String fromURI(String uri) {
        if (!uri.startsWith("file:")) {
            throw new IllegalArgumentException("Can only handle file: URIs");
        }
        uri = uri.startsWith("file://") ? uri.substring(7) : uri.substring(5);
        uri = uri.replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        String path = sb.toString();
        return path;
    }

    private static String addExtension(String command) {
        return command + (OsVersion.IS_WINDOWS || OsVersion.IS_OS2 ? ".exe" : "");
    }

    private static String javaCommand() {
        String executable = SelfModifier.addExtension("java");
        String dir = new File(JAVA_HOME + "/bin").getAbsolutePath();
        File jExecutable = new File(dir, executable);
        if (!jExecutable.exists()) {
            return executable;
        }
        return jExecutable.getAbsolutePath();
    }

    public static class StreamProxy
    extends Thread {
        InputStream in;
        String name;
        OutputStream out;

        public StreamProxy(InputStream in, String name) {
            this(in, name, null);
        }

        public StreamProxy(InputStream in, String name, OutputStream out) {
            this.in = in;
            this.name = name;
            this.out = out;
        }

        public void run() {
            try {
                String line;
                PrintWriter pw = null;
                if (this.out != null) {
                    pw = new PrintWriter(this.out);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
                while ((line = br.readLine()) != null) {
                    if (pw == null) continue;
                    pw.println(line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

