/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.avaya.panther.framework.puur.RestoreUtil;
import com.avaya.panther.installer.AvayaHomeKeeper;
import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Version;
import com.avaya.panther.panels.AvAvayaUninstallPanelAutomationHelper;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.event.UninstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.AvayaUninstallPanel;
import com.izforge.izpack.uninstaller.Uninstaller;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.unix.ShellScript;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Destroyer
extends Thread {
    private boolean forceDestroy;
    private String installPath;
    private AbstractUIProgressHandler handler;
    private Pack selectedPack;
    private boolean rollback = false;
    private boolean cleanup = false;
    private String packUninstallerURL = null;
    JarFile jarFile = null;

    public Destroyer(String installPath, boolean forceDestroy, AbstractUIProgressHandler handler) {
        super("IzPack - Destroyer");
        this.installPath = installPath;
        this.forceDestroy = forceDestroy;
        this.handler = handler;
        this.selectedPack = Uninstaller.selectedPack;
        this.rollback = Uninstaller.rollback;
        if (handler instanceof AvayaUninstallPanel) {
            this.packUninstallerURL = ((AvayaUninstallPanel)handler).getPackUninstallerURL();
        }
        if (handler instanceof AvAvayaUninstallPanelAutomationHelper) {
            this.packUninstallerURL = ((AvAvayaUninstallPanelAutomationHelper)handler).getPackUninstallerURL();
        }
        try {
            this.jarFile = new JarFile(this.packUninstallerURL);
        }
        catch (Exception e) {
            Debug.error("Cannot find pack uninstaller \n" + e.toString());
        }
    }

    @Override
    public void run() {
        block8: {
            try {
                if (this.rollback) {
                    this.doRollback();
                } else {
                    this.doUninstallation();
                }
                if (OsVersion.IS_UNIX) {
                    this.execRootScript(this.getRootScript());
                }
                if (this.handler != null) {
                    this.handler.stopAction();
                }
            }
            catch (Exception err) {
                if (this.handler != null) {
                    this.handler.stopAction();
                }
                err.printStackTrace();
                StackTraceElement[] str = err.getStackTrace();
                for (int idx = 0; idx < str.length; ++idx) {
                }
                StringWriter trace = new StringWriter();
                err.printStackTrace(new PrintWriter(trace));
                if (this.handler == null) break block8;
                this.handler.emitError("exception caught", err.toString() + "\n" + trace.toString());
            }
        }
    }

    public void execute() {
        block6: {
            try {
                if (this.rollback) {
                    this.doRollback();
                } else {
                    this.doUninstallation();
                }
                if (OsVersion.IS_UNIX) {
                    this.execRootScript(this.getRootScript());
                }
            }
            catch (Exception err) {
                if (this.handler != null) {
                    this.handler.stopAction();
                }
                err.printStackTrace();
                StringWriter trace = new StringWriter();
                err.printStackTrace(new PrintWriter(trace));
                if (this.handler == null) break block6;
                this.handler.emitError("exception caught", err.toString() + "\n" + trace.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUninstallation() {
        try {
            List[] listeners = this.getListenerLists();
            ArrayList executables = this.getExecutablesList();
            if (this.handler != null && this.handler instanceof AvayaUninstallPanel) {
                ((AvayaUninstallPanel)this.handler).startFileExecutionAction(executables.size());
            }
            InputStream in = this.jarFile.getInputStream(this.jarFile.getJarEntry("langpack.xml"));
            LocaleDatabase langpack = new LocaleDatabase(in);
            FileExecutor executor = new FileExecutor(executables, langpack);
            executor.setProperties(this.handler, executables.size(), langpack);
            int status = executor.executeFiles(2, this.handler);
            AutomatedInstallData idata = null;
            if (this.handler instanceof AvayaUninstallPanel) {
                idata = ((AvayaUninstallPanel)this.handler).idata;
            }
            if (this.handler instanceof AvAvayaUninstallPanelAutomationHelper) {
                idata = ((AvAvayaUninstallPanelAutomationHelper)this.handler).idata;
            }
            if (status != 0) {
                Debug.fatal("File execution failed, the uninstallation was not completed.");
                if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                    System.out.println(idata.langpack.getString("uninstallation.abort") != null ? idata.langpack.getString("uninstallation.abort") : "Aborting the uninstallation.");
                    Debug.fatal("Terminating the installation without rolling back.");
                } else if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                    System.out.println(idata.langpack.getString("uninstallation.abort") != null ? idata.langpack.getString("uninstallation.abort") : "Aborting the uninstallation.");
                }
                Debug.log("Aborting the uninstallation.");
                idata.setVariable("installationCancelled", "true");
                idata.installSuccess = false;
                AvayaHomeKeeper.finalActions(idata);
                System.exit(1);
            }
            ArrayList files = this.getFilesList();
            int size = files.size();
            this.informListeners(listeners[0], 1, files, this.handler);
            if (this.handler != null) {
                this.handler.startAction("destroy", size);
            }
            for (int i = 0; i < size; ++i) {
                File file = (File)files.get(i);
                this.informListeners(listeners[1], 3, file, this.handler);
                file.delete();
                this.informListeners(listeners[1], 4, file, this.handler);
                if (this.handler == null || !(this.handler instanceof AvayaUninstallPanel)) continue;
                ((AvayaUninstallPanel)this.handler).fileProgress(i, file.getAbsolutePath());
            }
            this.informListeners(listeners[0], 2, files, this.handler);
            ArrayList<com.avaya.panther.inventory.beans.Pack> packList = new ArrayList<com.avaya.panther.inventory.beans.Pack>();
            com.avaya.panther.inventory.beans.Pack pack = new com.avaya.panther.inventory.beans.Pack(this.selectedPack.id, this.selectedPack.name);
            packList.add(pack);
            IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
            if (inventoryUtil.getInstalledPacks() != null && inventoryUtil.getInstalledPacks().size() == 1) {
                this.cleanup = true;
            }
            if (this.cleanup && !AvayaInstaller.panther.isRetainConfiguration()) {
                this.forceDestroy = true;
            }
            if (this.handler != null) {
                this.handler.progress(size, "[ performing cleanup ]");
            }
            inventoryUtil.removePacks(packList);
            this.cleanup(new File(this.installPath));
        }
        catch (Exception e) {
            AvayaInstaller.panther.setInstallStatus("warning");
            ++AvayaInstallData.install_warnings_count;
            Debug.error("Error during uninstallation - " + e.toString());
            AutomatedInstallData.getInstance().installSuccess = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback() {
        try {
            String versionInstallPath = null;
            boolean versionInstallPathFlag = true;
            String filePath = null;
            ArrayList files = this.getFilesList();
            ArrayList<ExecutableFile> executables = this.getRollbackExecutablesList();
            int size = files.size();
            Debug.log("Started::Deleting patch files.");
            if (this.handler != null) {
                this.handler.startAction("destroy", size);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.selectedPack.getVersion(), ".");
            String version = null;
            if (stringTokenizer.countTokens() > 3) {
                version = this.selectedPack.getVersion();
                version = version.substring(0, version.lastIndexOf("."));
            }
            for (int i = 0; i < size; ++i) {
                boolean canDelete = true;
                File file = (File)files.get(i);
                filePath = file.getAbsolutePath();
                if (versionInstallPathFlag && filePath.contains(File.separator + version + File.separator)) {
                    versionInstallPath = filePath.substring(0, filePath.indexOf(version)) + version;
                    versionInstallPathFlag = false;
                }
                for (ExecutableFile exe : executables) {
                    if (!exe.path.equals(file.getPath())) continue;
                    canDelete = false;
                    break;
                }
                if (!canDelete) continue;
                file.delete();
                if (this.handler == null) continue;
                this.handler.progress(i, file.getAbsolutePath());
            }
            Debug.log("Success::Deleting patch files.");
            Debug.log("Started::Restoring old files.");
            ArrayList<Pack> packList = new ArrayList<Pack>();
            packList.add(this.selectedPack);
            RestoreUtil.restore(packList, this.handler);
            Debug.log("Success::Restoring old files.");
            Debug.log("Started::Executing rollback scripts");
            if (this.handler != null && this.handler instanceof AvayaUninstallPanel) {
                ((AvayaUninstallPanel)this.handler).startFileExecutionAction(executables.size());
            }
            InputStream in = this.jarFile.getInputStream(this.jarFile.getJarEntry("langpack.xml"));
            LocaleDatabase langpack = new LocaleDatabase(in);
            FileExecutor executor = new FileExecutor(executables, langpack);
            executor.setProperties(this.handler, executables.size(), langpack);
            int status = executor.executeFiles(4, this.handler);
            AutomatedInstallData idata = null;
            if (this.handler instanceof AvayaUninstallPanel) {
                idata = ((AvayaUninstallPanel)this.handler).idata;
            }
            if (this.handler instanceof AvAvayaUninstallPanelAutomationHelper) {
                idata = ((AvAvayaUninstallPanelAutomationHelper)this.handler).idata;
            }
            if (status != 0) {
                Debug.fatal("File execution failed, the rollback was not completed.");
                if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                    System.out.println(idata.langpack.getString("rollback.abort") != null ? idata.langpack.getString("rollback.abort") : "Aborting the rollback.");
                    Debug.fatal("Terminating the installation without rolling back.");
                } else if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                    System.out.println(idata.langpack.getString("rollback.abort") != null ? idata.langpack.getString("rollback.abort") : "Aborting the rollback.");
                }
                Debug.log("Aborting the uninstallation.");
                idata.setVariable("installationCancelled", "true");
                idata.installSuccess = false;
                AvayaHomeKeeper.finalActions(idata);
                System.exit(1);
            }
            in.close();
            for (ExecutableFile exe : executables) {
                File exeFile = new File(exe.path);
                if (!exeFile.exists()) continue;
                exeFile.delete();
            }
            Debug.log("Success::Executing rollback scripts");
            IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
            Debug.log("Started::Updating inventory");
            ArrayList<Version> versionList = new ArrayList<Version>();
            versionList.add(new Version(this.selectedPack.getVersion()));
            if (AvayaInstallerBase.getVersionType(this.selectedPack.getVersion()).equals("PATCH")) {
                inventoryUtil.removePatchVersion(this.selectedPack.id, versionList);
            } else {
                inventoryUtil.removePackVersion(this.selectedPack.id, versionList);
            }
            Debug.log("Success::Updating inventory");
            if (versionInstallPath != null) {
                this.cleanup(new File(versionInstallPath));
            }
        }
        catch (Exception e) {
            AvayaInstaller.panther.setInstallStatus("warning");
            ++AvayaInstallData.install_warnings_count;
            Debug.error("Error while rollback - " + e.toString());
            AutomatedInstallData.getInstance().installSuccess = false;
        }
    }

    private ArrayList getFilesList() throws Exception {
        TreeSet files = new TreeSet(Collections.reverseOrder());
        InputStream in = this.jarFile.getInputStream(this.jarFile.getJarEntry(this.selectedPack.id + "-" + this.selectedPack.getVersion() + ".log"));
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        reader.readLine();
        String read = reader.readLine();
        if (this.selectedPack != null) {
            while (read != null) {
                if (read.indexOf(":") > -1 && this.selectedPack.id.equalsIgnoreCase(read.substring(read.indexOf(":") + 1))) {
                    read = reader.readLine();
                    while (read != null && !read.startsWith("Pack Name")) {
                        if (read.endsWith("|true")) {
                            if (!AvayaInstaller.panther.isRetainConfiguration()) {
                                read = read.substring(0, read.indexOf("|"));
                                files.add(new File(read));
                            }
                        } else {
                            files.add(new File(read));
                        }
                        read = reader.readLine();
                    }
                    continue;
                }
                read = reader.readLine();
            }
        } else {
            while (read != null) {
                if (read.endsWith("|true") && !AvayaInstaller.panther.isRetainConfiguration()) {
                    files.add(new File(read));
                }
                read = reader.readLine();
            }
        }
        in.close();
        return new ArrayList(files);
    }

    private ArrayList getExecutablesList() throws Exception {
        ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
        ObjectInputStream in = new ObjectInputStream(this.jarFile.getInputStream(this.jarFile.getJarEntry("executables")));
        int num = in.readInt();
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        for (int i = 0; i < num; ++i) {
            ExecutableFile file = (ExecutableFile)in.readObject();
            if (!(file.isUninstallFlag() && AvayaInstaller.panther.isDoNotExecuteOnUninstall() || !this.selectedPack.id.equals(file.packId))) {
                List argList = file.argList;
                ArrayList<String> parsedArgList = new ArrayList<String>();
                for (String arg : argList) {
                    arg = IoHelper.translatePath(arg, vs);
                    parsedArgList.add(arg);
                }
                file.argList.clear();
                file.argList.addAll(parsedArgList);
                executables.add(file);
            }
            Debug.log("Executable: " + file.path + " ,Uninstall Flag: " + file.isUninstallFlag());
        }
        in.close();
        return executables;
    }

    private ArrayList<ExecutableFile> getRollbackExecutablesList() throws Exception {
        ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
        if (this.selectedPack == null) {
            return executables;
        }
        ObjectInputStream in = new ObjectInputStream(this.jarFile.getInputStream(this.jarFile.getJarEntry("rollbackExecutables")));
        int num = in.readInt();
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        for (int i = 0; i < num; ++i) {
            ExecutableFile file = (ExecutableFile)in.readObject();
            if (!this.selectedPack.id.equals(file.packId)) continue;
            List argList = file.argList;
            ArrayList<String> parsedArgList = new ArrayList<String>();
            for (String arg : argList) {
                arg = IoHelper.translatePath(arg, vs);
                parsedArgList.add(arg);
            }
            file.argList.clear();
            file.argList.addAll(parsedArgList);
            executables.add(file);
        }
        in.close();
        return executables;
    }

    private String getRootScript() throws Exception {
        String result = "";
        ObjectInputStream in = new ObjectInputStream(this.jarFile.getInputStream(this.jarFile.getJarEntry("rootscript")));
        result = in.readUTF();
        return result;
    }

    private void execRootScript(String aRootScript) {
        if (!"".equals(aRootScript)) {
            Debug.log("Will Execute: " + aRootScript);
            try {
                String result = ShellScript.execAndDelete(new StringBuffer(aRootScript), File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".sh").toString());
                Debug.log("Result: " + result);
            }
            catch (Exception ex) {
                Debug.log("Exeption during su remove: " + ex.getMessage());
            }
        }
    }

    private void cleanup(File file) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                this.cleanup(files[i]);
            }
            file.delete();
        }
    }

    private List[] getListenerLists() throws Exception {
        List[] uninstaller = new ArrayList[]{new ArrayList(), new ArrayList()};
        InputStream in = this.jarFile.getInputStream(this.jarFile.getJarEntry("uninstallerListeners"));
        if (in != null) {
            ObjectInputStream objIn = new ObjectInputStream(in);
            List listeners = (List)objIn.readObject();
            objIn.close();
            Iterator iter = listeners.iterator();
            while (iter != null && iter.hasNext()) {
                Class<?> clazz = Class.forName((String)iter.next());
                UninstallerListener ul = (UninstallerListener)clazz.newInstance();
                if (ul.isFileListener()) {
                    ((ArrayList)uninstaller[1]).add(ul);
                }
                ((ArrayList)uninstaller[0]).add(ul);
            }
        }
        return uninstaller;
    }

    private void informListeners(List listeners, int action, Object param, AbstractUIProgressHandler handler) {
        Iterator iter = listeners.iterator();
        UninstallerListener il = null;
        while (iter.hasNext()) {
            try {
                il = (UninstallerListener)iter.next();
                switch (action) {
                    case 1: {
                        il.beforeDeletion((List)param, handler);
                        break;
                    }
                    case 2: {
                        il.afterDeletion((List)param, handler);
                        break;
                    }
                    case 3: {
                        il.beforeDelete((File)param, handler);
                        break;
                    }
                    case 4: {
                        il.afterDelete((File)param, handler);
                    }
                }
            }
            catch (Throwable e) {
                handler.emitError("Skipping custom action because exception caught during " + il.getClass().getName(), e.toString());
            }
        }
    }
}

