/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.AndCondition;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.JavaCondition;
import com.izforge.izpack.rules.NotCondition;
import com.izforge.izpack.rules.OrCondition;
import com.izforge.izpack.rules.PackselectionCondition;
import com.izforge.izpack.rules.XOrCondition;
import com.izforge.izpack.util.Debug;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class RulesEngine {
    protected Map panelconditions;
    protected Map packconditions;
    protected Map optionalpackconditions;
    protected XMLElement conditionsspec;
    protected static Map conditionsmap = new Hashtable();
    protected static AutomatedInstallData installdata;

    private RulesEngine() {
        conditionsmap = new Hashtable();
        this.panelconditions = new Hashtable();
        this.packconditions = new Hashtable();
        this.optionalpackconditions = new Hashtable();
    }

    private void init() {
        this.createBuiltinOsCondition("IS_WINDOWS", "izpack.windowsinstall");
        this.createBuiltinOsCondition("IS_LINUX", "izpack.linuxinstall");
        this.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        this.createBuiltinOsCondition("IS_MAC", "izpack.macinstall");
        this.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        this.createBuiltinOsCondition("IS_SUNOS_X86", "izpack.solarisinstall.x86");
        this.createBuiltinOsCondition("IS_SUNOS_SPARC", "izpack.solarisinstall.sparc");
        if (installdata != null && RulesEngine.installdata.allPacks != null) {
            for (Pack pack : RulesEngine.installdata.allPacks) {
                if (pack.id == null) continue;
                PackselectionCondition packselcond = new PackselectionCondition();
                packselcond.setInstalldata(installdata);
                packselcond.id = "izpack.selected." + pack.id;
                packselcond.packid = pack.id;
                conditionsmap.put(packselcond.id, packselcond);
            }
        }
    }

    private void createBuiltinOsCondition(String osVersionField, String conditionId) {
        JavaCondition condition = new JavaCondition();
        condition.setInstalldata(installdata);
        condition.id = conditionId;
        condition.classname = "com.izforge.izpack.util.OsVersion";
        condition.fieldname = osVersionField;
        condition.returnvalue = "true";
        condition.returnvaluetype = "boolean";
        condition.complete = true;
        conditionsmap.put(condition.id, condition);
    }

    public RulesEngine(XMLElement conditionsspecxml, AutomatedInstallData installdata) {
        this();
        this.conditionsspec = conditionsspecxml;
        RulesEngine.installdata = installdata;
        this.init();
        this.readConditions();
    }

    public RulesEngine(Map rules, AutomatedInstallData installdata) {
        this();
        RulesEngine.installdata = installdata;
        conditionsmap = rules;
        Iterator keyiter = conditionsmap.keySet().iterator();
        this.init();
        while (keyiter.hasNext()) {
            String key = (String)keyiter.next();
            Condition condition = (Condition)conditionsmap.get(key);
            condition.setInstalldata(installdata);
        }
    }

    public String[] getKnownConditionIds() {
        Object[] conditionids = conditionsmap.keySet().toArray(new String[conditionsmap.size()]);
        Arrays.sort(conditionids);
        return conditionids;
    }

    protected boolean checkAttribute(String val, String attribute, String element) {
        if (val != null && val.length() > 0) {
            return true;
        }
        Debug.trace("Element " + element + " has to specify an attribute " + attribute);
        return false;
    }

    public static Condition analyzeCondition(XMLElement condition) {
        String condid = condition.getAttribute("id");
        String condtype = condition.getAttribute("type");
        Condition result = null;
        if (condtype != null) {
            String conditionclassname = "";
            if (condtype.indexOf(46) > -1) {
                conditionclassname = condtype;
            } else {
                String conditiontype = condtype.toLowerCase();
                conditionclassname = "com.izforge.izpack.rules." + conditiontype.substring(0, 1).toUpperCase() + conditiontype.substring(1, conditiontype.length());
                conditionclassname = conditionclassname + "Condition";
            }
            ClassLoader loader = RulesEngine.class.getClassLoader();
            try {
                Class<?> conditionclass = loader.loadClass(conditionclassname);
                result = (Condition)conditionclass.newInstance();
                result.readFromXML(condition);
                result.setId(condid);
                result.setInstalldata(installdata);
            }
            catch (ClassNotFoundException e) {
                Debug.trace(conditionclassname + " not found.");
            }
            catch (InstantiationException e) {
                Debug.trace(conditionclassname + " couldn't be instantiated.");
            }
            catch (IllegalAccessException e) {
                Debug.trace("Illegal access to " + conditionclassname);
            }
        }
        return result;
    }

    protected void readConditions() {
        if (this.conditionsspec == null) {
            Debug.trace("No specification for conditions found.");
            return;
        }
        try {
            if (this.conditionsspec.hasChildren()) {
                Vector childs = this.conditionsspec.getChildrenNamed("condition");
                for (int i = 0; i < childs.size(); ++i) {
                    XMLElement condition = (XMLElement)childs.get(i);
                    Condition cond = RulesEngine.analyzeCondition(condition);
                    if (cond == null) continue;
                    String condid = cond.getId();
                    cond.setInstalldata(installdata);
                    if (condid == null || "UNKNOWN".equals(condid)) continue;
                    conditionsmap.put(condid, cond);
                }
                Vector panelconditionels = this.conditionsspec.getChildrenNamed("panelcondition");
                for (int i = 0; i < panelconditionels.size(); ++i) {
                    XMLElement panelel = (XMLElement)panelconditionels.get(i);
                    String panelid = panelel.getAttribute("panelid");
                    String conditionid = panelel.getAttribute("conditionid");
                    this.panelconditions.put(panelid, conditionid);
                }
                Vector packconditionels = this.conditionsspec.getChildrenNamed("packcondition");
                for (int i = 0; i < packconditionels.size(); ++i) {
                    boolean optionalinstall;
                    XMLElement panelel = (XMLElement)packconditionels.get(i);
                    String panelid = panelel.getAttribute("packid");
                    String conditionid = panelel.getAttribute("conditionid");
                    this.packconditions.put(panelid, conditionid);
                    String optional = panelel.getAttribute("optional");
                    if (optional == null || !(optionalinstall = Boolean.valueOf(optional).booleanValue())) continue;
                    this.optionalpackconditions.put(panelid, conditionid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Condition getCondition(String id) {
        Condition result = (Condition)conditionsmap.get(id);
        if (result == null) {
            result = RulesEngine.getConditionByExpr(new StringBuffer(id));
        }
        return result;
    }

    protected static Condition getConditionByExpr(StringBuffer conditionexpr) {
        Condition result = null;
        block6: for (int index = 0; index < conditionexpr.length(); ++index) {
            char currentchar = conditionexpr.charAt(index);
            switch (currentchar) {
                case '+': {
                    Condition op1 = (Condition)conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new AndCondition(op1, RulesEngine.getConditionByExpr(conditionexpr));
                    result.setInstalldata(installdata);
                    continue block6;
                }
                case '|': {
                    Condition op1 = (Condition)conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new OrCondition(op1, RulesEngine.getConditionByExpr(conditionexpr));
                    result.setInstalldata(installdata);
                    continue block6;
                }
                case '\\': {
                    Condition op1 = (Condition)conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new XOrCondition(op1, RulesEngine.getConditionByExpr(conditionexpr));
                    result.setInstalldata(installdata);
                    continue block6;
                }
                case '!': {
                    if (index > 0) {
                        Debug.trace("error: ! operator only allowed at position 0");
                        continue block6;
                    }
                    conditionexpr.deleteCharAt(index);
                    result = new NotCondition(RulesEngine.getConditionByExpr(conditionexpr));
                    result.setInstalldata(installdata);
                    continue block6;
                }
            }
        }
        if (conditionexpr.length() > 0 && (result = (Condition)conditionsmap.get(conditionexpr.toString())) != null) {
            result.setInstalldata(installdata);
            conditionexpr.delete(0, conditionexpr.length());
        }
        return result;
    }

    public boolean isConditionTrue(String id, Properties variables) {
        Condition cond = RulesEngine.getCondition(id);
        if (cond == null) {
            Debug.trace("Condition (" + id + ") not found.");
            return true;
        }
        Debug.trace("Checking condition");
        try {
            return cond.isTrue();
        }
        catch (NullPointerException npe) {
            Debug.error("Nullpointerexception checking condition: " + id);
            return false;
        }
    }

    public boolean isConditionTrue(Condition cond, Properties variables) {
        if (cond == null) {
            Debug.trace("Condition not found.");
            return true;
        }
        Debug.trace("Checking condition");
        return cond.isTrue();
    }

    public boolean isConditionTrue(String id) {
        Condition cond = RulesEngine.getCondition(id);
        if (cond != null) {
            return this.isConditionTrue(cond);
        }
        return false;
    }

    public boolean isConditionTrue(Condition cond) {
        return cond.isTrue();
    }

    public boolean canShowPanel(String panelid, Properties variables) {
        Debug.trace("can show panel with id " + panelid + " ?");
        if (!this.panelconditions.containsKey(panelid)) {
            Debug.trace("no condition, show panel");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = RulesEngine.getCondition((String)this.panelconditions.get(panelid));
        if (condition != null) {
            return condition.isTrue();
        }
        return false;
    }

    public boolean canInstallPack(String packid, Properties variables) {
        if (packid == null) {
            return true;
        }
        Debug.trace("can install pack with id " + packid + "?");
        if (!this.packconditions.containsKey(packid)) {
            Debug.trace("no condition, can install pack");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = RulesEngine.getCondition((String)this.packconditions.get(packid));
        if (condition != null) {
            return condition.isTrue();
        }
        return false;
    }

    public boolean canInstallPackOptional(String packid, Properties variables) {
        Debug.trace("can install pack optional with id " + packid + "?");
        if (!this.optionalpackconditions.containsKey(packid)) {
            Debug.trace("not in optionalpackconditions.");
            return false;
        }
        Debug.trace("optional install possible");
        return true;
    }
}

