/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import net.n3.nanoxml.XMLElement;

public class NotCondition
extends Condition {
    private static final long serialVersionUID = 3194843222487006309L;
    protected Condition operand;

    public NotCondition() {
    }

    public NotCondition(Condition operand) {
        this.operand = operand;
    }

    public void readFromXML(XMLElement xmlcondition) {
        try {
            if (xmlcondition.getChildrenCount() != 1) {
                Debug.log("not-condition needs one condition as operand");
                return;
            }
            this.operand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(0));
        }
        catch (Exception e) {
            Debug.log("missing element in not-condition");
        }
    }

    public boolean isTrue() {
        return !this.operand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on:<ul><li>NOT ");
        details.append(this.operand.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }
}

