/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.UserPathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class UserPathInputPanel
extends IzPanel
implements ActionListener {
    private InstallerFrame _parent;
    private InstallData _idata;
    private static final long serialVersionUID = 3257566217698292531L;
    protected boolean _mustExist = false;
    protected boolean _loadedDefaultDir = false;
    protected String[] _existFiles = null;
    protected UserPathSelectionPanel _pathSelectionPanel;
    protected String _error;
    protected String _warn;
    protected String _emptyTargetMsg;
    protected String _warnMsg;
    protected String _reqMsg;
    protected String _notValidMsg;
    protected String _notWritableMsg;
    protected String _createDirMsg;
    protected String _defaultDir = null;
    protected String _thisPanel = "UserPathInputPanel";
    protected String _defaultPanelName = "TargetPanel";
    protected String _targetPanel = "UserPathPanel";
    protected String _variableName = "pathVariable";

    public UserPathInputPanel(InstallerFrame parent, InstallData idata, String targetPanel, String variableName) {
        super(parent, idata, new IzPanelLayout());
        this._parent = parent;
        this._idata = idata;
        this._targetPanel = targetPanel;
        this._variableName = variableName;
        this.loadMessages();
        String introText = this.getI18nStringForClass("extendedIntro", this._thisPanel);
        if ((introText == null || introText.endsWith("extendedIntro") || introText.indexOf(36) > -1) && ((introText = this.getI18nStringForClass("intro", this._thisPanel)) == null || introText.endsWith("intro"))) {
            introText = "";
        }
        this.add(this.createMultiLineLabel(introText));
        this.add(IzPanelLayout.createParagraphGap());
        this.add((Component)this.createLabel("info", this._targetPanel, "open", 2, true), "nextLine");
        this._pathSelectionPanel = new UserPathSelectionPanel(this, idata, this._targetPanel, this._variableName);
        this.add((Component)this._pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public void createLayoutBottom() {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    private void loadMessages() {
        this._error = this.parent.langpack.getString("installer.error");
        this._warn = this.parent.langpack.getString("installer.warning");
        this._reqMsg = this.getMessage("required");
        this._emptyTargetMsg = this.getMessage("empty_target");
        this._warnMsg = this.getMessage("exists_warn");
        this._notValidMsg = this.getMessage("notValid");
        this._notWritableMsg = this.getMessage("notwritable");
        this._createDirMsg = this.getMessage("createdir");
    }

    private String getMessage(String type) {
        String msg = null;
        msg = this.getI18nStringForClass(type, this._targetPanel);
        if (msg == null) {
            msg = this.getI18nStringForClass(type, this._defaultPanelName);
        }
        return msg;
    }

    public boolean isValidated() {
        String chosenPath = this._pathSelectionPanel.getPath();
        boolean ok = true;
        if (chosenPath.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this._error, this._reqMsg);
                return false;
            }
            ok = this.emitWarning(this._warn, this._emptyTargetMsg);
        }
        if (!ok) {
            return ok;
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        this._pathSelectionPanel.setPath(chosenPath);
        if (this.isMustExist()) {
            if (!path.exists()) {
                this.emitError(this._error, this._reqMsg);
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this._error, this._notValidMsg);
                return false;
            }
        } else {
            int res;
            if (!this.isWriteable()) {
                this.emitError(this._error, this._notWritableMsg);
                return false;
            }
            ok = path.exists() ? (res = this.askQuestion(this._warn, this._warnMsg, 37, 47)) == 47 : this.emitNotificationFeedback(this._createDirMsg + "\n" + chosenPath);
        }
        return ok;
    }

    protected boolean pathIsValid() {
        if (this._existFiles == null) {
            return true;
        }
        for (int i = 0; i < this._existFiles.length; ++i) {
            File path = new File(this._pathSelectionPanel.getPath(), this._existFiles[i]).getAbsoluteFile();
            if (path.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isMustExist() {
        return this._mustExist;
    }

    public void setMustExist(boolean b) {
        this._mustExist = b;
    }

    public String[] getExistFiles() {
        return this._existFiles;
    }

    public void setExistFiles(String[] strings) {
        this._existFiles = strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultDir() {
        if (!this._loadedDefaultDir) {
            BufferedReader br = null;
            try {
                InputStream in = null;
                if (OsVersion.IS_WINDOWS) {
                    try {
                        in = this._parent.getResource(this._targetPanel + ".dir.windows");
                    }
                    catch (ResourceNotFoundException rnfe) {}
                } else if (OsVersion.IS_OSX) {
                    try {
                        in = this._parent.getResource(this._targetPanel + ".dir.macosx");
                    }
                    catch (ResourceNotFoundException rnfe) {}
                } else {
                    String os = System.getProperty("os.name");
                    os = os.replace(' ', '_');
                    os = os.toLowerCase();
                    try {
                        in = this._parent.getResource(this._targetPanel + ".dir.".concat(os));
                    }
                    catch (ResourceNotFoundException rnfe) {
                        // empty catch block
                    }
                    if (in == null) {
                        try {
                            in = this._parent.getResource(this._targetPanel + ".dir.unix");
                        }
                        catch (ResourceNotFoundException eee) {
                            // empty catch block
                        }
                    }
                }
                if (in == null) {
                    try {
                        in = this._parent.getResource(this._targetPanel + ".dir");
                    }
                    catch (ResourceNotFoundException eee) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    String line;
                    InputStreamReader isr = new InputStreamReader(in);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null && "".equals(line = line.trim())) {
                    }
                    this._defaultDir = line;
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    this._defaultDir = vs.substitute(this._defaultDir, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this._defaultDir = null;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this._loadedDefaultDir = true;
    }

    public boolean isWriteable() {
        File existParent = IoHelper.existingParent(new File(this._pathSelectionPanel.getPath()));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public String getDefaultDir() {
        if (this._defaultDir == null && !this._loadedDefaultDir) {
            this.loadDefaultDir();
        }
        return this._defaultDir;
    }

    public void setDefaultDir(String string) {
        this._defaultDir = string;
    }

    public String getTargetPanel() {
        return this._targetPanel;
    }

    public void setTargetPanel(String string) {
        this._targetPanel = string;
    }
}

