/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class TextInputField
extends JComponent
implements ProcessingClient {
    private static final long serialVersionUID = 8611515659787697087L;
    private Map validatorParams;
    private Validator validationService;
    private JTextField field;
    private String variable = null;
    private boolean hasParams = false;

    public TextInputField(String set, int size, String validator, Map validatorParams, String variable) {
        this(set, size, validator, variable);
        this.validatorParams = validatorParams;
        this.hasParams = true;
        this.variable = variable;
        this.variable = variable;
    }

    public TextInputField(String set, int size, String validator, String variable) {
        try {
            if (validator != null) {
                this.validationService = (Validator)Class.forName(validator).newInstance();
            }
        }
        catch (Throwable exception) {
            this.validationService = null;
            Debug.trace(exception);
        }
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(3);
        layout.setVgap(0);
        this.setLayout(layout);
        this.variable = variable;
        this.field = new JTextField(set, size);
        this.field.setCaretPosition(0);
        this.add(this.field);
    }

    public Map getValidatorParams() {
        return this.validatorParams;
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String value) {
        this.field.setText(value);
    }

    public String getFieldContents(int index) {
        return this.field.getText();
    }

    public int getNumFields() {
        return 1;
    }

    public boolean validateContents() {
        if (this.validationService != null) {
            return this.validationService.validate(this);
        }
        return true;
    }

    public boolean hasParams() {
        return this.hasParams;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }
}

