/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RuleTextField;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.regexp.RE;

public class RuleInputField
extends JComponent
implements KeyListener,
FocusListener,
CaretListener,
ProcessingClient {
    private static final long serialVersionUID = 3832616275124958257L;
    public static final int PLAIN_STRING = 1;
    public static final int DISPLAY_FORMAT = 2;
    public static final int SPECIAL_SEPARATOR = 3;
    public static final int ENCRYPTED = 4;
    private static int DEFAULT = 2;
    private Vector items = new Vector();
    private Vector inputFields = new Vector();
    private boolean hasParams = false;
    private Map validatorParams;
    private RuleTextField activeField;
    private boolean backstep = false;
    private Toolkit toolkit;
    private String separator;
    private int resultFormat = DEFAULT;
    private InstallData idata = null;
    public Validator validationService;
    private Processor encryptionService;
    String variable = null;

    public boolean hasParams() {
        return this.hasParams;
    }

    public RuleInputField(String format, String preset, String separator, String validator, Map validatorParams, String processor, int resultFormat, Toolkit toolkit, InstallData idata, String variable) {
        this(format, preset, separator, validator, processor, resultFormat, toolkit, idata, variable);
        this.validatorParams = validatorParams;
        this.hasParams = true;
        this.variable = variable;
    }

    public RuleInputField(String format, String preset, String separator, String validator, String processor, int resultFormat, Toolkit toolkit, InstallData idata, String variable) {
        this.toolkit = toolkit;
        this.separator = separator;
        this.resultFormat = resultFormat;
        this.idata = idata;
        this.variable = variable;
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        this.setLayout(layout);
        try {
            if (validator != null) {
                this.validationService = (Validator)Class.forName(validator).newInstance();
            }
        }
        catch (Throwable exception) {
            this.validationService = null;
            Debug.trace(exception);
        }
        try {
            if (processor != null) {
                this.encryptionService = (Processor)Class.forName(processor).newInstance();
            }
        }
        catch (Throwable exception) {
            this.encryptionService = null;
            Debug.trace(exception);
        }
        this.createItems(format);
        if (preset != null && preset.length() > 0) {
            this.setFields(preset);
        }
        this.activeField = (RuleTextField)this.inputFields.elementAt(0);
        this.activeField.grabFocus();
    }

    public int getNumFields() {
        return this.inputFields.size();
    }

    public String getFieldContents(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.inputFields.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return ((JTextField)this.inputFields.elementAt(index)).getText();
    }

    public Map getValidatorParams() {
        return this.validatorParams;
    }

    public String getText() {
        StringBuffer buffer;
        block7: {
            int size;
            block9: {
                block8: {
                    block6: {
                        buffer = new StringBuffer();
                        size = this.inputFields.size();
                        if (this.resultFormat != 4) break block6;
                        if (this.encryptionService != null) {
                            buffer.append(this.encryptionService.process(this));
                        } else {
                            this.resultFormat = DEFAULT;
                        }
                        break block7;
                    }
                    if (this.resultFormat != 1) break block8;
                    for (int i = 0; i < this.inputFields.size(); ++i) {
                        buffer.append(((JTextField)this.inputFields.elementAt(i)).getText());
                    }
                    break block7;
                }
                if (this.resultFormat != 2) break block9;
                for (int i = 0; i < this.items.size(); ++i) {
                    Object item = this.items.elementAt(i);
                    if (item instanceof JTextField) {
                        buffer.append(((JTextField)item).getText());
                        continue;
                    }
                    buffer.append((String)item);
                }
                break block7;
            }
            if (this.resultFormat != 3) break block7;
            for (int i = 0; i < size; ++i) {
                buffer.append(((JTextField)this.inputFields.elementAt(i)).getText());
                if (i >= size - 1) continue;
                buffer.append(this.separator);
            }
        }
        return buffer.toString();
    }

    private void createItems(String format) {
        Object item;
        StringTokenizer tokenizer = new StringTokenizer(format);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                FieldSpec spec = new FieldSpec(token);
                RuleTextField field = new RuleTextField(spec.getColumns(), spec.getEditLength(), spec.getType(), spec.getUnlimitedEdit(), this.toolkit);
                if (this.items.size() > 0 && (item = this.items.lastElement()) instanceof JTextField) {
                    this.items.add(" ");
                }
                this.items.add(field);
                this.inputFields.add(field);
                field.addFocusListener(this);
                field.addKeyListener(this);
                field.addCaretListener(this);
            }
            catch (Throwable exception) {
                if (this.items.size() == 0) {
                    this.items.add(token);
                    continue;
                }
                item = this.items.lastElement();
                if (item instanceof String) {
                    this.items.setElementAt(item + " " + token, this.items.size() - 1);
                    continue;
                }
                this.items.add(token);
            }
        }
        for (int i = 0; i < this.items.size(); ++i) {
            item = this.items.elementAt(i);
            if (item instanceof String) {
                this.add(new JLabel((String)item));
                continue;
            }
            this.add((JTextField)item);
        }
    }

    private void setFields(String data) {
        String className;
        String val;
        int index;
        String indexString;
        String token;
        StringTokenizer tokenizer = new StringTokenizer(data);
        boolean process = false;
        String[] vals = null;
        int i = 0;
        vals = new String[tokenizer.countTokens()];
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            indexString = token.substring(0, token.indexOf(58));
            try {
                index = Integer.parseInt(indexString);
                if (index >= this.inputFields.size()) continue;
                val = token.substring(token.indexOf(58) + 1, token.length());
                className = "";
                if (val.indexOf(":") > -1) {
                    className = val.substring(val.indexOf(":") + 1);
                    val = val.substring(0, val.indexOf(":"));
                }
                if (!"".equals(className) && !process) {
                    process = true;
                }
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                val = vs.substitute(val, null);
                if (this.idata.getVariable(this.variable) != null) {
                    val = this.idata.getVariable(this.variable);
                }
                vals[i] = val;
                ++i;
                if (val.contains("$")) {
                    val = "";
                }
                ((JTextField)this.inputFields.elementAt(index)).setText(val);
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
        if (process) {
            tokenizer = new StringTokenizer(data);
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                indexString = token.substring(0, token.indexOf(58));
                try {
                    index = Integer.parseInt(indexString);
                    if (index >= this.inputFields.size()) continue;
                    val = token.substring(token.indexOf(58) + 1, token.length());
                    className = "";
                    String presult = "";
                    if (val.indexOf(":") > -1) {
                        className = val.substring(val.indexOf(":") + 1);
                        val = val.substring(0, val.indexOf(":"));
                    }
                    if (!"".equals(className)) {
                        Processor p = (Processor)Class.forName(className).newInstance();
                        presult = p.process(this);
                    }
                    String[] td = new RE("\\*").split(presult);
                    ((JTextField)this.inputFields.elementAt(index)).setText(td[index]);
                }
                catch (Throwable exception) {}
            }
        }
    }

    public boolean validateContents() {
        if (this.validationService != null) {
            this.idata.setAttribute("specRuleFieldVarName", this.variable);
            return this.validationService.validate(this);
        }
        return true;
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        int activeIndex;
        int caretPosition;
        if (event.getKeyCode() == 8 && (caretPosition = this.activeField.getCaretPosition()) == 0 && (activeIndex = this.inputFields.indexOf(this.activeField)) > 0) {
            this.backstep = true;
            this.activeField = (RuleTextField)this.inputFields.elementAt(--activeIndex);
            this.activeField.grabFocus();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void focusGained(FocusEvent event) {
        this.activeField = (RuleTextField)event.getSource();
        if (this.backstep) {
            this.activeField.setCaretPosition(this.activeField.getText().length());
            this.backstep = false;
        } else {
            this.activeField.selectAll();
        }
    }

    public void focusLost(FocusEvent event) {
    }

    public void caretUpdate(CaretEvent event) {
        if (this.activeField != null) {
            String text = this.activeField.getText();
            int fieldSize = this.activeField.getEditLength();
            int caretPosition = this.activeField.getCaretPosition();
            int selection = this.activeField.getSelectionEnd() - this.activeField.getSelectionStart();
            if (!(this.inputFields.lastElement().equals(this.activeField) || this.activeField.unlimitedEdit() || text.length() != fieldSize || selection != 0 || caretPosition != fieldSize || this.backstep)) {
                this.activeField.transferFocus();
            }
        }
    }

    private static class FieldSpec {
        private int MIN_TOKENS = 2;
        private int MAX_TOKENS = 3;
        private int type;
        private int columns;
        private int editLength;
        private boolean unlimitedEdit = false;

        public FieldSpec(String spec) throws Exception {
            StringTokenizer tokenizer = new StringTokenizer(spec, ":");
            if (tokenizer.countTokens() >= this.MIN_TOKENS && tokenizer.countTokens() <= this.MAX_TOKENS) {
                String token = tokenizer.nextToken().toUpperCase();
                if ("N".equals(token)) {
                    this.type = 1;
                } else if ("H".equals(token)) {
                    this.type = 2;
                } else if ("A".equals(token)) {
                    this.type = 3;
                } else if ("O".equals(token)) {
                    this.type = 4;
                } else if ("AN".equals(token)) {
                    this.type = 5;
                } else {
                    throw new Exception();
                }
                try {
                    token = tokenizer.nextToken();
                    this.columns = Integer.parseInt(token);
                }
                catch (Throwable exception) {
                    throw new Exception();
                }
                try {
                    token = tokenizer.nextToken().toUpperCase();
                    this.editLength = Integer.parseInt(token);
                }
                catch (Throwable exception) {
                    if ("U".equals(token)) {
                        this.unlimitedEdit = true;
                    }
                    throw new Exception();
                }
            } else {
                throw new Exception();
            }
        }

        public int getColumns() {
            return this.columns;
        }

        public int getEditLength() {
            return this.editLength;
        }

        public int getType() {
            return this.type;
        }

        public boolean getUnlimitedEdit() {
            return this.unlimitedEdit;
        }
    }
}

