/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPasswordField;

public class PasswordGroup
implements ProcessingClient {
    private Vector fields = new Vector();
    private List validatorContainers = null;
    private Processor processor = null;
    private int currentValidator = 0;
    String confirmationID = null;
    String fieldId = null;
    private InstallData idata;

    public PasswordGroup(InstallData idata, List validatorContainers, String processor) {
        try {
            this.idata = idata;
            this.validatorContainers = validatorContainers;
        }
        catch (Throwable exception) {
            this.validatorContainers = null;
        }
        try {
            this.processor = (Processor)Class.forName(processor).newInstance();
        }
        catch (Throwable exception) {
            this.processor = null;
        }
    }

    public InstallData getIdata() {
        return this.idata;
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public String getFieldContents(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.fields.size()) {
            throw new IndexOutOfBoundsException();
        }
        String contents = new String(((JPasswordField)this.fields.elementAt(index)).getPassword());
        return contents;
    }

    public void addField(JPasswordField field) {
        if (field != null) {
            this.fields.add(field);
        }
    }

    public boolean validateContents(int i) {
        boolean returnValue = true;
        try {
            this.currentValidator = i;
            ValidatorContainer container = this.getValidatorContainer(i);
            Validator validator = container.getValidator();
            if (validator != null) {
                returnValue = validator.validate(this);
            }
        }
        catch (Exception e) {
            System.out.println("validateContents(" + i + ") failed: " + e);
        }
        return returnValue;
    }

    public String getValidatorMessage(int i) {
        String returnValue = null;
        try {
            ValidatorContainer container = this.getValidatorContainer(i);
            if (container != null) {
                returnValue = container.getMessage();
            }
        }
        catch (Exception e) {
            System.out.println("getValidatorMessage(" + i + ") failed: " + e);
        }
        return returnValue;
    }

    public int validatorSize() {
        int size = 0;
        if (this.validatorContainers != null) {
            size = this.validatorContainers.size();
        }
        return size;
    }

    public ValidatorContainer getValidatorContainer() {
        return this.getValidatorContainer(this.currentValidator);
    }

    public ValidatorContainer getValidatorContainer(int i) {
        ValidatorContainer container = null;
        try {
            container = (ValidatorContainer)this.validatorContainers.get(i);
        }
        catch (Exception e) {
            container = null;
        }
        return container;
    }

    public boolean hasParams() {
        return this.hasParams(this.currentValidator);
    }

    public boolean hasParams(int i) {
        boolean returnValue = false;
        try {
            ValidatorContainer container = this.getValidatorContainer(i);
            if (container != null) {
                returnValue = container.hasParams();
            }
        }
        catch (Exception e) {
            System.out.println("hasParams(" + i + ") failed: " + e);
        }
        return returnValue;
    }

    public Map getValidatorParams() {
        return this.getValidatorParams(this.currentValidator);
    }

    public Map getValidatorParams(int i) {
        Map returnValue = null;
        try {
            ValidatorContainer container = this.getValidatorContainer(i);
            if (container != null) {
                returnValue = container.getValidatorParams();
            }
        }
        catch (Exception e) {
            System.out.println("getValidatorParams(" + i + ") failed: " + e);
        }
        return returnValue;
    }

    public String getText() {
        return this.getValidatorMessage(this.currentValidator);
    }

    public String getPassword() {
        if (this.processor != null) {
            return this.processor.process(this);
        }
        String contents = "";
        if (this.fields.size() > 0) {
            contents = new String(((JPasswordField)this.fields.elementAt(0)).getPassword());
        }
        return contents;
    }

    public String getConfirmationID() {
        return this.confirmationID;
    }

    public void setConfirmationID(String confirmationID) {
        this.confirmationID = confirmationID;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }
}

