/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.panels.AvayaCustomDialog;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class InstallPanel
extends IzPanel
implements AbstractUIProgressHandler {
    private static final long serialVersionUID = 3257282547959410992L;
    protected JLabel tipLabel;
    protected JLabel packOpLabel;
    protected JLabel overallOpLabel;
    protected JProgressBar packProgressBar;
    protected JProgressBar overallProgressBar;
    private volatile boolean validated = false;
    private int noOfPacks = 0;
    private int noOfFiles = 0;

    public InstallPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.tipLabel = LabelFactory.create(parent.langpack.getString("InstallPanel.tip"), parent.icons.getImageIcon("information"), 10);
        this.add((Component)this.tipLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packOpLabel = LabelFactory.create(" ", 10);
        this.add((Component)this.packOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString(parent.langpack.getString("InstallPanel.begin"));
        this.packProgressBar.setValue(0);
        this.add((Component)this.packProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.add(IzPanelLayout.createParagraphGap());
        this.overallOpLabel = LabelFactory.create(parent.langpack.getString("InstallPanel.progress"), parent.icons.getImageIcon("information"), 10);
        this.add((Component)this.overallOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setStringPainted(true);
        this.overallProgressBar.setString("");
        this.overallProgressBar.setValue(0);
        this.add((Component)this.overallProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.getLayoutHelper().completeLayout();
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void startAction(String name, int noOfJobs) {
        this.noOfPacks = noOfJobs;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.overallProgressBar.setMinimum(0);
                InstallPanel.this.overallProgressBar.setMaximum(InstallPanel.this.noOfPacks);
                InstallPanel.this.overallProgressBar.setString("0 / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    public void emitError(String title, String error) {
        this.packOpLabel.setText(error);
        this.idata.installSuccess = false;
        AvayaCustomDialog avayaCustomDialog = new AvayaCustomDialog(this.parent, true);
        avayaCustomDialog.emitError(title, error);
    }

    public void stopAction() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.parent.releaseGUI();
                InstallPanel.this.parent.lockPrevButton();
                InstallPanel.this.overallProgressBar.setValue(InstallPanel.this.overallProgressBar.getMaximum());
                int ppbMax = InstallPanel.this.packProgressBar.getMaximum();
                if (ppbMax < 1) {
                    ppbMax = 1;
                    InstallPanel.this.packProgressBar.setMaximum(ppbMax);
                }
                InstallPanel.this.packProgressBar.setValue(ppbMax);
                InstallPanel.this.packProgressBar.setString(((InstallPanel)InstallPanel.this).parent.langpack.getString("InstallPanel.finished"));
                InstallPanel.this.packProgressBar.setEnabled(false);
                String no_of_packs = Integer.toString(InstallPanel.this.noOfPacks);
                InstallPanel.this.overallProgressBar.setString(InstallPanel.this.overallProgressBar.getMaximum() + " / " + InstallPanel.this.overallProgressBar.getMaximum());
                InstallPanel.this.overallOpLabel.setText(((InstallPanel)InstallPanel.this).parent.langpack.getString("processing.finished"));
                InstallPanel.this.overallProgressBar.setEnabled(false);
                InstallPanel.this.packOpLabel.setText(" ");
                InstallPanel.this.packOpLabel.setEnabled(false);
                InstallPanel.this.idata.canClose = true;
                InstallPanel.this.validated = true;
                if (InstallPanel.this.idata.panels.indexOf(this) != InstallPanel.this.idata.panels.size() - 1) {
                    InstallPanel.this.parent.unlockNextButton();
                }
                InstallPanel.this.parent.getNextButton().doClick();
            }
        });
    }

    public void progress(final int val, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.packProgressBar.setValue(val + 1);
                InstallPanel.this.packOpLabel.setText(msg);
            }
        });
    }

    public void nextStep(final String packName, final int stepno, final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.packProgressBar.setValue(0);
                InstallPanel.this.packProgressBar.setMinimum(0);
                InstallPanel.this.packProgressBar.setMaximum(max);
                InstallPanel.this.packProgressBar.setString(packName);
                InstallPanel.this.overallProgressBar.setValue(stepno - 1);
                InstallPanel.this.overallProgressBar.setString(Integer.toString(stepno) + " / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    public void setSubStepNo(final int no_of_substeps) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.packProgressBar.setMaximum(no_of_substeps);
            }
        });
    }

    public void panelActivate() {
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        AvayaInstaller.panther.setInstallStage("install");
        this.parent.install(this);
    }

    public void startFileExecutionAction(final int max) {
        this.noOfFiles = max;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.remove(InstallPanel.this.packProgressBar);
                InstallPanel.this.packOpLabel.setVisible(false);
                InstallPanel.this.remove(InstallPanel.this.tipLabel);
                InstallPanel.this.overallOpLabel.setText("Parsing and Executing Files");
                InstallPanel.this.overallProgressBar.setMinimum(0);
                InstallPanel.this.overallProgressBar.setMaximum(max);
                InstallPanel.this.overallProgressBar.setValue(0);
                InstallPanel.this.overallProgressBar.setString("0 / " + max);
                InstallPanel.this.validate();
                InstallPanel.this.repaint();
            }
        });
    }

    public void fileProgress(final int val, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.overallProgressBar.setValue(val);
                InstallPanel.this.overallProgressBar.setString(val + " / " + Integer.toString(InstallPanel.this.noOfFiles));
                InstallPanel.this.overallOpLabel.setText(msg);
            }
        });
    }

    public void startPutUninstaller(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.remove(InstallPanel.this.packProgressBar);
                InstallPanel.this.packOpLabel.setVisible(false);
                InstallPanel.this.remove(InstallPanel.this.tipLabel);
                InstallPanel.this.overallOpLabel.setText(msg);
                InstallPanel.this.overallProgressBar.setMinimum(0);
                InstallPanel.this.overallProgressBar.setValue(0);
                InstallPanel.this.validate();
                InstallPanel.this.repaint();
            }
        });
    }

    public void uninstallerProgress(final int val, final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.overallProgressBar.setValue(val);
                InstallPanel.this.overallProgressBar.setString((int)((float)val / (float)max * 100.0f) + "%");
            }
        });
    }

    public void startCleanUp() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.overallOpLabel.setText("Writing installation Data and Performing clean up ");
            }
        });
    }

    public void rollbackAction(String name, int noOfJobs, final int maxProgressCount) {
        this.noOfFiles = maxProgressCount;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.packOpLabel.setText("   Performing Rollback...");
                InstallPanel.this.packOpLabel.setVisible(true);
                InstallPanel.this.overallProgressBar.setMinimum(0);
                InstallPanel.this.overallProgressBar.setMaximum(maxProgressCount);
                InstallPanel.this.overallProgressBar.setValue(0);
                InstallPanel.this.overallProgressBar.setString("0 / " + Integer.toString(maxProgressCount));
                InstallPanel.this.overallProgressBar.repaint();
                InstallPanel.this.revalidate();
                InstallPanel.this.repaint();
            }
        });
    }

    public void stopCancelAction() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.parent.releaseGUI();
                InstallPanel.this.parent.lockPrevButton();
                InstallPanel.this.overallProgressBar.setValue(InstallPanel.this.overallProgressBar.getMaximum());
                int ppbMax = InstallPanel.this.packProgressBar.getMaximum();
                if (ppbMax < 1) {
                    ppbMax = 1;
                    InstallPanel.this.packProgressBar.setMaximum(ppbMax);
                }
                InstallPanel.this.packProgressBar.setValue(ppbMax);
                InstallPanel.this.packProgressBar.setString(((InstallPanel)InstallPanel.this).parent.langpack.getString("InstallPanel.finished"));
                InstallPanel.this.packProgressBar.setEnabled(false);
                String no_of_packs = Integer.toString(InstallPanel.this.noOfPacks);
                InstallPanel.this.overallProgressBar.setString(InstallPanel.this.overallProgressBar.getMaximum() + " / " + InstallPanel.this.overallProgressBar.getMaximum());
                InstallPanel.this.overallOpLabel.setText(((InstallPanel)InstallPanel.this).parent.langpack.getString("Cancellation Completed"));
                InstallPanel.this.overallProgressBar.setEnabled(false);
                InstallPanel.this.packOpLabel.setText(" ");
                InstallPanel.this.packOpLabel.setEnabled(false);
                InstallPanel.this.idata.canClose = true;
                InstallPanel.this.validated = true;
                if (InstallPanel.this.idata.panels.indexOf(this) != InstallPanel.this.idata.panels.size() - 1) {
                    InstallPanel.this.parent.unlockNextButton();
                }
                InstallPanel.this.parent.getNextButton().doClick();
            }
        });
    }

    public JProgressBar getOverallProgressBar() {
        return this.overallProgressBar;
    }

    public JLabel getTipLabel() {
        return this.tipLabel;
    }
}

