/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLLicencePanel
extends IzPanel
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = 3256728385458746416L;
    private JEditorPane textArea;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;

    public HTMLLicencePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.loadLicence();
        this.add((Component)LabelFactory.create(parent.langpack.getString("LicencePanel.info"), parent.icons.getImageIcon("history"), 10), "nextLine");
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadLicence());
            this.add((Component)scroller, "nextLine");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ButtonGroup group = new ButtonGroup();
        this.yesRadio = new JRadioButton(parent.langpack.getString("LicencePanel.agree"), false);
        group.add(this.yesRadio);
        this.add((Component)this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        this.yesRadio.setBackground(Color.WHITE);
        this.noRadio = new JRadioButton(parent.langpack.getString("LicencePanel.notagree"), true);
        this.noRadio.setBackground(Color.WHITE);
        group.add(this.noRadio);
        this.add((Component)this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        this.setInitialFocus(this.textArea);
        this.getLayoutHelper().completeLayout();
    }

    private URL loadLicence() {
        String resNamePrifix = "HTMLLicencePanel.licence";
        try {
            return ResourceManager.getInstance().getURL(resNamePrifix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.textArea.setPage(e.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

