/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.avaya.panther.installer.AvayaInstallerBase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257282535107998009L;
    protected JButton autoButton;
    protected VariableSubstitutor vs;

    public FinishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        boolean rollback;
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        JPanel headingpanel = new JPanel();
        headingpanel.setLayout(new FlowLayout(1));
        JLabel heading = new JLabel();
        Font font = heading.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        heading.setFont(font);
        heading.setHorizontalAlignment(0);
        boolean bl = rollback = "rollback".equals(this.idata.getVariable("Uninstall"));
        if ("uninstall".equals(this.idata.getVariable("INSTALLER_MODE"))) {
            heading.setText(rollback ? this.parent.langpack.getString("title.rollback.finishpanel") : this.parent.langpack.getString("title.uninstall.finishpanel"));
        } else {
            heading.setText(this.parent.langpack.getString("title.finishpanel"));
        }
        heading.setVerticalAlignment(1);
        headingpanel.add(heading);
        this.add((Component)headingpanel, "North");
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.idata.installSuccess) {
            List installedPack;
            String msg = this.parent.langpack.getString("FinishPanel.uninstall.success");
            if (AvayaInstallerBase.isUninstall() && rollback) {
                msg = this.parent.langpack.getString("FinishPanel.rollback.success");
            }
            String successMsg = "uninstall".equals(this.idata.getVariable("INSTALLER_MODE")) ? msg : this.parent.langpack.getString("FinishPanel.success");
            this.add((Component)LabelFactory.create(successMsg, this.parent.icons.getImageIcon("information"), 10), "nextLine");
            String successPckgMsg = null;
            successPckgMsg = "uninstall".equals(this.idata.getVariable("INSTALLER_MODE")) ? (rollback ? this.parent.langpack.getString("FinishPanel.rollback.success.packageList") : this.parent.langpack.getString("FinishPanel.uninstall.success.packageList")) : this.parent.langpack.getString("FinishPanel.success.packageList");
            this.add(IzPanelLayout.createParagraphGap());
            this.add(IzPanelLayout.createParagraphGap());
            this.add((Component)LabelFactory.create(successPckgMsg, this.parent.icons.getImageIcon("information"), 10), "nextLine");
            this.add(IzPanelLayout.createParagraphGap());
            if ("uninstall".equals(this.idata.getVariable("INSTALLER_MODE"))) {
                installedPack = (List)this.idata.getAttribute("SelectedPacks");
                Iterator installedPackIterator = installedPack.iterator();
                Pack pack = null;
                while (installedPackIterator.hasNext()) {
                    pack = (Pack)installedPackIterator.next();
                    String packName = " > " + pack.name + " - " + pack.getVersion();
                    this.add((Component)LabelFactory.create(packName, this.parent.icons.getImageIcon("information"), 10), "nextLine");
                    this.add(IzPanelLayout.createParagraphGap());
                }
            } else {
                installedPack = this.idata.selectedPacks;
                for (Pack pack : installedPack) {
                    String packName = " > " + (pack.getName() != null ? pack.getName() : pack.id);
                    this.add((Component)LabelFactory.create(packName, this.parent.icons.getImageIcon("information"), 10), "nextLine");
                    this.add(IzPanelLayout.createParagraphGap());
                }
            }
            this.add(IzPanelLayout.createParagraphGap());
            this.add(IzPanelLayout.createParagraphGap());
            if (this.idata.uninstallOutJar != null) {
                String path = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
                this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("information"), 10), "nextLine");
                this.add((Component)LabelFactory.create(path, this.parent.icons.getImageIcon("empty"), 10), "nextLine");
            }
            this.add(IzPanelLayout.createParagraphGap());
            this.autoButton = ButtonFactory.createButton(this.parent.langpack.getString("FinishPanel.auto"), this.parent.icons.getImageIcon("edit"), this.idata.buttonsHColor);
            this.autoButton.setToolTipText(this.parent.langpack.getString("FinishPanel.auto.tip"));
            this.autoButton.addActionListener(this);
            this.autoButton.setVisible(false);
            this.add((Component)this.autoButton, "nextLine");
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (!AvayaInstallerBase.isUninstall() && this.parent.rules.isConditionTrue("pantherPackSelection")) {
                String successMsg1 = this.parent.langpack.getString("FinishPanel.success.txt");
                this.add((Component)LabelFactory.create(successMsg1, this.parent.icons.getImageIcon("information"), 10), "nextLine");
                JLabel label = new JLabel(this.parent.langpack.getString("FinishPanel.accessLink"));
                label.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent arg0) {
                        try {
                            Class<?> desktopClass = Class.forName("java.awt.Desktop");
                            Method getDesktopMethod = desktopClass.getMethod("getDesktop", null);
                            Object desktopObject = getDesktopMethod.invoke(null, null);
                            Method browseMethod = desktopClass.getMethod("browse", URI.class);
                            URI uri = new URI(((FinishPanel)FinishPanel.this).parent.langpack.getString("FinishPanel.commonConsoleAccessLink"));
                            browseMethod.invoke(desktopObject, uri);
                        }
                        catch (Exception e) {
                            ((FinishPanel)FinishPanel.this).parent.langpack.getString("FinishPanel.commonConsoleAccessLink");
                        }
                    }

                    public void mouseEntered(MouseEvent arg0) {
                    }

                    public void mouseExited(MouseEvent arg0) {
                    }

                    public void mousePressed(MouseEvent arg0) {
                    }

                    public void mouseReleased(MouseEvent arg0) {
                    }
                });
                this.add(label);
            }
        } else if (this.idata.getVariable("installationCancelled").equals("true")) {
            this.add((Component)LabelFactory.create("Installation was cancelled and has been Backed out", this.parent.icons.getImageIcon("information"), 10), "nextLine");
        } else {
            this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("information"), 10), "nextLine");
        }
        this.getLayoutHelper().completeLayout();
        Log.getInstance().informUser();
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.idata.getInstallPath()));
        fc.setMultiSelectionEnabled(false);
        fc.addChoosableFileFilter(fc.getAcceptAllFileFilter());
        try {
            if (fc.showSaveDialog(this) == 0) {
                File file = fc.getSelectedFile();
                FileOutputStream out = new FileOutputStream(file);
                BufferedOutputStream outBuff = new BufferedOutputStream(out, 5120);
                this.parent.writeXMLTree(this.idata.xmlData, outBuff);
                outBuff.flush();
                outBuff.close();
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(this, err.toString(), this.parent.langpack.getString("installer.error"), 0);
        }
    }

    protected String translatePath(String destination) {
        destination = this.vs.substitute(destination, null);
        return destination.replace('/', File.separatorChar);
    }
}

