/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.TreePacksPanel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckTreeController
extends MouseAdapter
implements KeyListener {
    JTree tree;
    TreePacksPanel treePacksPanel;
    List<String> avayaAvailablePackId;
    int checkWidth;

    public CheckTreeController(TreePacksPanel p, List<String> avayaAvailablePackId) {
        this.checkWidth = new JCheckBox().getPreferredSize().width;
        this.tree = p.getTree();
        this.treePacksPanel = p;
        this.avayaAvailablePackId = avayaAvailablePackId;
    }

    private void selectNode(CheckBoxNode current) {
        current.setPartial(false);
        this.treePacksPanel.setModelValue(current);
        Enumeration<TreeNode> e = current.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)e.nextElement();
            child.setSelected((current.isSelected() || child.getPack().required) && this.avayaAvailablePackId.indexOf(child.getPack().id) > -1);
            if (!child.isSelected()) {
                child.setPartial(false);
            }
            this.treePacksPanel.setModelValue(child);
        }
        this.treePacksPanel.fromModel();
    }

    private boolean hasExcludes(CheckBoxNode node) {
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            CheckBoxNode cbn = (CheckBoxNode)e.nextElement();
            if (cbn.getPack().excludeGroup == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
        boolean isValidPack = true;
        if (this.avayaAvailablePackId.indexOf(current.getPack().id) < 0) {
            isValidPack = false;
        }
        this.treePacksPanel.setDescription(current.getId(), isValidPack);
        this.treePacksPanel.setDependencies(current.getId());
        if (me.getX() > this.tree.getPathBounds((TreePath)path).x + this.checkWidth) {
            return;
        }
        if (!isValidPack) {
            return;
        }
        if (current.getPack().required && !isValidPack) {
            return;
        }
        boolean currIsSelected = current.isSelected() & !current.isPartial();
        boolean currIsPartial = current.isPartial();
        boolean currHasExcludes = this.hasExcludes(current);
        CheckBoxNode root = (CheckBoxNode)current.getRoot();
        if (currIsPartial && currHasExcludes) {
            current.setSelected(false);
            this.selectNode(current);
            this.updateAllParents(root);
        } else {
            if (!currIsSelected) {
                this.selectAllChildNodes(current);
            }
            current.setSelected(!currIsSelected);
            this.selectNode(current);
            this.updateAllParents(root);
        }
        CheckTreeController.initTotalSize(root, true);
        this.treePacksPanel.setBytes((int)root.getTotalSize());
        this.treePacksPanel.showSpaceRequired();
        this.tree.treeDidChange();
    }

    public void selectAllChildNodes(CheckBoxNode cbn) {
        Enumeration<TreeNode> e = cbn.children();
        while (e.hasMoreElements()) {
            CheckBoxNode subCbn = (CheckBoxNode)e.nextElement();
            this.selectAllDependencies(subCbn);
            if (subCbn.getChildCount() > 0) {
                this.selectAllChildNodes(subCbn);
            }
            subCbn.setSelected(true);
            subCbn.setEnabled(true);
            this.treePacksPanel.setModelValue(subCbn);
            subCbn.setEnabled(!subCbn.getPack().required && this.avayaAvailablePackId.indexOf(subCbn.getPack().id) > -1);
        }
    }

    public void selectAllDependencies(CheckBoxNode cbn) {
        Pack pack = cbn.getPack();
        List deps = pack.getDependencies();
        if (deps == null) {
            return;
        }
        for (String depId : deps) {
            CheckBoxNode depCbn = this.treePacksPanel.getCbnById(depId);
            this.selectAllDependencies(depCbn);
            if (depCbn.getChildCount() > 0 && (!depCbn.isSelected() || depCbn.isPartial())) {
                this.selectAllChildNodes(depCbn);
            }
            depCbn.setSelected(true);
            depCbn.setEnabled(true);
            this.treePacksPanel.setModelValue(depCbn);
            depCbn.setEnabled(!depCbn.getPack().required && this.avayaAvailablePackId.indexOf(depCbn.getPack().id) > -1);
        }
    }

    public void updateAllParents(CheckBoxNode root) {
        Enumeration<TreeNode> rootEnum = root.depthFirstEnumeration();
        while (rootEnum.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)rootEnum.nextElement();
            if (child.getParent() == null || child.getParent().equals(root)) continue;
            this.updateParents(child);
        }
    }

    private void updateParents(CheckBoxNode node) {
        CheckBoxNode parent = (CheckBoxNode)node.getParent();
        if (parent != null && !parent.equals(parent.getRoot())) {
            Enumeration<TreeNode> ne = parent.children();
            boolean allSelected = true;
            boolean allDeselected = true;
            while (ne.hasMoreElements()) {
                CheckBoxNode child = (CheckBoxNode)ne.nextElement();
                if (child.isSelected()) {
                    allDeselected = false;
                } else {
                    allSelected = false;
                }
                if (child.isPartial()) {
                    allDeselected = false;
                    allSelected = false;
                }
                if (allSelected || allDeselected) continue;
                break;
            }
            if (parent.getChildCount() > 0) {
                if (!allSelected && !allDeselected) {
                    CheckTreeController.setPartialParent(parent);
                } else {
                    parent.setPartial(false);
                }
                if (allSelected) {
                    parent.setSelected(true);
                }
                if (allDeselected) {
                    parent.setSelected(false);
                }
                this.treePacksPanel.setModelValue(parent);
                if (allSelected || allDeselected) {
                    this.updateParents(parent);
                }
            }
        }
    }

    public static void setPartialParent(CheckBoxNode node) {
        node.setPartial(true);
        CheckBoxNode parent = (CheckBoxNode)node.getParent();
        if (parent != null && !parent.equals(parent.getRoot())) {
            CheckTreeController.setPartialParent(parent);
        }
    }

    public static long initTotalSize(CheckBoxNode node, boolean markChanged) {
        if (node.isLeaf()) {
            return node.getPack().nbytes;
        }
        Enumeration<TreeNode> e = node.children();
        Pack nodePack = node.getPack();
        long bytes = 0L;
        if (nodePack != null) {
            bytes = nodePack.nbytes;
        }
        while (e.hasMoreElements()) {
            CheckBoxNode c = (CheckBoxNode)e.nextElement();
            long size = CheckTreeController.initTotalSize(c, markChanged);
            if (!c.isSelected() && !c.isPartial()) continue;
            bytes += size;
        }
        if (markChanged) {
            long old = node.getTotalSize();
            if (old != bytes) {
                node.setTotalSizeChanged(true);
            } else {
                node.setTotalSizeChanged(false);
            }
        }
        node.setTotalSize(bytes);
        return bytes;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        CheckBoxNode root;
        if (e.getKeyChar() == ' ') {
            JTree JTreeObj = (JTree)e.getSource();
            TreePath path = JTreeObj.getSelectionPath();
            if (path == null) {
                return;
            }
            CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
            boolean isValidPack = true;
            if (this.avayaAvailablePackId.indexOf(current.getPack().id) < 0) {
                isValidPack = false;
            }
            this.treePacksPanel.setDescription(current.getId(), isValidPack);
            this.treePacksPanel.setDependencies(current.getId());
            if (JTreeObj.getX() > this.tree.getPathBounds((TreePath)path).x + this.checkWidth) {
                return;
            }
            if (!isValidPack) {
                return;
            }
            if (current.getPack().required && !isValidPack) {
                return;
            }
            boolean currIsSelected = current.isSelected() & !current.isPartial();
            boolean currIsPartial = current.isPartial();
            boolean currHasExcludes = this.hasExcludes(current);
            root = (CheckBoxNode)current.getRoot();
            if (currIsPartial && currHasExcludes) {
                current.setSelected(false);
                this.selectNode(current);
                this.updateAllParents(root);
            } else {
                if (!currIsSelected) {
                    this.selectAllChildNodes(current);
                }
                current.setSelected(!currIsSelected);
                this.selectNode(current);
                this.updateAllParents(root);
            }
        } else {
            return;
        }
        CheckTreeController.initTotalSize(root, true);
        this.treePacksPanel.setBytes((int)root.getTotalSize());
        this.treePacksPanel.showSpaceRequired();
        this.tree.treeDidChange();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

