/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.avaya.panther.installer.CAFWorker;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.n3.nanoxml.XMLElement;

public class CAFPanel
extends IzPanel
implements AbstractUIProcessHandler {
    private static final long serialVersionUID = 1L;
    public CAFWorker worker;
    protected JLabel processLabel;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private int noOfJobs = 0;
    private int currentJob = 0;
    public final JTextArea outputPane;
    public String panelID;
    private static int instanceCount = 0;
    protected int instanceNumber = 0;
    private InstallData installdata;

    public CAFPanel(InstallerFrame parent, InstallData idata) throws IOException {
        super(parent, idata);
        this.installdata = idata;
        this.instanceNumber = instanceCount++;
        this.panelID = this.getMetadata().getPanelid();
        this.worker = new CAFWorker(idata, this, this.panelID, Integer.toString(this.instanceNumber));
        JLabel heading = new JLabel();
        Font font = heading.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        heading.setFont(font);
        heading.setHorizontalAlignment(0);
        heading.setText(parent.langpack.getString("ProcessPanel.heading"));
        heading.setVerticalAlignment(1);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(2);
        layout.setVgap(2);
        this.setLayout(layout);
        this.add((Component)heading, "North");
        JPanel subpanel = new JPanel();
        subpanel.setAlignmentX(0.5f);
        subpanel.setLayout(new BoxLayout(subpanel, 1));
        this.processLabel = new JLabel();
        this.processLabel.setAlignmentX(0.5f);
        this.processLabel.setText(" ");
        subpanel.add(this.processLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setAlignmentX(0.5f);
        this.overallProgressBar.setStringPainted(true);
        subpanel.add(this.overallProgressBar);
        this.outputPane = new JTextArea();
        this.outputPane.setEditable(false);
        this.outputPane.setLineWrap(true);
        JScrollPane outputScrollPane = new JScrollPane(this.outputPane);
        subpanel.add(outputScrollPane);
        subpanel.setBackground(Color.WHITE);
        this.add((Component)subpanel, "Center");
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void startProcessing(int no_of_jobs) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CAFPanel.this.outputPane.setText("");
            }
        });
        this.noOfJobs = no_of_jobs;
        this.overallProgressBar.setMaximum(no_of_jobs);
        this.overallProgressBar.setIndeterminate(true);
        this.parent.lockPrevButton();
    }

    public void finishProcessing() {
        this.overallProgressBar.setIndeterminate(false);
        String no_of_jobs = Integer.toString(this.worker.getJobs().size());
        this.noOfJobs = this.worker.getJobs().size();
        this.currentJob = 0;
        this.overallProgressBar.setString(no_of_jobs + " / " + no_of_jobs);
        this.processLabel.setEnabled(false);
        this.parent.unlockPrevButton();
        this.worker.getJobs().clear();
        this.validated = true;
        this.idata.installSuccess = true;
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1) {
            this.parent.unlockNextButton();
        }
        this.parent.unlockRetryButton();
    }

    public void logOutput(String message, boolean stderr) {
        this.outputPane.append(message + '\n');
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CAFPanel.this.outputPane.setCaretPosition(CAFPanel.this.outputPane.getText().length());
            }
        });
    }

    public void startProcess(String jobName) {
        this.processLabel.setText(jobName);
        ++this.currentJob;
        this.overallProgressBar.setValue(this.currentJob);
        this.overallProgressBar.setString(Integer.toString(this.currentJob) + " / " + Integer.toString(this.noOfJobs));
        this.parent.lockPrevButton();
    }

    public void finishProcess() {
        this.parent.unlockPrevButton();
    }

    public void panelActivate() {
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        if (((JButton)InstallerFrame.source).getText().equals(this.installdata.langpack.getString("installer.next"))) {
            this.parent.lockNextButton();
            this.parent.lockRetryButton();
            this.worker.startThread();
        }
    }

    public void panelActivateRetry() {
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockRetryButton();
        this.worker.startThread();
    }

    public void makeXMLData(XMLElement panelRoot) {
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }
}

