/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Version;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.uninstaller.Uninstaller;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class AvayaUninstallPanel
extends IzPanel
implements AbstractUIProgressHandler,
Runnable {
    private static final long serialVersionUID = 1L;
    protected JLabel tipLabel;
    protected JLabel fileLabel;
    protected JLabel packVersionLabel;
    protected JLabel packLabel;
    protected JProgressBar fileProgressBar;
    protected JProgressBar packProgressBar;
    protected JProgressBar packVersionProgressBar;
    private volatile boolean validated = false;
    private int noOfFiles = 0;
    private int noOfPackVersions = 0;
    private int noOfPacks = 0;
    private boolean rollback = false;
    private String packUninstallerURL = null;

    public AvayaUninstallPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.tipLabel = LabelFactory.create(parent.langpack.getString("AvayaUninstallPanel.tip"), parent.icons.getImageIcon("information"), 10);
        this.add((Component)this.tipLabel, IzPanelLayout.getDefaultConstraint(7));
        this.fileLabel = LabelFactory.create(" ", 10);
        this.add((Component)this.fileLabel, IzPanelLayout.getDefaultConstraint(7));
        this.fileProgressBar = new JProgressBar();
        this.fileProgressBar.setStringPainted(true);
        this.fileProgressBar.setString(parent.langpack.getString("InstallPanel.begin"));
        this.fileProgressBar.setValue(0);
        this.add((Component)this.fileProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.add(IzPanelLayout.createParagraphGap());
        this.packVersionLabel = LabelFactory.create("Pack Version progress", parent.icons.getImageIcon("information"), 10);
        this.add((Component)this.packVersionLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packVersionProgressBar = new JProgressBar();
        this.packVersionProgressBar.setStringPainted(true);
        this.packVersionProgressBar.setString("");
        this.packVersionProgressBar.setValue(0);
        this.add((Component)this.packVersionProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.add(IzPanelLayout.createParagraphGap());
        this.packLabel = LabelFactory.create(parent.langpack.getString("AvayaUninstallPanel.progress"), parent.icons.getImageIcon("information"), 10);
        this.add((Component)this.packLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString("");
        this.packProgressBar.setValue(0);
        this.add((Component)this.packProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.getLayoutHelper().completeLayout();
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void panelActivate() {
        boolean bl = this.rollback = "rollback".equals(this.idata.getVariable("Uninstall"));
        if (this.rollback) {
            this.tipLabel.setText(this.idata.langpack.getString("AvayaUninstallPanel.rollback.tip"));
        }
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        this.packProgressBar.setIndeterminate(true);
        this.fileProgressBar.setIndeterminate(true);
        if (this.rollback) {
            this.packVersionLabel.setVisible(false);
            this.packVersionProgressBar.setVisible(false);
        } else {
            this.packVersionProgressBar.setIndeterminate(true);
        }
        Thread uninstallerThread = new Thread((Runnable)this, "Uninstaller");
        uninstallerThread.start();
        this.validated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Class<?> clazz = null;
        IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
        final ArrayList packs = (ArrayList)this.idata.getAttribute("SelectedPacks");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.packProgressBar.setMinimum(0);
                    AvayaUninstallPanel.this.packProgressBar.setMaximum(packs.size());
                    AvayaUninstallPanel.this.packProgressBar.setIndeterminate(false);
                }
            });
        }
        catch (Exception e) {
            Debug.error(e.toString());
            e.printStackTrace();
        }
        this.noOfPacks = packs.size();
        int packNumber = 0;
        Pack packObj = null;
        for (Pack pack : packs) {
            int versionCount;
            this.packProgressBar.setString(packNumber + " / " + Integer.toString(this.noOfPacks));
            HashMap<Pack, String> uninstallers = new HashMap<Pack, String>();
            String filePath = null;
            String packUninstallerDir = AvayaInstallerBase.generatePackMetadataPath(pack.id, pack.getVersion(), null);
            packObj = new Pack(pack.name, pack.id, pack.getVersion(), pack.description, pack.osConstraints, pack.dependencies, pack.required, pack.preselected, pack.loose, null, pack.uninstall);
            this.packVersionProgressBar.setMinimum(0);
            if (this.rollback) {
                filePath = packUninstallerDir + File.separator + "uninstaller.jar";
                uninstallers.put(packObj, filePath);
                this.noOfPackVersions = 1;
                this.packVersionProgressBar.setMaximum(1);
            } else {
                versionCount = 0;
                for (Version version : inventoryUtil.getPackVersions(pack.id)) {
                    if ("PATCH".toLowerCase().equals(inventoryUtil.getInstallType(version.toString()))) continue;
                    ++versionCount;
                    filePath = AvayaInstallerBase.generatePackMetadataPath(pack.id, version.toString(), null) + File.separator + "uninstaller.jar";
                    try {
                        packObj = (Pack)packObj.clone();
                        packObj.setVersion(version.toString());
                    }
                    catch (CloneNotSupportedException e) {
                        // empty catch block
                    }
                    uninstallers.put(packObj, filePath);
                }
                final int packVersions = versionCount;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            AvayaUninstallPanel.this.packVersionProgressBar.setValue(0);
                            AvayaUninstallPanel.this.packVersionProgressBar.setMaximum(packVersions);
                            AvayaUninstallPanel.this.packVersionProgressBar.setString("0 / " + Integer.toString(packVersions));
                        }
                    });
                }
                catch (Exception e) {
                    Debug.error(e.toString());
                    e.printStackTrace();
                }
                this.noOfPackVersions = versionCount;
            }
            this.packVersionProgressBar.setIndeterminate(false);
            versionCount = 0;
            for (Pack currPack : uninstallers.keySet()) {
                this.packVersionLabel.setText("Version: " + currPack.getName() + " - " + currPack.getVersion());
                File uninstallerFile = new File((String)uninstallers.get(currPack));
                if (!uninstallerFile.exists()) {
                    Debug.error("Uninstaller JAR not found.");
                    System.exit(-1);
                }
                URL url = null;
                Uninstaller uninstaller = null;
                URLClassLoader classLoader = null;
                try {
                    this.addURL(uninstallerFile.toURL());
                    this.packUninstallerURL = uninstallerFile.getAbsolutePath();
                    filePath = "jar:file://" + (String)uninstallers.get(currPack) + "!/";
                    url = new File(filePath).toURL();
                    classLoader = new URLClassLoader(new URL[]{url});
                    clazz = classLoader.loadClass("com.izforge.izpack.uninstaller.Uninstaller");
                    uninstaller = (Uninstaller)clazz.newInstance();
                    uninstaller.runUninstaller(currPack, this, this.rollback);
                }
                catch (Exception e) {
                    Debug.error(e);
                    e.printStackTrace();
                }
                finally {
                    uninstaller = null;
                    url = null;
                    clazz = null;
                    classLoader = null;
                    IoHelper.deleteDir(packUninstallerDir);
                }
                this.updatePackVersionProgressBar(currPack.getName() + " - " + currPack.getVersion(), ++versionCount);
            }
            this.updatePackProgressBar(pack.name, ++packNumber);
        }
        if (inventoryUtil.getInstalledPacks() != null && inventoryUtil.getInstalledPacks().size() == 0) {
            IoHelper.deleteDir(inventoryUtil.getInstallPath() + File.separator + "installdata");
            IoHelper.deleteDir(inventoryUtil.getInstallPath() + File.separator + "Uninstaller");
            File[] files = new File(inventoryUtil.getInstallPath()).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name != null && (name.contains(".installationinformation") || name.contains(".txt") || name.contains(".properties"));
                }
            });
            if (files != null) {
                int size = files.length;
                for (int i = 0; i < size; ++i) {
                    files[i].delete();
                }
            }
        }
        this.stopAction();
    }

    public void addURL(URL url) throws IOException {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = urlClassLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toString().equalsIgnoreCase(url.toString())) continue;
            Debug.log("URL " + url + " is already in the CLASSPATH");
            return;
        }
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, url);
        }
        catch (Throwable t) {
            Debug.error(t.getMessage());
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public void nextStep(String step_name, int step_no, int no_of_substeps) {
    }

    public void progress(final int substep_no, final String message) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.fileProgressBar.setValue(substep_no + 1);
                    AvayaUninstallPanel.this.fileLabel.setText(message);
                    AvayaUninstallPanel.this.revalidate();
                    AvayaUninstallPanel.this.repaint();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public void setSubStepNo(int no_of_substeps) {
    }

    public void startAction(String name, final int no_of_steps) {
        this.noOfFiles = no_of_steps;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.tipLabel.setText("Removing Files");
                    AvayaUninstallPanel.this.fileProgressBar.setIndeterminate(false);
                    AvayaUninstallPanel.this.fileProgressBar.setMinimum(0);
                    AvayaUninstallPanel.this.fileProgressBar.setMaximum(no_of_steps);
                    AvayaUninstallPanel.this.fileProgressBar.setString("0 / " + Integer.toString(no_of_steps));
                    AvayaUninstallPanel.this.revalidate();
                    AvayaUninstallPanel.this.repaint();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public void updatePackProgressBar(String name, final int stepNo) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.packProgressBar.setValue(stepNo);
                    AvayaUninstallPanel.this.packProgressBar.setString(stepNo + " / " + Integer.toString(AvayaUninstallPanel.this.noOfPacks));
                    AvayaUninstallPanel.this.revalidate();
                    AvayaUninstallPanel.this.repaint();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public void updatePackVersionProgressBar(final String name, final int stepNo) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.packVersionLabel.setText("Version: " + name);
                    AvayaUninstallPanel.this.packVersionProgressBar.setValue(stepNo);
                    AvayaUninstallPanel.this.packVersionProgressBar.setString(stepNo + " / " + Integer.toString(AvayaUninstallPanel.this.noOfPackVersions));
                    AvayaUninstallPanel.this.revalidate();
                    AvayaUninstallPanel.this.repaint();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public void startFileExecutionAction(final int max) {
        this.noOfFiles = max;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.fileProgressBar.setIndeterminate(false);
                    AvayaUninstallPanel.this.tipLabel.setText("Executing Files");
                    AvayaUninstallPanel.this.fileProgressBar.setMinimum(0);
                    AvayaUninstallPanel.this.fileProgressBar.setMaximum(max);
                    AvayaUninstallPanel.this.fileProgressBar.setValue(0);
                    AvayaUninstallPanel.this.fileProgressBar.setString("0 / " + max);
                    AvayaUninstallPanel.this.revalidate();
                    AvayaUninstallPanel.this.repaint();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public void fileProgress(final int val, final String msg) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.fileProgressBar.setValue(val + 1);
                    AvayaUninstallPanel.this.fileProgressBar.setString(val + 1 + " / " + Integer.toString(AvayaUninstallPanel.this.noOfFiles));
                    AvayaUninstallPanel.this.fileLabel.setText(msg);
                    AvayaUninstallPanel.this.revalidate();
                    AvayaUninstallPanel.this.repaint();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public void fileRestoreProgress(final int val, final int totalCount, final String msg) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.fileProgressBar.setIndeterminate(false);
                    AvayaUninstallPanel.this.tipLabel.setText("Restoring Files");
                    AvayaUninstallPanel.this.fileProgressBar.setValue(val);
                    AvayaUninstallPanel.this.fileProgressBar.setString(val + " / " + Integer.toString(totalCount));
                    AvayaUninstallPanel.this.fileLabel.setText(msg);
                    AvayaUninstallPanel.this.revalidate();
                    AvayaUninstallPanel.this.repaint();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public void stopAction() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvayaUninstallPanel.this.parent.releaseGUI();
                    AvayaUninstallPanel.this.parent.lockPrevButton();
                    int ppbMax = AvayaUninstallPanel.this.fileProgressBar.getMaximum();
                    if (ppbMax < 1) {
                        ppbMax = 1;
                        AvayaUninstallPanel.this.fileProgressBar.setMaximum(ppbMax);
                    }
                    AvayaUninstallPanel.this.fileProgressBar.setValue(ppbMax);
                    AvayaUninstallPanel.this.fileProgressBar.setString(((AvayaUninstallPanel)AvayaUninstallPanel.this).parent.langpack.getString("AvayaUninstallPanel.finished"));
                    AvayaUninstallPanel.this.fileProgressBar.setEnabled(false);
                    AvayaUninstallPanel.this.packProgressBar.setValue(AvayaUninstallPanel.this.packProgressBar.getMaximum());
                    AvayaUninstallPanel.this.packProgressBar.setString(AvayaUninstallPanel.this.packProgressBar.getMaximum() + " / " + AvayaUninstallPanel.this.packProgressBar.getMaximum());
                    if (AvayaUninstallPanel.this.rollback) {
                        AvayaUninstallPanel.this.packLabel.setText(((AvayaUninstallPanel)AvayaUninstallPanel.this).parent.langpack.getString("rollback.processing.finished"));
                    } else {
                        AvayaUninstallPanel.this.packLabel.setText(((AvayaUninstallPanel)AvayaUninstallPanel.this).parent.langpack.getString("uninstall.processing.finished"));
                    }
                    AvayaUninstallPanel.this.packProgressBar.setEnabled(false);
                    AvayaUninstallPanel.this.packVersionProgressBar.setValue(AvayaUninstallPanel.this.packVersionProgressBar.getMaximum());
                    AvayaUninstallPanel.this.packVersionProgressBar.setString(AvayaUninstallPanel.this.packVersionProgressBar.getMaximum() + " / " + AvayaUninstallPanel.this.packVersionProgressBar.getMaximum());
                    if (AvayaUninstallPanel.this.rollback) {
                        AvayaUninstallPanel.this.packVersionLabel.setText(((AvayaUninstallPanel)AvayaUninstallPanel.this).parent.langpack.getString("rollback.processing.finished"));
                    } else {
                        AvayaUninstallPanel.this.packVersionLabel.setText(((AvayaUninstallPanel)AvayaUninstallPanel.this).parent.langpack.getString("uninstall.processing.finished"));
                    }
                    AvayaUninstallPanel.this.packVersionProgressBar.setEnabled(false);
                    AvayaUninstallPanel.this.tipLabel.setText(" ");
                    AvayaUninstallPanel.this.tipLabel.setEnabled(false);
                    AvayaUninstallPanel.this.fileLabel.setText(" ");
                    AvayaUninstallPanel.this.fileLabel.setEnabled(false);
                    AvayaUninstallPanel.this.packVersionLabel.setText(" ");
                    AvayaUninstallPanel.this.packVersionLabel.setEnabled(false);
                    AvayaUninstallPanel.this.parent.unlockNextButton(true);
                    AvayaUninstallPanel.this.parent.getQuitButton().setEnabled(false);
                    AvayaUninstallPanel.this.idata.canClose = true;
                    AvayaUninstallPanel.this.validated = true;
                }
            });
        }
        catch (Exception e) {
            Debug.error(e);
            e.printStackTrace();
        }
    }

    public String getPackUninstallerURL() {
        return this.packUninstallerURL;
    }
}

