/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.avaya.panther.installer.AvayaInstaller;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.LayoutHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AvayaPathSelectionPanel
extends JPanel
implements ActionListener,
LayoutConstants {
    private static final long serialVersionUID = 3618700794577105718L;
    protected JTextField textField = null;
    protected JComboBox comboField;
    protected JButton browseButton;
    private IzPanel parent;
    private InstallData idata;
    private boolean allowAvayaBaseCreation = false;

    public AvayaPathSelectionPanel(IzPanel parent, InstallData idata) {
        this.parent = parent;
        this.idata = idata;
        this.createLayout();
    }

    protected void createLayout() {
        LayoutHelper layoutHelper = new LayoutHelper(this);
        layoutHelper.startLayout(new IzPanelLayout());
        IzPanelConstraints ipc = IzPanelLayout.getDefaultConstraint(1);
        ipc.setXStretch(1.0);
        if (AvayaInstaller.panther.isAllowAvayaBaseDefinition()) {
            this.allowAvayaBaseCreation = true;
            this.textField = new JTextField(this.idata.getInstallPath(), 10);
            this.textField.addActionListener(this);
            this.parent.setInitialFocus(this.textField);
            this.add((Component)this.textField, ipc);
            this.add(IzPanelLayout.createHorizontalFiller(3));
            this.browseButton = ButtonFactory.createButton(this.parent.getInstallerFrame().langpack.getString("TargetPanel.browse"), this.parent.getInstallerFrame().icons.getImageIcon("open"), this.idata.buttonsHColor);
            this.browseButton.addActionListener(this);
            this.add(this.browseButton);
        } else {
            this.allowAvayaBaseCreation = false;
            this.comboField = new JComboBox((Vector)this.idata.getAttribute("ALL_AVAYA_BASES"));
            this.parent.setInitialFocus(this.comboField);
            this.add((Component)this.comboField, ipc);
        }
    }

    public Dimension getMinimumSize() {
        Dimension ss = super.getPreferredSize();
        Dimension retval = this.parent.getSize();
        retval.height = ss.height;
        return retval;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browseButton) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(this.textField.getText()));
            fc.setMultiSelectionEnabled(false);
            fc.setFileSelectionMode(1);
            fc.addChoosableFileFilter(fc.getAcceptAllFileFilter());
            if (fc.showOpenDialog(this) == 0) {
                String path = fc.getSelectedFile().getAbsolutePath();
                this.textField.setText(path);
            }
        } else if (this.parent instanceof ActionListener) {
            ((ActionListener)((Object)this.parent)).actionPerformed(e);
        }
    }

    public String getPath() {
        if (this.allowAvayaBaseCreation) {
            return this.textField.getText();
        }
        return (String)this.comboField.getSelectedItem();
    }

    public void setPath(String path) {
        if (this.allowAvayaBaseCreation) {
            this.textField.setText(path);
        } else {
            this.comboField.setSelectedItem(path);
        }
    }

    public JComponent getPathInputField() {
        if (this.allowAvayaBaseCreation) {
            return this.textField;
        }
        return this.comboField;
    }

    public JButton getBrowseButton() {
        if (this.allowAvayaBaseCreation) {
            return this.browseButton;
        }
        return null;
    }
}

