/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.avaya.panther.installer.AvayaCheckBoxNode;
import com.avaya.panther.installer.AvayaCheckBoxNodeRenderer;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Version;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class AvayaInventoryPanel
extends IzPanel
implements MouseListener {
    private JTree tree = null;

    public AvayaInventoryPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
    }

    private void changeValue() {
        AvayaCheckBoxNode node = (AvayaCheckBoxNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        AvayaCheckBoxNode rootNode = (AvayaCheckBoxNode)this.tree.getModel().getRoot();
        node.setSelected(!node.isSelected());
        if (node.isRoot()) {
            Enumeration<TreeNode> childNodes = node.children();
            while (childNodes.hasMoreElements()) {
                ((AvayaCheckBoxNode)childNodes.nextElement()).setSelected(rootNode.isSelected());
            }
        } else {
            Enumeration<TreeNode> childNodes = rootNode.children();
            while (childNodes.hasMoreElements()) {
                if (((AvayaCheckBoxNode)childNodes.nextElement()).isSelected()) {
                    rootNode.setSelected(true);
                    break;
                }
                rootNode.setSelected(false);
            }
        }
        this.tree.treeDidChange();
    }

    private AvayaCheckBoxNode createNodes() {
        boolean rollback;
        AvayaCheckBoxNode rootNode = null;
        AvayaCheckBoxNode packNode = null;
        IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
        List<com.avaya.panther.inventory.beans.Pack> packList = inventoryUtil.getInstalledPacks();
        boolean bl = rollback = "rollback".equals(this.idata.getVariable("Uninstall"));
        if (packList == null || packList.size() == 0) {
            String msg = "";
            msg = rollback ? this.idata.langpack.getString("rollback.exit.message") : this.idata.langpack.getString("uninstaller.exit.message");
            JOptionPane.showMessageDialog(this, msg);
            System.exit(-1);
        }
        rootNode = new AvayaCheckBoxNode("Installed Packs", "Installed Packs", false);
        com.avaya.panther.inventory.beans.Pack pack2 = null;
        Version version = null;
        for (com.avaya.panther.inventory.beans.Pack pack2 : packList) {
            version = rollback ? inventoryUtil.getRollbackVersion(pack2.getId()) : inventoryUtil.getLastInstalledVersion(pack2.getId(), true);
            if (version == null) continue;
            packNode = new AvayaCheckBoxNode(pack2.getId(), pack2.getName() + " - " + version.toString(), false);
            rootNode.add(packNode);
        }
        if (rootNode.getChildCount() == 0) {
            String msg = this.idata.langpack.getString("uninstaller.exit.message");
            if (rollback) {
                msg = this.idata.langpack.getString("rollback.exit.message");
            }
            JOptionPane.showMessageDialog(this, msg);
            System.exit(-1);
        }
        return rootNode;
    }

    public boolean isValidated() {
        ArrayList<Pack> selectedPacks = new ArrayList<Pack>();
        AvayaCheckBoxNode boxNode = (AvayaCheckBoxNode)this.getTree().getModel().getRoot();
        Enumeration<TreeNode> enumeration = boxNode.depthFirstEnumeration();
        String version = null;
        String text = null;
        String name = null;
        while (enumeration.hasMoreElements()) {
            AvayaCheckBoxNode checkBoxNode = (AvayaCheckBoxNode)enumeration.nextElement();
            if (!checkBoxNode.isSelected() || checkBoxNode.isRoot()) continue;
            text = checkBoxNode.getText();
            name = text.substring(0, text.lastIndexOf("-")).trim();
            version = text.substring(text.lastIndexOf("-") + 1).trim();
            selectedPacks.add(new Pack(name, checkBoxNode.getId(), version, name + version, null, null, false, false, false, null, true));
        }
        IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
        this.idata.setVariable("InstallPath", inventoryUtil.getInstallPath());
        this.idata.setAttribute("SelectedPacks", selectedPacks);
        this.idata.selectedPacks = selectedPacks;
        if (selectedPacks.size() == 0) {
            int result = JOptionPane.showConfirmDialog(this, this.idata.langpack.getString("uninstaller.select.message"), this.idata.langpack.getString("uninstaller.select.title"), 2);
            if (result == 2) {
                System.exit(result);
            } else {
                return false;
            }
        }
        return true;
    }

    public void panelActivate() {
        boolean rollback;
        boolean bl = rollback = "rollback".equals(this.idata.getVariable("Uninstall"));
        if (rollback) {
            String logMsgFile = "ifmessages_rollback.xml";
            InputStream stream = this.getClass().getResourceAsStream("/langpacks/" + logMsgFile);
            try {
                AutomatedInstallData.getInstance().logMessages = new LocaleDatabase(stream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.tree == null) {
            this.tree = new JTree(this.createNodes());
            this.tree.setRootVisible(true);
            this.tree.setShowsRootHandles(true);
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.addMouseListener(this);
            this.tree.setCellRenderer(new AvayaCheckBoxNodeRenderer(this));
            JScrollPane treeView = new JScrollPane(this.tree);
            treeView.setPreferredSize(new Dimension(511, 511));
            this.setLayout(new BorderLayout());
            this.remove(treeView);
            this.add((Component)treeView, "West");
            this.tree.treeDidChange();
        }
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.tree.getRowForLocation(e.getX(), e.getY()) != -1) {
            this.changeValue();
        }
    }

    public void mouseReleased(MouseEvent arg0) {
    }
}

