/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.avaya.panther.framework.puur.RestoreUtil;
import com.avaya.panther.installer.AvayaHomeKeeper;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.panels.AvayaCustomDialog;
import com.avaya.panther.util.AvayaBaseUtil;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.AutomatedInstaller;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.installer.WebRepositoryAccessor;
import com.izforge.izpack.panels.InstallPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;

public class Unpacker
extends UnpackerBase {
    private static final String tempPath = "$INSTALL_PATH/Uninstaller/IzpackWebTemp";
    List<String> executedPackIds = new ArrayList<String>();
    Map<String, String> packInstallationState = null;

    public Unpacker(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        super(idata, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String installStage = "copy";
        this.idata.setVariable("installationCancelled", "false");
        if (AutomatedInstallData.doValidation) {
            AvayaBaseUtil.initAvayaBase(this.idata, false);
            if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                AutomatedInstaller ai = (AutomatedInstaller)this.idata.getAttribute("AutomatedInstaller_Ref");
                ai.refreshDynamicVariables();
            } else {
                InstallerFrame iframe = (InstallerFrame)this.idata.getAttribute("InstallerFrame_Ref");
                iframe.refreshDynamicVariables();
            }
        }
        this.verfiySelectedPacks();
        this.addToInstances();
        try {
            FileOutputStream out = null;
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            LinkedHashMap executablesMap = new LinkedHashMap();
            int execFileCounter = 0;
            ArrayList<UpdateCheck> updatechecks = new ArrayList<UpdateCheck>();
            List packs = this.idata.selectedPacks;
            int npacks = packs.size();
            this.handler.startAction("Unpacking", npacks);
            this.udata = UninstallData.getInstance();
            List[] customActions = this.getCustomActions();
            this.informListeners(customActions, 7, this.idata, new Integer(npacks), this.handler);
            packs = this.idata.selectedPacks;
            npacks = packs.size();
            int noOfFiles = 0;
            int numOfParsables = 0;
            ArrayList<String> zippedFile = new ArrayList<String>();
            this.packInstallationState = new HashMap<String, String>();
            List<String> installedPacks = InventoryUtil.getInventory().getInstalledPackIDs();
            String fileCopyStr = this.idata.langpack.getString("file.copying");
            for (int i = 0; i < npacks; ++i) {
                File zip;
                String zipFileName;
                Pack p;
                block99: {
                    String name;
                    Debug.log(this.idata.logMessages.getString("started") + ((Pack)packs.get((int)i)).name);
                    p = (Pack)packs.get(i);
                    if (installedPacks != null && installedPacks.contains(p.id)) {
                        this.packInstallationState.put(p.id, "UPDATE_INSTALLATION");
                    } else {
                        this.packInstallationState.put(p.id, "NEW_INSTALLATION");
                    }
                    zipFileName = AvayaInstallerBase.generatePackMetadataPath(p.id, p.getVersion(), this.idata.getInstallPath());
                    boolean success = new File(zipFileName).mkdirs();
                    zipFileName = zipFileName + File.separator + "backup.zip";
                    File zipFile = new File(zipFileName);
                    if (zipFile.exists()) {
                        IoHelper.deleteFile(zipFile);
                    }
                    ZipOutputStream zipOutputStream = null;
                    if (!this.packInstallationState.get(p.id).equals("NEW_INSTALLATION")) {
                        zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
                    }
                    if (p.hasCondition() && this.rules != null && !this.rules.isConditionTrue(p.getCondition())) continue;
                    this.informListeners(customActions, 5, packs.get(i), new Integer(npacks), this.handler);
                    ObjectInputStream objIn = new ObjectInputStream(this.getPackAsStream(p.id, p.uninstall));
                    int nfiles = objIn.readInt();
                    Pack pack = (Pack)packs.get(i);
                    String stepname = pack.name;
                    if (this.langpack != null && pack.id != null && !"".equals(pack.id) && (name = this.langpack.getString(pack.id)) != null && !"".equals(name)) {
                        stepname = name;
                    }
                    this.handler.nextStep(stepname, i + 1, nfiles);
                    this.udata.addFile("Pack Name:" + pack.id, true);
                    AvayaInstallerBase.createLockFile(this.idata.getInstallPath());
                    AvayaInstallerBase.writeToLockFile("File copy started for Pack: " + pack.id);
                    int pcount = 0;
                    for (int j = 0; j < nfiles; ++j) {
                        PackFile pf = (PackFile)objIn.readObject();
                        if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                            if (++pcount >= 20) {
                                System.out.print("\r                    \r");
                                pcount = 0;
                            }
                            System.out.print(".");
                        }
                        if (Debug.isSTACKTRACE()) {
                            Debug.trace("Copying " + pf.getTargetPath());
                        }
                        if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) {
                            if (Debug.isSTACKTRACE()) {
                                Debug.trace("Skipping " + pf.getTargetPath() + " as condition is not satisfy...");
                            }
                            if (pf.isDirectory() || pf.isBackReference()) continue;
                            objIn.skip(pf.length());
                            continue;
                        }
                        if (OsConstraint.oneMatchesCurrentSystem(pf.osConstraints()) && AvayaInstallerBase.isInstallTypeValid(pf.getInstalltype(), p.getVersion())) {
                            int bytesInBuffer;
                            File pathFile;
                            String path = IoHelper.translatePath(pf.getTargetPath(), this.vs);
                            File dest = pathFile = new File(path);
                            if (!pf.isDirectory()) {
                                dest = pathFile.getParentFile();
                            }
                            if (!dest.exists()) {
                                List fileListeners = customActions[customActions.length - 1];
                                if (fileListeners != null && fileListeners.size() > 0) {
                                    this.mkDirsWithEnhancement(dest, pf, customActions);
                                } else if (!dest.mkdirs()) {
                                    this.handler.emitError("Error creating directories", "Could not create directory\n" + dest.getPath());
                                    this.handler.stopAction();
                                    this.result = false;
                                    return;
                                }
                            }
                            if (pf.isDirectory()) {
                                if (!Debug.isSTACKTRACE()) continue;
                                Debug.trace("Destination is a directory - " + path);
                                continue;
                            }
                            this.informListeners(customActions, 1, pathFile, pf, null);
                            if (pf.isUninstallFlag()) {
                                this.udata.addFile(path + "|" + pf.isUninstallFlag(), pack.uninstall);
                            } else {
                                this.udata.addFile(path, pack.uninstall);
                            }
                            String dispMessage = fileCopyStr + " " + new File(path).getName();
                            this.handler.progress(j, dispMessage);
                            if (pathFile.exists() && pf.override() != 1) {
                                boolean overwritefile = false;
                                if (pf.override() != 0) {
                                    if (pf.override() == 1) {
                                        overwritefile = true;
                                    } else if (pf.override() == 4) {
                                        overwritefile = pathFile.lastModified() < pf.lastModified();
                                    } else {
                                        int answer;
                                        int def_choice = -1;
                                        if (pf.override() == 2) {
                                            def_choice = 49;
                                        }
                                        if (pf.override() == 3) {
                                            def_choice = 47;
                                        }
                                        boolean bl = overwritefile = (answer = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + " - " + pathFile.getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + pathFile.getAbsolutePath(), 37, def_choice)) == 47;
                                    }
                                }
                                if (!overwritefile) {
                                    if (Debug.isSTACKTRACE()) {
                                        Debug.trace("Skipping " + path + " as overwrite is false.");
                                    }
                                    if (pf.isBackReference() || ((Pack)packs.get((int)i)).loose) continue;
                                    objIn.skip(pf.length());
                                    continue;
                                }
                            }
                            if (pathFile.exists() && !this.packInstallationState.get(p.id).equals("NEW_INSTALLATION")) {
                                String strFilePath = pathFile.getAbsolutePath();
                                if (zippedFile.indexOf(strFilePath) < 0) {
                                    int len;
                                    FileInputStream in = new FileInputStream(pathFile);
                                    byte[] buf = new byte[1024];
                                    zipOutputStream.putNextEntry(new ZipEntry("//" + strFilePath));
                                    while ((len = in.read(buf)) > 0) {
                                        zipOutputStream.write(buf, 0, len);
                                    }
                                    zipOutputStream.flush();
                                    zipOutputStream.closeEntry();
                                    zippedFile.add(strFilePath);
                                    Debug.log("Successfully backed up " + strFilePath + ".");
                                    in.close();
                                }
                                if (this.performInterrupted()) {
                                    zipOutputStream.close();
                                    this.exit("copy");
                                    return;
                                }
                            }
                            InputStream pis = objIn;
                            if (pf.isBackReference()) {
                                InputStream is = this.getPackAsStream(pf.previousPackId, pack.uninstall);
                                pis = new ObjectInputStream(is);
                                is.skip(pf.offsetInPreviousPack - 4L);
                            } else if (((Pack)packs.get((int)i)).loose) {
                                File resolvedFile;
                                File installerDir;
                                URL url = this.getClass().getResource("/info");
                                String urlPath = url.getPath();
                                int pos = urlPath.indexOf(33);
                                if (pos >= 0 && urlPath.startsWith("file:/")) {
                                    urlPath = urlPath.substring("file:/".length(), pos);
                                }
                                if (!(installerDir = new File(urlPath)).isDirectory()) {
                                    installerDir = installerDir.getParentFile();
                                }
                                if (!(resolvedFile = new File(installerDir, pf.getRelativeSourcePath())).exists()) {
                                    File userDir = new File(System.getProperty("user.dir"));
                                    resolvedFile = new File(userDir, pf.getRelativeSourcePath());
                                }
                                if (resolvedFile.exists()) {
                                    pis = new FileInputStream(resolvedFile);
                                    pf = new PackFile(resolvedFile.getParentFile(), resolvedFile, pf.getTargetPath(), pf.osConstraints(), pf.override(), pf.getAdditionals(), pf.getInstalltype(), pf.isUninstallFlag());
                                } else {
                                    System.out.println("Could not find loosely bundled file: " + pf.getRelativeSourcePath());
                                    out.close();
                                    continue;
                                }
                            }
                            out = new FileOutputStream(pathFile);
                            byte[] buffer = new byte[5120];
                            for (long bytesCopied = 0L; bytesCopied < pf.length(); bytesCopied += (long)bytesInBuffer) {
                                if (this.performInterrupted()) {
                                    out.close();
                                    if (pis != objIn) {
                                        ((InputStream)pis).close();
                                    }
                                    this.exit("copy");
                                    return;
                                }
                                int maxBytes = (int)Math.min(pf.length() - bytesCopied, (long)buffer.length);
                                bytesInBuffer = ((InputStream)pis).read(buffer, 0, maxBytes);
                                if (bytesInBuffer == -1) {
                                    throw new IOException("Unexpected end of stream (installer corrupted?)");
                                }
                                out.write(buffer, 0, bytesInBuffer);
                            }
                            out.close();
                            if (Debug.isSTACKTRACE()) {
                                Debug.trace(pathFile.getAbsoluteFile() + " copied successfully.");
                            }
                            if (pis != objIn) {
                                ((InputStream)pis).close();
                            }
                            if (pf.lastModified() >= 0L) {
                                pathFile.setLastModified(pf.lastModified());
                            }
                            this.informListeners(customActions, 2, pathFile, pf, null);
                            continue;
                        }
                        if (pf.isDirectory() || pf.isBackReference()) continue;
                        objIn.skip(pf.length());
                    }
                    AvayaInstallerBase.writeToLockFile("File copy done.");
                    int numParsables = objIn.readInt();
                    for (int k = 0; k < numParsables; ++k) {
                        ParsableFile pf = (ParsableFile)objIn.readObject();
                        if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition()) || !AvayaInstallerBase.isInstallTypeValid(pf.getInstalltype(), p.getVersion())) continue;
                        pf.path = IoHelper.translatePath(pf.path, this.vs);
                        parsables.add(pf);
                    }
                    int numExecutables = objIn.readInt();
                    ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
                    block25: for (int k = 0; k < numExecutables; ++k) {
                        ExecutableFile ef = (ExecutableFile)objIn.readObject();
                        if (ef.hasCondition() && this.rules != null && !this.rules.isConditionTrue(ef.getCondition())) continue;
                        if (ef.workingDirectory != null) {
                            ef.workingDirectory = IoHelper.translatePath(ef.workingDirectory, this.vs);
                        }
                        ef.path = IoHelper.translatePath(ef.path, this.vs);
                        if (null != ef.argList && !ef.argList.isEmpty()) {
                            String arg = null;
                            for (int j = 0; j < ef.argList.size(); ++j) {
                                arg = (String)ef.argList.get(j);
                                arg = ef.executionStage == 2 || ef.executionStage == 4 ? IoHelper.translatePath(arg) : IoHelper.translatePath(arg, this.vs);
                                ef.argList.set(j, arg);
                            }
                        }
                        if (!AvayaInstallerBase.isInstallTypeValid(ef.installtypelist, p.getVersion())) continue;
                        switch (ef.executionStage) {
                            case 2: {
                                this.udata.addExecutable(ef);
                                continue block25;
                            }
                            case 4: {
                                this.udata.addRollbackExecutable(ef);
                                continue block25;
                            }
                            case 3: {
                                ++execFileCounter;
                                executables.add(ef);
                                continue block25;
                            }
                            case 0: {
                                ++execFileCounter;
                                executables.add(ef);
                                continue block25;
                            }
                            default: {
                                ++execFileCounter;
                                executables.add(ef);
                            }
                        }
                    }
                    if (executables != null && executables.size() > 0) {
                        executablesMap.put(p.id, executables);
                    }
                    this.handleAdditionalUninstallData(this.udata, customActions);
                    int numUpdateChecks = objIn.readInt();
                    for (int k = 0; k < numUpdateChecks; ++k) {
                        UpdateCheck uc = (UpdateCheck)objIn.readObject();
                        updatechecks.add(uc);
                    }
                    objIn.close();
                    if (this.performInterrupted()) {
                        this.exit("copy");
                        return;
                    }
                    this.informListeners(customActions, 6, packs.get(i), new Integer(i), this.handler);
                    Debug.log(this.idata.logMessages.getString("finished") + ((Pack)packs.get((int)i)).name);
                    try {
                        if (zipOutputStream != null) {
                            zipOutputStream.close();
                        }
                    }
                    catch (Exception e) {
                        File zip2 = new File(zipFileName);
                        if (!zip2.exists()) break block99;
                        IoHelper.deleteFile(zip2);
                    }
                }
                if (!this.packInstallationState.get(p.id).equals("NEW_INSTALLATION") || !(zip = new File(zipFileName)).exists()) continue;
                IoHelper.deleteFile(zip);
            }
            noOfFiles = parsables.size() + execFileCounter;
            numOfParsables = parsables.size();
            if (this.handler instanceof InstallPanel) {
                ((InstallPanel)this.handler).startFileExecutionAction(noOfFiles);
            }
            ScriptParser parser = new ScriptParser(parsables, this.vs);
            parser.setProperties(this.handler, this.idata.langpack);
            AvayaInstallerBase.writeToLockFile("File parsing started.");
            if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                System.out.println("\nParsing files");
            }
            parser.parseFiles();
            AvayaInstallerBase.writeToLockFile("File parsing done.");
            if (this.performInterrupted()) {
                this.exit("copy");
                return;
            }
            if (executablesMap != null && executablesMap.size() > 0) {
                ArrayList execList = null;
                ArrayList<ExecutableFile> packExecList = new ArrayList<ExecutableFile>();
                Iterator iterator = executablesMap.values().iterator();
                String packID = null;
                boolean isInterrupted = false;
                boolean executionStage = false;
                installStage = "execution";
                int packExecutionCount = 0;
                while (iterator.hasNext()) {
                    execList = (ArrayList)iterator.next();
                    packExecList.clear();
                    for (ExecutableFile executableFile : execList) {
                        packID = executableFile.packId;
                        if ("UPDATE_INSTALLATION".equals(this.packInstallationState.get(packID)) && (3 == executableFile.executionStage || 0 == executableFile.executionStage)) {
                            packExecList.add(executableFile);
                            continue;
                        }
                        if ("NEW_INSTALLATION".equals(this.packInstallationState.get(packID)) && 0 == executableFile.executionStage) {
                            packExecList.add(executableFile);
                            continue;
                        }
                        if (1 != executableFile.executionStage) continue;
                        packExecList.add(executableFile);
                    }
                    FileExecutor executor = new FileExecutor(packExecList);
                    executor.setProperties(this.handler, numOfParsables + packExecutionCount, this.idata.langpack);
                    AvayaInstallerBase.writeToLockFile("File execution started for pack : " + packID);
                    System.out.flush();
                    if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                        System.out.println("\nFile execution started for pack : " + packID);
                    }
                    if (executor.executeFiles(0, this.handler) != 0) {
                        this.executedPackIds.add(packID);
                        Debug.fatal("File execution failed, The installation was not completed.");
                        if (AvayaInstaller.panther.getInstallationMode().equals("unattended") && !AvayaInstaller.panther.rollBackOnFaliure) {
                            System.out.println(this.idata.langpack.getString("rollback.false.termination") != null ? this.idata.langpack.getString("rollback.false.termination") : "Terminating the installation without rolling back.");
                            Debug.fatal("Terminating the installation without rolling back.");
                            AvayaHomeKeeper.finalActions(this.idata);
                            System.exit(1);
                        } else if (AvayaInstaller.panther.getInstallationMode().equals("unattended") && AvayaInstaller.panther.rollBackOnFaliure) {
                            System.out.println(this.idata.langpack.getString("rollback.true.termination") != null ? this.idata.langpack.getString("rollback.true.termination") : "Terminating the installation with rollback.");
                        }
                        Debug.log("Rolling back the installation.");
                        this.exit(installStage);
                        this.result = false;
                        return;
                    }
                    packExecutionCount += packExecList.size();
                    this.executedPackIds.add(packID);
                    if (!this.performInterrupted()) continue;
                    this.exit(installStage);
                    return;
                }
            }
            AvayaInstallerBase.writeToLockFile("File execution done.");
            if (this.handler instanceof InstallPanel) {
                ((InstallPanel)this.handler).startPutUninstaller("Creating pack uninstallers");
            }
            this.putUninstaller();
            this.performUpdateChecks(updatechecks);
            AvayaInstallerBase.writeToLockFile("Inventory update started.");
            this.informListeners(customActions, 8, this.idata, this.handler, null);
            AvayaInstallerBase.writeToLockFile("Inventory update done.");
            if (this.handler instanceof InstallPanel) {
                ((InstallPanel)this.handler).startCleanUp();
            }
            AvayaInstallerBase.closeLockStream();
            this.writeInstallationInformation();
            this.handler.stopAction();
        }
        catch (Exception err) {
            this.handler.stopAction();
            if ("Installation cancelled".equals(err.getMessage())) {
                this.handler.emitNotification("Installation cancelled");
                Debug.error(err);
            } else {
                this.handler.emitError("Fatal Error", this.idata.langpack.getString("fatal.err.abort") + err.toString());
                err.printStackTrace();
                Debug.fatal(err);
            }
            this.result = false;
            this.exit(installStage);
            return;
        }
        finally {
            this.removeFromInstances();
        }
    }

    private void verfiySelectedPacks() {
        AvayaCustomDialog avDlg;
        ArrayList<String> avayaAvailablePackIds = new ArrayList<String>();
        Iterator avayaAvailablePackItr = this.idata.avayaAvailablePacks.iterator();
        while (avayaAvailablePackItr.hasNext()) {
            avayaAvailablePackIds.add(((Pack)avayaAvailablePackItr.next()).id);
        }
        ArrayList selectedPacks = new ArrayList();
        Iterator itr = this.idata.selectedPacks.iterator();
        while (itr.hasNext()) {
            selectedPacks.add(itr.next());
        }
        ArrayList<Pack> removedPacks = new ArrayList<Pack>();
        for (Pack pack : selectedPacks) {
            if (avayaAvailablePackIds.indexOf(pack.id) >= 0) continue;
            this.idata.selectedPacks.remove(pack);
            Debug.error(pack.name + " has failed the validation and hence removed from the selected pack list.");
            removedPacks.add(pack);
        }
        if (removedPacks.size() > 0) {
            if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
                avDlg = new AvayaCustomDialog(new JFrame(), true);
                avDlg.emitNotification(this.idata.langpack.getString("pack.failed.validation") + removedPacks);
            } else {
                System.out.println(this.idata.langpack.getString("pack.failed.validation") + removedPacks);
            }
        }
        if (this.idata.selectedPacks.size() == 0) {
            if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
                avDlg = new AvayaCustomDialog(new JFrame(), true);
                avDlg.emitNotification(this.idata.langpack.getString("all.failed.validation"));
            } else {
                System.out.println(this.idata.langpack.getString("all.failed.validation"));
            }
            System.exit(1);
        }
    }

    private InputStream getPackAsStream(String packid, boolean uninstall) throws Exception {
        InputStream in = null;
        String webDirURL = this.idata.info.getWebDirURL();
        packid = "-" + packid;
        if (webDirURL == null) {
            in = Unpacker.class.getResourceAsStream("/packs/pack" + packid);
        } else {
            String tempfile;
            String baseName = this.idata.info.getInstallerBase();
            String packURL = webDirURL + "/" + baseName + ".pack" + packid + ".jar";
            String tf = IoHelper.translatePath(tempPath, this.vs);
            try {
                tempfile = WebRepositoryAccessor.getCachedUrl(packURL, tf);
                this.udata.addFile(tempfile, uninstall);
            }
            catch (Exception e) {
                if ("Cancelled".equals(e.getMessage())) {
                    throw new InstallerException("Installation cancelled", e);
                }
                throw new InstallerException("Installation failed", e);
            }
            URL url = new URL("jar:" + tempfile + "!/packs/pack" + packid);
            in = new WebAccessor(null).openInputStream(url);
            if (in == null) {
                throw new InstallerException(url.toString() + " not available", new FileNotFoundException(url.toString()));
            }
        }
        if (in != null && this.idata.info.getPackDecoderClassName() != null) {
            Class<?> decoder = Class.forName(this.idata.info.getPackDecoderClassName());
            Class[] paramsClasses = new Class[]{Class.forName("java.io.InputStream")};
            Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses);
            BufferedInputStream buffer = new BufferedInputStream(in);
            Object[] params = new Object[]{buffer};
            Object instance = null;
            instance = constructor.newInstance(params);
            if (!InputStream.class.isInstance(instance)) {
                throw new InstallerException("'" + this.idata.info.getPackDecoderClassName() + "' must be derived from " + InputStream.class.toString());
            }
            in = instance;
        }
        return in;
    }

    public void cleanUp() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        UninstallData uninstallData = UninstallData.getInstance();
        Iterator it = uninstallData.getInstalledFilesList().iterator();
        if (!it.hasNext()) {
            return;
        }
        while (it.hasNext()) {
            String p = (String)it.next();
            if (p.endsWith("|true")) {
                p = p.substring(0, p.indexOf("|true"));
            }
            File f = new File(p);
            f.delete();
        }
        File installPath = new File(idata.getInstallPath());
        FileUtil.deleteEmptyDirectories(installPath);
        String fullCleanup = idata.getVariable("InstallerFrame.cleanAllAtInterrupt");
        if (fullCleanup != null && "yes".equalsIgnoreCase(fullCleanup)) {
            IoHelper.deleteDir(installPath.getAbsolutePath());
        }
    }

    public void exit(String installStage) {
        int progressCount = 0;
        this.idata.setVariable("installationCancelled", "true");
        this.idata.installSuccess = false;
        if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
            ArrayList<ExecutableFile> packExecList = new ArrayList<ExecutableFile>();
            if (this.handler instanceof InstallPanel) {
                for (String currentPackId : this.executedPackIds) {
                    if ("UPDATE_INSTALLATION".equals(this.packInstallationState.get(currentPackId))) {
                        for (ExecutableFile executableFile : this.udata.getRollbackExecutablesList()) {
                            if (!executableFile.packId.equals(currentPackId)) continue;
                            packExecList.add(executableFile);
                        }
                    } else {
                        for (ExecutableFile executableFile : (ArrayList)this.udata.getExecutablesList()) {
                            if (!executableFile.packId.equals(currentPackId)) continue;
                            packExecList.add(executableFile);
                        }
                    }
                    progressCount = packExecList.size();
                }
            }
        }
        if ("execution".equals(installStage)) {
            if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
                ((InstallPanel)this.handler).rollbackAction(installStage, 0, progressCount);
            }
            Debug.log("Executing rollback scripts.");
            this.executeRollbackScripts();
            Debug.log("Execution of rollback scripts finished.");
            AvayaInstaller.panther.setInstallStatus(" Rolled back");
        }
        if (!"PATCH".equalsIgnoreCase(this.idata.info.getInstallType())) {
            Debug.log("Cleaning up starts.");
            this.cleanUp();
            Debug.log("Cleaning completed.");
        }
        try {
            RestoreUtil.restore(this.idata.selectedPacks, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File lockFie = new File(this.idata.getInstallPath() + File.separator + "lock");
        if (lockFie.exists()) {
            Debug.log("Lock file exist, deleting it.");
            IoHelper.deleteFile(lockFie);
        }
        if (this.handler instanceof InstallPanel) {
            ((InstallPanel)this.handler).stopCancelAction();
        }
    }

    public void executeRollbackScripts() {
        Debug.log("Rolling back installation changes");
        ArrayList<ExecutableFile> packExecList = new ArrayList<ExecutableFile>();
        int executionStage = 0;
        int packExecutionCount = 0;
        for (String currentPackId : this.executedPackIds) {
            int j;
            String arg;
            if ("UPDATE_INSTALLATION".equals(this.packInstallationState.get(currentPackId))) {
                for (ExecutableFile executableFile : this.udata.getRollbackExecutablesList()) {
                    if (!executableFile.packId.equals(currentPackId)) continue;
                    if (executableFile.argList != null && !executableFile.argList.isEmpty()) {
                        arg = null;
                        for (j = 0; j < executableFile.argList.size(); ++j) {
                            arg = (String)executableFile.argList.get(j);
                            arg = IoHelper.translatePath(arg, this.vs);
                            executableFile.argList.set(j, arg);
                        }
                    }
                    packExecList.add(executableFile);
                }
                executionStage = 4;
            } else {
                for (ExecutableFile executableFile : (ArrayList)this.udata.getExecutablesList()) {
                    if (!executableFile.packId.equals(currentPackId)) continue;
                    if (executableFile.argList != null && !executableFile.argList.isEmpty()) {
                        arg = null;
                        for (j = 0; j < executableFile.argList.size(); ++j) {
                            arg = (String)executableFile.argList.get(j);
                            arg = IoHelper.translatePath(arg, this.vs);
                            executableFile.argList.set(j, arg);
                        }
                    }
                    packExecList.add(executableFile);
                }
                executionStage = 2;
            }
            FileExecutor executor = new FileExecutor(packExecList);
            executor.setProperties(this.handler, 0 + packExecutionCount, this.idata.langpack);
            executor.executeFiles(executionStage, this.handler);
            packExecutionCount += packExecList.size();
        }
    }
}

