/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.avaya.panther.installer.AvayaInstaller;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.panels.InstallPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class ScriptParser {
    public static final String INSTALL_PATH = "INSTALL_PATH";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String CLASS_PATH = "CLASS_PATH";
    public static final String USER_HOME = "USER_HOME";
    public static final String USER_NAME = "USER_NAME";
    public static final String HOST_NAME = "HOST_NAME";
    public static final String IP_ADDRESS = "IP_ADDRESS";
    public static final String FILE_SEPARATOR = "FILE_SEPARATOR";
    public static final String APP_NAME = "APP_NAME";
    public static final String APP_URL = "APP_URL";
    public static final String APP_VER = "APP_VER";
    public static final String ISO3_LANG = "ISO3_LANG";
    public static final String LOCALE = "LOCALE_IDENTIFIER";
    private Collection files;
    private VariableSubstitutor vs;
    protected LocaleDatabase langpack = null;
    AbstractUIProgressHandler handler;

    public ScriptParser(Collection files, VariableSubstitutor vs) {
        this.files = files;
        this.vs = vs;
    }

    public void parseFiles() throws Exception {
        int count = 0;
        Iterator iter = this.files.iterator();
        int pcount = 0;
        while (iter.hasNext()) {
            if (Unpacker.isInterruptDesired()) {
                return;
            }
            ParsableFile pfile = (ParsableFile)iter.next();
            Debug.log("Parsing file: " + pfile.path);
            if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                if (++pcount >= 20) {
                    System.out.print("\r                    \r");
                    pcount = 0;
                }
                System.out.print(".");
            }
            if (!OsConstraint.oneMatchesCurrentSystem(pfile.osConstraints)) {
                if (this.handler instanceof InstallPanel) {
                    ((InstallPanel)this.handler).fileProgress(count, this.langpack.getString("file.parse"));
                    ++count;
                }
                ++count;
                continue;
            }
            File file = new File(pfile.path);
            File parsedFile = null;
            try {
                parsedFile = File.createTempFile("izpp", null, file.getParentFile());
            }
            catch (Exception e) {
                Debug.error(e + pfile.path);
            }
            if (this.handler instanceof InstallPanel) {
                String msg = this.langpack.getString("file.parse") + " " + file.getName();
                ((InstallPanel)this.handler).fileProgress(count, msg);
                ++count;
            }
            FileInputStream inFile = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(inFile, 5120);
            FileOutputStream outFile = new FileOutputStream(parsedFile);
            BufferedOutputStream out = new BufferedOutputStream(outFile, 5120);
            this.vs.substitute(in, out, pfile.type, pfile.encoding, pfile.lineFeedType);
            in.close();
            out.close();
            file.delete();
            if (parsedFile.renameTo(file)) continue;
            throw new IOException("Could not rename file " + parsedFile + " to " + file);
        }
    }

    public void setProperties(AbstractUIProgressHandler handler, LocaleDatabase langpack) {
        this.langpack = langpack;
        this.handler = handler;
    }
}

