/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

public class ProcessPanelWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "ProcessPanel.Spec.xml";
    private VariableSubstitutor vs;
    protected AbstractUIProcessHandler handler;
    private ArrayList jobs = new ArrayList();
    private boolean result = true;
    private static PrintWriter logfile = null;
    private String logfiledir = null;
    protected AutomatedInstallData idata;
    private static LocaleDatabase langpack = null;

    public ProcessPanelWorker(AutomatedInstallData idata, AbstractUIProcessHandler handler) throws IOException {
        this.handler = handler;
        this.idata = idata;
        this.vs = new VariableSubstitutor(idata.getVariables());
        langpack = idata.langpack;
    }

    private boolean readSpec() throws IOException {
        XMLElement spec;
        InputStream input;
        try {
            input = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setValidator(new NonValidator());
        try {
            parser.setReader(new StdXMLReader(input));
            spec = (XMLElement)parser.parse();
        }
        catch (Exception e) {
            System.err.println("Error parsing XML specification for processing.");
            System.err.println(e.toString());
            Debug.error("Error parsing XML specification for processing.");
            Debug.error(e.toString());
            return false;
        }
        if (!spec.hasChildren()) {
            return false;
        }
        XMLElement lfd = spec.getFirstChildNamed("logfiledir");
        if (lfd != null) {
            this.logfiledir = lfd.getContent();
        }
        for (XMLElement job_el : spec.getChildrenNamed("job")) {
            String ef_name;
            List constraints;
            String conditionid = job_el.getAttribute("conditionid");
            if (conditionid != null) {
                Debug.trace("Condition for job.");
                Condition cond = RulesEngine.getCondition(conditionid);
                if (cond != null && !cond.isTrue()) {
                    Debug.trace("condition is not fulfilled.");
                    continue;
                }
            }
            Debug.trace("Condition is fulfilled or not existent.");
            Vector forPacks = job_el.getChildrenNamed("executeForPack");
            if (!this.jobRequiredFor(forPacks) || !OsConstraint.oneMatchesCurrentSystem(constraints = OsConstraint.getOsList(job_el))) continue;
            ArrayList<Processable> ef_list = new ArrayList<Processable>();
            String job_name = job_el.getAttribute("name", "");
            for (XMLElement ef : job_el.getChildrenNamed("executefile")) {
                ef_name = ef.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executefile>");
                    Debug.error("missing \"name\" attribute for <executefile>");
                    return false;
                }
                String onFaliure = ef.getAttribute("failure");
                int faliure = 0;
                if (onFaliure == null) {
                    faliure = 3;
                } else {
                    if (onFaliure.contains("$")) {
                        String variable = onFaliure.substring(1, onFaliure.length());
                        onFaliure = this.idata.getVariable(variable);
                    }
                    if (onFaliure == null) {
                        faliure = 3;
                    } else if (onFaliure.equals("abort")) {
                        faliure = 0;
                    } else if (onFaliure.equals("warn")) {
                        faliure = 1;
                    } else if (onFaliure.equals("success")) {
                        faliure = 3;
                    }
                }
                ArrayList<String> args = new ArrayList<String>();
                for (XMLElement arg_el : ef.getChildrenNamed("arg")) {
                    String arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ef_list.add(new ExecutableFile(ef_name, args, faliure));
            }
            for (XMLElement ef : job_el.getChildrenNamed("executeclass")) {
                ef_name = ef.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executeclass>");
                    Debug.error("missing \"name\" attribute for <executeclass>");
                    return false;
                }
                ArrayList<String> args = new ArrayList<String>();
                for (XMLElement arg_el : ef.getChildrenNamed("arg")) {
                    String arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ef_list.add(new ExecutableClass(ef_name, args));
            }
            this.jobs.add(new ProcessingJob(job_name, ef_list));
        }
        return true;
    }

    public void run() {
        try {
            if (!this.readSpec()) {
                System.err.println("Error parsing XML specification for processing.");
                Debug.error("Error parsing XML specification for processing.");
                return;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            Debug.error(ioe.toString());
            return;
        }
        if (this.logfiledir != null) {
            this.logfiledir = IoHelper.translatePath(this.logfiledir, new VariableSubstitutor(this.idata.getVariables()));
            String appVersion = this.idata.getVariable("APP_VER");
            appVersion = appVersion != null ? "V" + appVersion : "undef";
            String identifier = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            identifier = appVersion.replace(' ', '_') + "_" + identifier;
            try {
                File lf = File.createTempFile("Install_" + identifier + "_", ".log", new File(this.logfiledir));
                logfile = new PrintWriter(new FileOutputStream(lf), true);
            }
            catch (IOException e) {
                Debug.error(e);
            }
        }
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob pj : this.jobs) {
            this.handler.startProcess(pj.name);
            this.result = pj.run(this.handler, this.vs);
            this.handler.finishProcess();
            if (this.result) continue;
            break;
        }
        this.handler.finishProcessing();
        if (logfile != null) {
            logfile.close();
        }
    }

    public void startThread() {
        Thread processingThread = new Thread((Runnable)this, "processing thread");
        processingThread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean jobRequiredFor(Vector packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List myArguments;
        protected AbstractUIProcessHandler myHandler;

        public ExecutableClass(String className, List args) {
            this.myClassName = className;
            this.myArguments = args;
        }

        public boolean run(AbstractUIProcessHandler aHandler, VariableSubstitutor varSubstitutor) {
            boolean result = false;
            this.myHandler = aHandler;
            String[] params = new String[this.myArguments.size()];
            int i = 0;
            Iterator arg_it = this.myArguments.iterator();
            while (arg_it.hasNext()) {
                params[i++] = varSubstitutor.substitute((String)arg_it.next(), "plain");
            }
            try {
                if (params != null && params.length > 0) {
                    Debug.log("Started executing " + params[0]);
                }
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> procClass = loader.loadClass(this.myClassName);
                Object o = procClass.newInstance();
                Method m = procClass.getMethod("run", AbstractUIProcessHandler.class, String[].class);
                m.invoke(o, this.myHandler, params);
                result = true;
            }
            catch (SecurityException e) {
                Debug.error("Post Processing Error \n Security exception thrown when processing class: " + this.myClassName);
                this.myHandler.emitError("Post Processing Error", "Security exception thrown when processing class: " + this.myClassName);
            }
            catch (ClassNotFoundException e) {
                Debug.error("Post Processing Error\nCannot find processing class: " + this.myClassName);
                this.myHandler.emitError("Post Processing Error", "Cannot find processing class: " + this.myClassName);
            }
            catch (NoSuchMethodException e) {
                Debug.error("Post Processing Error \nProcessing class does not have 'run' method: " + this.myClassName);
                this.myHandler.emitError("Post Processing Error", "Processing class does not have 'run' method: " + this.myClassName);
            }
            catch (IllegalAccessException e) {
                Debug.error("Post Processing Error\nError accessing processing class: " + this.myClassName);
                this.myHandler.emitError("Post Processing Error", "Error accessing processing class: " + this.myClassName);
            }
            catch (InvocationTargetException e) {
                Debug.error("Post Processing Error\nInvocation Problem calling : " + this.myClassName + ", " + e.getCause().getMessage());
                this.myHandler.emitError("Post Processing Error", "Invocation Problem calling : " + this.myClassName + ", " + e.getCause().getMessage());
            }
            catch (Exception e) {
                Debug.error("Post Processing Error\nException when running processing class: " + this.myClassName + ", " + e.getMessage());
                this.myHandler.emitError("Post Processing Error", "Exception when running processing class: " + this.myClassName + ", " + e.getMessage());
            }
            catch (Error e) {
                Debug.error("Post Processing Error\nError when running processing class: " + this.myClassName + ", " + e.getMessage());
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + e.getMessage());
            }
            catch (Throwable e) {
                Debug.error("Post Processing Error\nError when running processing class: " + this.myClassName + ", " + e.getMessage());
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + e.getMessage());
            }
            if (result) {
                Debug.log("Execution of " + this.myClassName + " Completed");
            } else {
                Debug.log("Execution of " + this.myClassName + " Failed");
            }
            return result;
        }
    }

    private static class ExecutableFile
    implements Processable {
        private String filename;
        private List arguments;
        public final int onfaliure;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String fn, List args, int onfaliure) {
            this.filename = fn;
            this.arguments = args;
            this.onfaliure = onfaliure;
        }

        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            this.handler = handler;
            String[] params = new String[this.arguments.size() + 1];
            params[0] = vs.substitute(this.filename, "plain");
            AutomatedInstallData iData = AutomatedInstallData.getInstance();
            int i = 1;
            Iterator arg_it = this.arguments.iterator();
            while (arg_it.hasNext()) {
                params[i++] = vs.substitute((String)arg_it.next(), "plain");
            }
            try {
                Debug.log("Started executing " + params[0]);
                Process p = Runtime.getRuntime().exec(params);
                OutputMonitor stdoutMon = new OutputMonitor(this.handler, p.getInputStream(), false);
                OutputMonitor stderrMon = new OutputMonitor(this.handler, p.getErrorStream(), true);
                Thread stdoutThread = new Thread(stdoutMon);
                Thread stderrThread = new Thread(stderrMon);
                stdoutThread.setDaemon(true);
                stderrThread.setDaemon(true);
                stdoutThread.start();
                stderrThread.start();
                try {
                    int exitStatus = p.waitFor();
                    this.stopMonitor(stdoutMon, stdoutThread);
                    this.stopMonitor(stderrMon, stderrThread);
                    String[] output = new String[2];
                    output[0] = stdoutMon.toString();
                    Debug.log("stdout:");
                    Debug.log(output[0]);
                    output[1] = stderrMon.toString();
                    Debug.log("stderr:");
                    Debug.log(output[1]);
                    String command = output[0];
                    String message = command + "\n" + output[1];
                    message = AvayaInstallerBase.replacePassword(message);
                    if (message.length() == 1) {
                        message = "Failed to execute " + this.filename + ".";
                    }
                    if (exitStatus != 0) {
                        if (this.onfaliure == 1) {
                            AvayaInstaller.panther.setInstallStatus("warning");
                            ++AvayaInstallData.install_warnings_count;
                            handler.emitWarning("file execution error", message);
                            Debug.error(message);
                            exitStatus = 0;
                        } else if (this.onfaliure == 3) {
                            AvayaInstaller.panther.setInstallStatus("warning");
                            ++AvayaInstallData.install_warnings_count;
                            Debug.error(message);
                            exitStatus = 0;
                        } else if (handler.askQuestion(langpack.getString("file.execute.fail"), message, 37) == 47) {
                            if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
                                AvayaInstaller.panther.setInstallStatus("warning");
                                ++AvayaInstallData.install_warnings_count;
                                Debug.error(message);
                                exitStatus = 0;
                            } else {
                                AvayaInstaller.panther.setInstallStatus("error");
                                ++AvayaInstallData.install_faliure_count;
                                Debug.error(message);
                                iData.installSuccess = false;
                            }
                        } else {
                            AvayaInstaller.panther.setInstallStatus("error");
                            ++AvayaInstallData.install_faliure_count;
                            Debug.error(message);
                            iData.installSuccess = false;
                        }
                    } else {
                        Debug.log("Execution of " + params[0] + " Completed");
                    }
                }
                catch (InterruptedException ie) {
                    p.destroy();
                    this.handler.emitError("process interrupted", ie.toString());
                    return false;
                }
            }
            catch (IOException ioe) {
                this.handler.emitError("I/O error", ioe.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor m, Thread t) {
            m.doStop();
            long softTimeout = 500L;
            try {
                t.join(softTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!t.isAlive()) {
                return;
            }
            t.interrupt();
            long hardTimeout = 500L;
            try {
                t.join(hardTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public static class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = false;

            public OutputMonitor(AbstractUIProcessHandler handler, InputStream is, boolean stderr) {
                this.stderr = stderr;
                this.reader = new BufferedReader(new InputStreamReader(is));
                this.handler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        this.handler.logOutput(line, this.stderr);
                        if (logfile != null) {
                            logfile.println(line);
                        }
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    this.handler.logOutput(ioe.toString(), true);
                    if (logfile == null) return;
                    logfile.println(ioe.toString());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = true;
                }
            }
        }
    }

    private static class ProcessingJob
    implements Processable {
        public String name;
        private List processables;

        public ProcessingJob(String name, List processables) {
            this.name = name;
            this.processables = processables;
        }

        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            for (Processable pr : this.processables) {
                if (pr.run(handler, vs)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, VariableSubstitutor var2);
    }
}

