/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class LogFileMover {
    static String destinationFileName = "";

    private LogFileMover() {
    }

    public static void moveLogFile() {
        String avayaLogDirPath = System.getenv("AVAYA_LOG");
        File tmpLogFilePath = new File(System.getProperty("logfile"));
        tmpLogFilePath.deleteOnExit();
        if (avayaLogDirPath == null) {
            LogFileMover.moveLogToAvayaBase(tmpLogFilePath);
            return;
        }
        File avayaLogDir = new File(avayaLogDirPath);
        avayaLogDir.mkdirs();
        if (!avayaLogDir.isDirectory() || !avayaLogDir.canWrite()) {
            LogFileMover.moveLogToAvayaBase(tmpLogFilePath);
            return;
        }
        File newLogFilePath = new File(avayaLogDir, tmpLogFilePath.getName());
        boolean copied = LogFileMover.copy(tmpLogFilePath, newLogFilePath);
        if (copied) {
            LogFileMover.moveLogToAvayaBase(tmpLogFilePath);
            return;
        }
        System.out.println("Log file has been moved to location: " + destinationFileName + " from location: " + tmpLogFilePath.getAbsolutePath());
    }

    private static void moveLogToAvayaBase(File tmpLogFilePath) {
        String targetDir = AutomatedInstallData.getInstance().getInstallPath() + File.separator + "install_logs";
        File dir = new File(targetDir);
        dir.mkdir();
        File newLogFilePath = new File(targetDir, tmpLogFilePath.getName());
        destinationFileName = newLogFilePath.getAbsolutePath();
        boolean copied = LogFileMover.copy(tmpLogFilePath, newLogFilePath);
        if (copied) {
            System.out.println("Log file has been moved to location: " + destinationFileName + " from location: " + tmpLogFilePath.getAbsolutePath());
        } else {
            System.out.println("Moving from: " + tmpLogFilePath.getAbsolutePath() + " to: " + destinationFileName + " failed.");
            Debug.log("Moving from: " + tmpLogFilePath.getAbsolutePath() + " to: " + destinationFileName + " failed.");
        }
    }

    private static boolean copy(File source, File destination) {
        try {
            int bytesRead;
            destinationFileName = destination.getAbsolutePath();
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source));
            AutomatedInstallData installData = AutomatedInstallData.getInstance();
            if ("rollback".equals(installData.getVariable("Uninstall"))) {
                String destFileName = destination.getName();
                if (destFileName != null) {
                    destFileName = destFileName.replace("uninstall-log", "rollback-log");
                }
                String logFile = destination.getParent() + File.separator + destFileName;
                File newLogFile = new File(logFile);
                destination.renameTo(newLogFile);
                destination = newLogFile;
                destinationFileName = destination.getAbsolutePath();
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[2048];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
            try {
                outputStream.close();
                inputStream.close();
            }
            catch (IOException e) {}
        }
        catch (IOException e) {
            Debug.log(e);
            return false;
        }
        return true;
    }
}

