/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.event.InstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class InvAvayaInstallListener {
    protected AbstractUIProgressHandler handler;
    protected static HashMap instances = new HashMap();
    public static final String ALIVE = "alive";
    public static final String INTERRUPT = "doInterrupt";
    public static final String INTERRUPTED = "interruppted";

    public void executeBeforeInstallListeners(AutomatedInstallData idata) throws Exception {
        this.addToInstances();
        List packs = idata.selectedPacks;
        int npacks = packs.size();
        List[] customActions = this.getCustomActions(idata);
        this.informListeners(customActions, 9, idata, new Integer(npacks));
    }

    public void executeAfterInstallListeners(AutomatedInstallData idata) throws Exception {
        this.addToInstances();
        List packs = idata.selectedPacks;
        int npacks = packs.size();
        List[] customActions = this.getCustomActions(idata);
        this.informListeners(customActions, 10, idata, new Integer(npacks));
    }

    public List[] getCustomActions(AutomatedInstallData idata) {
        int i;
        String[] listenerNames = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] retval = new List[listenerNames.length + 1];
        for (i = 0; i < listenerNames.length; ++i) {
            retval[i] = (List)idata.customData.get(listenerNames[i]);
            if (retval[i] != null) continue;
            retval[i] = new ArrayList();
        }
        if (retval[0].size() > 0) {
            i = retval.length - 1;
            retval[i] = new ArrayList();
            for (InstallerListener li : retval[0]) {
                if (!li.isFileListener()) continue;
                retval[i].add(li);
            }
        }
        return retval;
    }

    protected void informListeners(List[] customActions, int action, Object firstParam, Object secondParam) throws Exception {
        List listener = null;
        switch (action) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                listener = customActions[customActions.length - 1];
                break;
            }
            default: {
                listener = customActions[0];
            }
        }
        if (listener == null) {
            return;
        }
        Iterator iter = listener.iterator();
        while (iter.hasNext()) {
            if (this.shouldInterrupt()) {
                return;
            }
            InstallerListener il = (InstallerListener)iter.next();
            switch (action) {
                case 9: {
                    il.beforeInstallation((AutomatedInstallData)firstParam);
                    break;
                }
                case 10: {
                    il.beforeInstallation((AutomatedInstallData)firstParam);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldInterrupt() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Object doIt = instances.get(this);
            return doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED));
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToInstances() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            instances.put(this, ALIVE);
        }
    }
}

