/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.installer.IResponseFileHandler;
import com.avaya.panther.panels.AvayaBuildHelpGUI;
import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.GUIListener;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.LogFileMover;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.installer.UnpackerFactory;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class InstallerFrame
extends JFrame {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String ICON_RESOURCE = "Installer.image";
    private static final String ICON_RESOURCE_EXT_VARIABLE_NAME = "installerimage.ext";
    private static final String HEADING_ICON_RESOURCE = "Heading.image";
    public LocaleDatabase langpack;
    protected InstallData installdata;
    public IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton prevButton;
    protected JButton helpButton;
    protected JButton nextButton;
    protected JButton quitButton;
    protected JButton retryButton;
    protected ArrayList visiblePanelMapping;
    protected ArrayList guiListener;
    protected JLabel[] headingLabels;
    protected JPanel headingPanel;
    protected JComponent headingCounterComponent;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    public RulesEngine rules;
    public static Object source;
    private static final String CONDITIONS_SPECRESOURCENAME = "conditions.xml";
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";
    private Map dynamicvariables;
    private VariableSubstitutor substitutor;
    private JTextPane debugtxt;
    private Debugger debugger;
    private boolean isBack = false;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(String title, InstallData installdata) throws Exception {
        super(title);
        this.substitutor = new VariableSubstitutor(installdata.variables);
        this.guiListener = new ArrayList();
        this.visiblePanelMapping = new ArrayList();
        this.installdata = installdata;
        this.langpack = installdata.langpack;
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.loadConditions();
        installdata.setRules(this.rules);
        this.loadDynamicVariables();
        this.loadIcons();
        this.loadCustomIcons();
        this.loadPanels();
        this.buildGUI();
        installdata.setAttribute("InstallerFrame_Ref", this);
        this.showFrame();
        this.switchPanel(0);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void refreshDynamicVariables() {
        if (this.dynamicvariables != null) {
            for (String dynvarname : this.dynamicvariables.keySet()) {
                List dynvarList = (List)this.dynamicvariables.get(dynvarname);
                for (DynamicVariable dynvar : dynvarList) {
                    boolean refresh = false;
                    if (dynvar.getConditionid() != null) {
                        if (this.rules != null && this.rules.isConditionTrue(dynvar.getConditionid())) {
                            refresh = true;
                        }
                    } else {
                        refresh = true;
                    }
                    if (!refresh) continue;
                    String newvalue = this.substitutor.substitute(dynvar.getValue(), null);
                    this.installdata.variables.setProperty(dynvar.getName(), newvalue);
                }
            }
        }
    }

    private void loadDynamicVariables() {
        try {
            InputStream in = InstallerFrame.class.getResourceAsStream("/dynvariables");
            ObjectInputStream objIn = new ObjectInputStream(in);
            this.dynamicvariables = (Map)objIn.readObject();
            objIn.close();
        }
        catch (Exception e) {
            Debug.trace("Can not find optional dynamic variables");
            System.out.println(e);
        }
    }

    protected void loadConditions() {
        try {
            InputStream in = InstallerFrame.class.getResourceAsStream("/rules");
            ObjectInputStream objIn = new ObjectInputStream(in);
            Map rules = (Map)objIn.readObject();
            if (rules != null && rules.size() != 0) {
                this.rules = new RulesEngine(rules, (AutomatedInstallData)this.installdata);
            }
            objIn.close();
        }
        catch (Exception e) {
            Debug.trace("Can not find optional rules");
        }
        if (this.rules != null) {
            return;
        }
        try {
            InputStream input = null;
            input = this.getResource(CONDITIONS_SPECRESOURCENAME);
            if (input == null) {
                this.rules = new RulesEngine((XMLElement)null, (AutomatedInstallData)this.installdata);
                return;
            }
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
            parser.setValidator(new NonValidator());
            parser.setReader(new StdXMLReader(input));
            XMLElement conditionsxml = (XMLElement)parser.parse();
            this.rules = new RulesEngine(conditionsxml, (AutomatedInstallData)this.installdata);
        }
        catch (Exception e) {
            Debug.trace("Can not find optional resource conditions.xml");
            this.rules = new RulesEngine((XMLElement)null, (AutomatedInstallData)this.installdata);
        }
    }

    private void loadPanels() throws Exception {
        AvayaInstallerBase.resolveLocale(this.installdata);
        List panelsOrder = this.installdata.panelsOrder;
        int size = panelsOrder.size();
        Class[] paramsClasses = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] params = new Object[]{this, this.installdata};
        int curVisPanelNumber = 0;
        int lastVis = 0;
        int count = 0;
        for (int i = 0; i < size; ++i) {
            Panel p = (Panel)panelsOrder.get(i);
            if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
            String className = p.className;
            String praefix = "com.izforge.izpack.panels.";
            if (className.indexOf(46) > -1) {
                praefix = "";
            }
            Class<?> objectClass = Class.forName(praefix + className);
            Constructor<?> constructor = objectClass.getDeclaredConstructor(paramsClasses);
            this.installdata.currentPanel = p;
            Object object = constructor.newInstance(params);
            IzPanel panel = (IzPanel)object;
            this.installdata.panels.add(panel);
            if (panel.isHidden()) {
                this.visiblePanelMapping.add(count, new Integer(-1));
            } else {
                this.visiblePanelMapping.add(count, new Integer(curVisPanelNumber));
                ++curVisPanelNumber;
                lastVis = count;
            }
            ++count;
            XMLElement panelRoot = new XMLElement(className);
            this.installdata.xmlData.addChild(panelRoot);
        }
        this.visiblePanelMapping.add(count, new Integer(lastVis));
    }

    private void loadIcons() throws Exception {
        ImageIcon img;
        URL url;
        XMLElement icon;
        int i;
        this.icons = new IconsDatabase();
        InputStream inXML = InstallerFrame.class.getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setReader(new StdXMLReader(inXML));
        parser.setValidator(new NonValidator());
        XMLElement data = (XMLElement)parser.parse();
        Vector children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    protected void loadCustomIcons() throws Exception {
        ImageIcon img;
        URL url;
        XMLElement icon;
        int i;
        InputStream inXML = null;
        try {
            inXML = ResourceManager.getInstance().getInputStream(CUSTOM_ICONS_RESOURCEFILE);
        }
        catch (Throwable exception) {
            Debug.trace("Resource customicons.xml not defined. No custom icons available.");
            return;
        }
        Debug.trace("Custom icons available.");
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setReader(new StdXMLReader(inXML));
        parser.setValidator(new NonValidator());
        XMLElement data = (XMLElement)parser.parse();
        Vector children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            Debug.trace("Icon with id found: " + icon.getAttribute("id"));
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    private void buildGUI() {
        this.setDefaultCloseOperation(0);
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        glassPane.addFocusListener(new FocusAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBackground(Color.white);
        this.panelsContainer.setBorder(BorderFactory.createEtchedBorder());
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        Dimension dimCenterPanel = new Dimension(this.installdata.guiPrefs.width, 0 * this.installdata.guiPrefs.height);
        this.panelsContainer.setPreferredSize(dimCenterPanel);
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel panel_0 = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(panel_0);
        NavigationHandler navHandler = new NavigationHandler();
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 0));
        navPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50), BorderFactory.createEmptyBorder()));
        navPanel.add(Box.createHorizontalGlue());
        this.retryButton = ButtonFactory.createButton(this.langpack.getString("installer.retry"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        navPanel.add(this.retryButton);
        this.retryButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.helpButton = ButtonFactory.createButton(this.langpack.getString("installer.help"), this.icons.getImageIcon("help"), this.installdata.buttonsHColor);
        navPanel.add(this.helpButton);
        this.helpButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.prevButton = ButtonFactory.createButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        navPanel.add(this.prevButton);
        this.prevButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        navPanel.add(this.nextButton);
        this.nextButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        navPanel.add(this.quitButton);
        this.quitButton.addActionListener(navHandler);
        Dimension dimNavPanel = new Dimension(this.installdata.guiPrefs.width, 0 * this.installdata.guiPrefs.height);
        this.panelsContainer.setPreferredSize(dimNavPanel);
        this.contentPane.add((Component)navPanel, "South");
        if (Debug.isTRACE()) {
            this.debugger = new Debugger(this.installdata, this.icons, this.rules);
            JPanel debugpanel = this.debugger.getDebugPanel();
            if (this.installdata.guiPrefs.modifier.containsKey("showDebugWindow")) {
                if (Boolean.valueOf((String)this.installdata.guiPrefs.modifier.get("showDebugWindow")).booleanValue()) {
                    JFrame debugframe = new JFrame("Debug information");
                    debugframe.setContentPane(debugpanel);
                    debugframe.setSize(new Dimension(400, 400));
                    debugframe.setVisible(true);
                } else {
                    debugpanel.setPreferredSize(new Dimension(200, 400));
                    this.contentPane.add((Component)debugpanel, "East");
                }
            }
        }
        try {
            ImageIcon icon = this.loadIcon(ICON_RESOURCE, 0, true);
            if (icon != null) {
                JPanel imgPanel = new JPanel();
                imgPanel.setBackground(Color.WHITE);
                imgPanel.setLayout(new BorderLayout());
                imgPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
                imgPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, new Color(204, 0, 0)));
                this.iconLabel = new JLabel(icon);
                Dimension dimImgPanel = new Dimension(this.installdata.guiPrefs.width, 0 * this.installdata.guiPrefs.height);
                this.panelsContainer.setPreferredSize(dimImgPanel);
                imgPanel.add((Component)this.iconLabel, "Before");
                this.contentPane.add((Component)imgPanel, "North");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.loadAndShowImage(0);
        this.getRootPane().setDefaultButton(this.nextButton);
        this.callGUIListener(0, navPanel);
        this.createHeading(navPanel);
    }

    private void callGUIListener(int what) {
        this.callGUIListener(what, null);
    }

    private void callGUIListener(int what, Object param) {
        Iterator iter = this.guiListener.iterator();
        while (iter.hasNext()) {
            ((GUIListener)iter.next()).guiActionPerformed(what, param);
        }
    }

    private ImageIcon loadIcon(String resPrefix, int PanelNo, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        String iconext = this.getIconResourceNameExtension();
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e) {
                icon = rm.getImageIconResource(resPrefix + "." + PanelNo + iconext);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + PanelNo + iconext);
        }
        return icon;
    }

    private ImageIcon loadIcon(String resPrefix, String panelid, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        String iconext = this.getIconResourceNameExtension();
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e) {
                icon = rm.getImageIconResource(resPrefix + "." + panelid + iconext);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + panelid + iconext);
        }
        return icon;
    }

    private String getIconResourceNameExtension() {
        try {
            String iconext = this.installdata.getVariable(ICON_RESOURCE_EXT_VARIABLE_NAME);
            if (iconext == null) {
                iconext = "";
            } else if (iconext.length() > 0 && iconext.charAt(0) != '.') {
                iconext = "." + iconext;
            }
            iconext = iconext.trim();
            return iconext;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void loadAndShowImage(int panelNo) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo);
    }

    private void loadAndShowImage(int panelNo, String panelid) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo, panelid);
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelno, String panelid) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelid, false);
        }
        catch (Exception e) {
            try {
                icon = this.loadIcon(resPrefix, panelno, false);
            }
            catch (Exception ex) {
                try {
                    icon = this.loadIcon(resPrefix, panelid, true);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelNo) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelNo, false);
        }
        catch (Exception e) {
            try {
                icon = this.loadIcon(resPrefix, panelNo, true);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
        this.setIconImage(this.icons.getImageIcon("TestIcon").getImage());
    }

    protected void switchPanel(int last) {
        this.refreshDynamicVariables();
        try {
            if (this.installdata.curPanelNumber < last) {
                this.isBack = true;
            }
            this.panelsContainer.setVisible(false);
            IzPanel panel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
            IzPanel l_panel = (IzPanel)this.installdata.panels.get(last);
            if (Debug.isTRACE()) {
                this.debugger.switchPanel(panel.getMetadata(), l_panel.getMetadata());
            }
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: try switching panel from {0} to {1} ({2} to {3})", new String[]{l_panel.getClass().getName(), panel.getClass().getName(), Integer.toString(last), Integer.toString(this.installdata.curPanelNumber)}, "PanelTrace", null);
            if ((Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber) == 0) {
                this.prevButton.setVisible(false);
                this.lockPrevButton();
                this.unlockNextButton();
            } else if ((Integer)this.visiblePanelMapping.get(this.installdata.panels.size()) == this.installdata.curPanelNumber) {
                this.prevButton.setVisible(false);
                this.nextButton.setVisible(false);
                this.lockNextButton();
            } else {
                if (((IzPanel)this.installdata.panels.get((int)this.installdata.curPanelNumber)).myClassname.equals("InstallPanel")) {
                    this.prevButton.setEnabled(false);
                    this.lockPrevButton();
                } else {
                    this.prevButton.setEnabled(true);
                    this.unlockPrevButton();
                }
                this.prevButton.setVisible(true);
                this.nextButton.setVisible(true);
                this.unlockNextButton();
            }
            String currentPanel = ((IzPanel)this.installdata.panels.get((int)this.installdata.curPanelNumber)).myClassname;
            if ("FinishPanel".equals(currentPanel) || "HelloPanel".equals(currentPanel)) {
                this.helpButton.setVisible(false);
            } else {
                this.helpButton.setVisible(true);
            }
            if ("CAFPanel".equals(currentPanel)) {
                this.retryButton.setVisible(true);
            } else {
                this.retryButton.setVisible(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JButton cdb = null;
                    String buttonName = "next";
                    if (InstallerFrame.this.nextButton.isEnabled()) {
                        cdb = InstallerFrame.this.nextButton;
                        InstallerFrame.this.quitButton.setDefaultCapable(false);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(true);
                    } else if (InstallerFrame.this.quitButton.isEnabled()) {
                        cdb = InstallerFrame.this.quitButton;
                        buttonName = "quit";
                        InstallerFrame.this.quitButton.setDefaultCapable(true);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(false);
                    }
                    InstallerFrame.this.getRootPane().setDefaultButton(cdb);
                    Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: setting {0} as default button", new String[]{buttonName}, "PanelTrace", null);
                }
            });
            this.panelsContainer.remove(l_panel);
            l_panel.panelDeactivate();
            this.panelsContainer.add(panel);
            if (panel.getInitialFocus() != null) {
                JTextComponent inText;
                final Component inFoc = panel.getInitialFocus();
                if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
                    inFoc.requestFocus();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            inFoc.requestFocusInWindow();
                        }
                    });
                }
                if (inFoc instanceof JTextComponent && (inText = (JTextComponent)inFoc).isEditable() && inText.getDocument() != null) {
                    inText.setCaretPosition(inText.getDocument().getLength());
                }
            }
            this.performHeading(panel);
            this.performHeadingCounter(panel);
            panel.panelActivate();
            try {
                this.panelsContainer.setVisible(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            Panel metadata = panel.getMetadata();
            if (metadata != null && !"UNKNOWN".equals(metadata.getPanelid())) {
                this.loadAndShowImage((Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber), metadata.getPanelid());
            } else {
                this.loadAndShowImage((Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber));
            }
            this.isBack = false;
            this.callGUIListener(3);
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: switched", null, "PanelTrace", null);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUninstallData() {
        String logfile = this.installdata.getVariable("InstallerFrame.logfilePath");
        BufferedWriter extLogWriter = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = "$INSTALL_PATH/Uninstaller/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, new VariableSubstitutor(this.installdata.getVariables())))).getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                Debug.trace("Cannot create logfile!");
                Debug.error(e);
            }
            if (out != null) {
                extLogWriter = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        try {
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getUninstalableFilesList();
            ZipOutputStream outJar = this.installdata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            BufferedWriter logWriter = null;
            Iterator<Object> iter = null;
            for (Pack pack : this.installdata.selectedPacks) {
                outJar.putNextEntry(new ZipEntry(pack.id + "-" + pack.getVersion() + ".log"));
                logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
                logWriter.write(this.installdata.getVariables().getProperty("INSTALL_PATH", this.installdata.getInstallPath()));
                logWriter.newLine();
                iter = files.iterator();
                if (extLogWriter != null) {
                    while (iter.hasNext()) {
                        String txt = (String)iter.next();
                        logWriter.write(txt);
                        extLogWriter.write(txt);
                        if (!iter.hasNext()) continue;
                        logWriter.newLine();
                        extLogWriter.newLine();
                    }
                    logWriter.flush();
                    extLogWriter.flush();
                } else {
                    while (iter.hasNext()) {
                        logWriter.write((String)iter.next());
                        if (!iter.hasNext()) continue;
                        logWriter.newLine();
                    }
                    logWriter.flush();
                }
                outJar.closeEntry();
            }
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("rollbackExecutables"));
            ObjectOutputStream execStream1 = new ObjectOutputStream(outJar);
            iter = udata.getRollbackExecutablesList().iterator();
            execStream1.writeInt(udata.getRollbackExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream1.writeObject(file);
            }
            execStream1.flush();
            outJar.closeEntry();
            Map additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = (String)keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            outJar.putNextEntry(new ZipEntry("rootscript"));
            ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
            String rootScript = udata.getRootScript();
            rootStream.writeUTF(rootScript);
            rootStream.flush();
            outJar.closeEntry();
            outJar.flush();
            outJar.close();
            for (Pack pack : this.installdata.selectedPacks) {
                IoHelper.copyZipFile(this.installdata.getInstallPath() + File.separator + this.installdata.info.getUninstallerName(), AvayaInstallerBase.generatePackMetadataPath(pack.id, pack.getVersion(), this.installdata.getInstallPath()) + File.separator + this.installdata.info.getUninstallerName());
            }
            File uninstaller = new File(this.installdata.getInstallPath() + File.separator + this.installdata.info.getUninstallerName());
            if (uninstaller.exists()) {
                uninstaller.delete();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        finally {
            LogFileMover.moveLogFile();
        }
    }

    public InputStream getResource(String res) throws Exception {
        String basePath = "";
        ResourceManager rm = null;
        try {
            rm = ResourceManager.getInstance();
            rm.getClass();
            basePath = "/res/";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream result = this.getClass().getResourceAsStream(basePath + res);
        if (result == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + res);
        }
        return result;
    }

    public void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public void exit() {
        if (this.installdata.canClose) {
            this.writeUninstallData();
            Housekeeper.getInstance().shutDown(0);
        } else {
            VariableSubstitutor vs;
            int res;
            if (Unpacker.isDiscardInterrupt() && this.interruptCount < 3) {
                ++this.interruptCount;
                return;
            }
            String mkey = "installer.quit.reversemessage";
            String tkey = "installer.quit.reversetitle";
            String message = this.langpack.getString("installer.quit.reversemessage");
            String title = this.langpack.getString("installer.quit.reversetitle");
            if (message.indexOf("installer.quit.reversemessage") > -1) {
                message = AvayaInstallerBase.isUninstall() ? this.langpack.getString("uninstaller.quit.message") : this.langpack.getString("installer.quit.message");
            }
            if (title.indexOf("installer.quit.reversetitle") > -1) {
                title = this.langpack.getString("installer.quit.title");
            }
            if ((res = JOptionPane.showConfirmDialog(this, message = (vs = new VariableSubstitutor(this.installdata.getVariables())).substitute(message, null), title = vs.substitute(title, null), 0)) == 0) {
                this.wipeAborted();
                if (AvayaInstaller.panther.getInstallStage().equals("preinstall")) {
                    Housekeeper.getInstance().shutDown(0);
                }
            }
        }
    }

    protected void wipeAborted() {
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
    }

    private void cleanWipe(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                this.cleanWipe(files[i]);
            }
        }
        file.delete();
    }

    public void install(AbstractUIProgressHandler listener) {
        IUnpacker unpacker = UnpackerFactory.getUnpacker(this.installdata.info.getUnpackerClassName(), this.installdata, listener);
        unpacker.setRules(this.rules);
        Thread unpackerthread = new Thread((Runnable)unpacker, "IzPack - Unpacker thread");
        unpackerthread.start();
    }

    public void writeXMLTree(XMLElement root, OutputStream out) throws Exception {
        XMLWriter writer = new XMLWriter(out);
        for (int i = 0; i < this.installdata.panels.size(); ++i) {
            IzPanel panel = (IzPanel)this.installdata.panels.get(i);
            panel.makeXMLData(this.installdata.xmlData.getChildAtIndex(i));
        }
        writer.write(this.installdata.xmlData);
    }

    public void setQuitButtonText(String text) {
        String text1 = text;
        if (text1 == null) {
            text1 = this.langpack.getString("installer.quit");
        }
        this.quitButton.setText(text1);
    }

    public void setQuitButtonIcon(String iconName) {
        String useButtonIcons = (String)this.installdata.guiPrefs.modifier.get("useButtonIcons");
        if (useButtonIcons == null || "yes".equalsIgnoreCase(useButtonIcons)) {
            this.quitButton.setIcon(this.icons.getImageIcon(iconName));
        }
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
        this.callGUIListener(1);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
        this.callGUIListener(2);
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.unlockNextButton(true);
    }

    public void unlockRetryButton() {
        this.retryButton.setEnabled(true);
    }

    public void lockRetryButton() {
        this.retryButton.setEnabled(false);
    }

    public void unlockNextButton(boolean requestFocus) {
        this.nextButton.setEnabled(true);
        if (requestFocus) {
            this.nextButton.requestFocus();
        }
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            if (this.isBack) {
                --this.installdata.curPanelNumber;
                this.switchPanel(this.installdata.curPanelNumber + 1);
            } else {
                ++this.installdata.curPanelNumber;
                this.switchPanel(this.installdata.curPanelNumber - 1);
            }
        }
    }

    public boolean canShow(int panelnumber) {
        IzPanel panel = (IzPanel)this.installdata.panels.get(panelnumber);
        Panel panelmetadata = panel.getMetadata();
        String panelid = panelmetadata.getPanelid();
        Debug.trace("Current Panel: " + panelid);
        if (panelmetadata.hasCondition()) {
            Debug.log("Checking panelcondition");
            return this.rules.isConditionTrue(panelmetadata.getCondition());
        }
        if (!this.rules.canShowPanel(panelid, this.installdata.variables)) {
            Debug.log("Skip panel with panelid=" + panelid);
            return false;
        }
        return true;
    }

    public void navigateNext() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        this.navigateNext(this.installdata.curPanelNumber);
    }

    public void navigateNext(int last) {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            boolean isValid = ((IzPanel)this.installdata.panels.get(last)).isValidated();
            if (!isValid) {
                return;
            }
            boolean isPanelValid = ((IzPanel)this.installdata.panels.get(last)).isPanelValidated(this.installdata);
            if (!isPanelValid) {
                return;
            }
            ++this.installdata.curPanelNumber;
            while (!this.canShow(this.installdata.curPanelNumber) && this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
                ++this.installdata.curPanelNumber;
            }
            if (isValid) {
                this.quitButton.setEnabled(true);
                this.switchPanel(last);
            } else {
                --this.installdata.curPanelNumber;
            }
        }
    }

    public void navigatePrevious() {
        if (!this.prevButton.isEnabled()) {
            return;
        }
        this.navigatePrevious(this.installdata.curPanelNumber);
    }

    public void navigatePrevious(int last) {
        if (this.installdata.curPanelNumber > 0) {
            --this.installdata.curPanelNumber;
            if (!this.canShow(this.installdata.curPanelNumber)) {
                this.navigatePrevious(last);
            } else {
                this.switchPanel(last);
            }
        }
    }

    public List getGuiListener() {
        return this.guiListener;
    }

    public void addGuiListener(GUIListener listener) {
        this.guiListener.add(listener);
    }

    private void createHeadingLabels(int headingLines, Color back) {
        float fontSize;
        this.headingLabels = new JLabel[headingLines + 1];
        this.headingLabels[0] = new JLabel("");
        this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(1));
        Color foreground = null;
        if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
            foreground = Color.decode((String)this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
            this.headingLabels[0].setForeground(foreground);
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingFontSize") && (double)(fontSize = Float.parseFloat((String)this.installdata.guiPrefs.modifier.get("headingFontSize"))) > 0.0 && (double)fontSize <= 5.0) {
            float currentSize = this.headingLabels[0].getFont().getSize2D();
            this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(currentSize * fontSize));
        }
        for (int i = 1; i < headingLines; ++i) {
            this.headingLabels[i] = new JLabel();
            this.headingLabels[i].setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        }
    }

    private void createHeadingCounter(Color back, JPanel navPanel, JPanel leftHeadingPanel) {
        String counterPos = "inHeading";
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounterPos")) {
            counterPos = (String)this.installdata.guiPrefs.modifier.get("headingPanelCounterPos");
        }
        if (leftHeadingPanel == null && "inHeading".equalsIgnoreCase(counterPos)) {
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounter")) {
            this.headingCounterComponent = null;
            if ("progressbar".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JProgressBar headingProgressBar = new JProgressBar();
                headingProgressBar.setStringPainted(true);
                headingProgressBar.setString("");
                headingProgressBar.setValue(0);
                this.headingCounterComponent = headingProgressBar;
            } else if ("text".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JLabel headingCountPanels = new JLabel(" ");
                this.headingCounterComponent = headingCountPanels;
                this.headingCounterComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
                Color foreground = null;
                if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
                    foreground = Color.decode((String)this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
                    headingCountPanels.setForeground(foreground);
                }
            }
            if ("inHeading".equals(counterPos)) {
                leftHeadingPanel.add(this.headingCounterComponent);
            } else if ("inNavigationPanel".equals(counterPos)) {
                int i;
                Component[] comps = navPanel.getComponents();
                for (i = 0; i < comps.length && !comps[i].equals(this.prevButton); ++i) {
                }
                if (i <= comps.length) {
                    navPanel.add(Box.createHorizontalGlue(), i);
                    navPanel.add((Component)this.headingCounterComponent, i);
                }
            }
        }
    }

    private JPanel createHeadingIcon(Color back) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(HEADING_ICON_RESOURCE, 0, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        JPanel imgPanel = new JPanel();
        imgPanel.setLayout(new BoxLayout(imgPanel, 1));
        int borderSize = 8;
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageBorderSize")) {
            borderSize = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingImageBorderSize"));
        }
        imgPanel.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        if (back != null) {
            imgPanel.setBackground(back);
        }
        JLabel iconLab = new JLabel(icon);
        imgPanel.add((Component)iconLab, "East");
        this.headingLabels[this.headingLabels.length - 1] = iconLab;
        return imgPanel;
    }

    private void createHeading(JPanel navPanel) {
        this.headingPanel = null;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        Color back = null;
        int i = 0;
        if (this.installdata.guiPrefs.modifier.containsKey("headingBackgroundColor")) {
            back = Color.decode((String)this.installdata.guiPrefs.modifier.get("headingBackgroundColor"));
        }
        if (!this.isHeading(null)) {
            this.createHeadingCounter(back, navPanel, null);
            return;
        }
        this.createHeadingLabels(headingLines, back);
        JPanel leftHeadingPanel = new JPanel();
        if (back != null) {
            leftHeadingPanel.setBackground(back);
        }
        leftHeadingPanel.setLayout(new BoxLayout(leftHeadingPanel, 1));
        for (i = 0; i < headingLines; ++i) {
            leftHeadingPanel.add(this.headingLabels[i]);
        }
        this.createHeadingCounter(back, navPanel, leftHeadingPanel);
        JPanel imgPanel = this.createHeadingIcon(back);
        JPanel northPanel = new JPanel();
        if (back != null) {
            northPanel.setBackground(back);
        }
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        northPanel.add(leftHeadingPanel);
        northPanel.add(Box.createHorizontalGlue());
        northPanel.add(imgPanel);
        this.headingPanel = new JPanel(new BorderLayout());
        this.headingPanel.add(northPanel);
        this.headingPanel.add((Component)new JSeparator(), "South");
        this.contentPane.add((Component)this.headingPanel, "North");
    }

    public boolean isHeading(IzPanel caller) {
        if (!this.installdata.guiPrefs.modifier.containsKey("useHeadingPanel") || !((String)this.installdata.guiPrefs.modifier.get("useHeadingPanel")).equalsIgnoreCase("yes")) {
            return false;
        }
        if (caller == null) {
            return true;
        }
        return caller.getI18nStringForClass("headline", null) != null;
    }

    private void performHeading(IzPanel panel) {
        int i;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        if (this.headingLabels == null) {
            return;
        }
        String headline = panel.getI18nStringForClass("headline");
        if (headline == null) {
            this.headingPanel.setVisible(false);
            return;
        }
        for (i = 0; i <= headingLines; ++i) {
            if (this.headingLabels[i] == null) continue;
            this.headingLabels[i].setVisible(false);
        }
        for (i = 0; i < headingLines - 1; ++i) {
            String info = panel.getI18nStringForClass("headinfo" + Integer.toString(i));
            if (info == null) {
                info = " ";
            }
            if (info.endsWith(":")) {
                info = info.substring(0, info.length() - 1) + ".";
            }
            this.headingLabels[i + 1].setText(info);
            this.headingLabels[i + 1].setVisible(true);
        }
        this.headingLabels[0].setText(headline);
        this.headingLabels[0].setVisible(true);
        int curPanelNo = (Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber);
        if (this.headingLabels[headingLines] != null) {
            this.loadAndShowImage(this.headingLabels[headingLines], HEADING_ICON_RESOURCE, curPanelNo);
            this.headingLabels[headingLines].setVisible(true);
        }
        this.headingPanel.setVisible(true);
    }

    private void performHeadingCounter(IzPanel panel) {
        if (this.headingCounterComponent != null) {
            int curPanelNo = (Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber);
            int visPanelsCount = (Integer)this.visiblePanelMapping.get((Integer)this.visiblePanelMapping.get(this.installdata.panels.size()));
            StringBuffer buf = new StringBuffer();
            buf.append(this.langpack.getString("installer.step")).append(" ").append(curPanelNo + 1).append(" ").append(this.langpack.getString("installer.of")).append(" ").append(visPanelsCount + 1);
            if (this.headingCounterComponent instanceof JProgressBar) {
                JProgressBar headingProgressBar = (JProgressBar)this.headingCounterComponent;
                headingProgressBar.setMaximum(visPanelsCount + 1);
                headingProgressBar.setValue(curPanelNo + 1);
                headingProgressBar.setString(buf.toString());
            } else {
                ((JLabel)this.headingCounterComponent).setText(buf.toString());
            }
        }
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getQuitButton() {
        return this.quitButton;
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        protected boolean accept(Component aComp) {
            return aComp == InstallerFrame.this.getGlassPane();
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            InstallerFrame.this.exit();
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            source = e.getSource();
            source = e.getSource();
            if (source == InstallerFrame.this.retryButton) {
                IzPanel panel = (IzPanel)InstallerFrame.this.installdata.panels.get(InstallerFrame.this.installdata.curPanelNumber);
                InstallerFrame.this.lockRetryButton();
                InstallerFrame.this.lockNextButton();
                panel.panelActivateRetry();
            }
            if (source == InstallerFrame.this.prevButton) {
                InstallerFrame.this.navigatePrevious();
            } else if (source == InstallerFrame.this.nextButton) {
                InstallerFrame.this.blockGUI();
                InstallerFrame.this.navigateNext();
                InstallerFrame.this.releaseGUI();
            } else if (source == InstallerFrame.this.helpButton) {
                String panelId = ((IzPanel)InstallerFrame.this.installdata.panels.get((int)InstallerFrame.this.installdata.curPanelNumber)).metadata.getPanelid();
                String help_file = ((IzPanel)InstallerFrame.this.installdata.panels.get((int)InstallerFrame.this.installdata.curPanelNumber)).myClassname + "_" + InstallerFrame.this.installdata.localeISO3 + ".html";
                if (!panelId.startsWith("UNKNOWN")) {
                    URL url = null;
                    String hfile = ((IzPanel)InstallerFrame.this.installdata.panels.get((int)InstallerFrame.this.installdata.curPanelNumber)).myClassname + "_" + panelId + "_" + InstallerFrame.this.installdata.localeISO3 + ".html";
                    try {
                        url = ResourceManager.getInstance().getURL(hfile);
                        if (url != null) {
                            help_file = hfile;
                        }
                    }
                    catch (ResourceNotFoundException e1) {
                        // empty catch block
                    }
                }
                AvayaBuildHelpGUI help = new AvayaBuildHelpGUI(InstallerFrame.this.installdata, InstallerFrame.this.langpack, help_file);
                help.show();
            } else if (source == InstallerFrame.this.quitButton) {
                if (InstallerFrame.this.langpack.getString("FinishPanel.done").equals(InstallerFrame.this.quitButton.getLabel())) {
                    IResponseFileHandler responseFileHandler = InstallerFrame.this.installdata.getResourceFactory().getResponseFileHandler(InstallerFrame.this.installdata);
                    try {
                        if (InstallerFrame.this.installdata.getInstallPath() != null) {
                            responseFileHandler.writeOutputResponseFile(InstallerFrame.this.installdata);
                            responseFileHandler.compareInputOutputResponseFile();
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    AvayaInstaller.panther.setInstallStatus(" Cancelled");
                }
                InstallerFrame.this.exit();
            }
        }
    }
}

