/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.avaya.panther.factory.InstallAvayaFactory;
import com.avaya.panther.factory.UninstallAvayaFactory;
import com.avaya.panther.framework.puur.ConfigParamFileHandler;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.AvayaBaseInventory;
import com.avaya.panther.util.AvayaBaseUtil;
import com.avaya.panther.util.ConsoleProgressBar;
import com.avaya.panther.util.HidePassword;
import com.avaya.panther.util.PasswordEncryptionandDecrpytion;
import com.avaya.panther.util.VersionInfo;
import com.izforge.izpack.CustomData;
import com.izforge.izpack.Info;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.InvAvayaInstallListener;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class InstallerBase {
    protected static final String LANG_FILE_NAME = "CustomLangpack.xml";

    public void loadInstallData(AutomatedInstallData installdata) throws Exception {
        String hostname;
        String IPAddress;
        ObjectInputStream objIn;
        Properties variables = null;
        InputStream in = InstallerBase.class.getResourceAsStream("/vars");
        if (null != in) {
            objIn = new ObjectInputStream(in);
            variables = (Properties)objIn.readObject();
            objIn.close();
        }
        if (null != variables) {
            installdata.addAllVariables(variables);
        }
        in = InstallerBase.class.getResourceAsStream("/info");
        objIn = new ObjectInputStream(in);
        Info inf = (Info)objIn.readObject();
        objIn.close();
        installdata.setVariable("APP_NAME", inf.getAppName());
        if (inf.getAppURL() != null) {
            installdata.setVariable("APP_URL", inf.getAppURL());
        }
        installdata.setVariable("APP_VER", inf.getAppVersion());
        in = InstallerBase.class.getResourceAsStream("/panelsOrder");
        objIn = new ObjectInputStream(in);
        List panelsOrder = (List)objIn.readObject();
        objIn.close();
        in = InstallerBase.class.getResourceAsStream("/packs.info");
        objIn = new ObjectInputStream(in);
        int size = objIn.readInt();
        ArrayList<Pack> availablePacks = new ArrayList<Pack>();
        ArrayList<Pack> avayaAvailablePacks = new ArrayList<Pack>();
        ArrayList<Pack> allPacks = new ArrayList<Pack>();
        for (int i = 0; i < size; ++i) {
            Pack pk = (Pack)objIn.readObject();
            allPacks.add(pk);
            if (!OsConstraint.oneMatchesCurrentSystem(pk.osConstraints)) continue;
            availablePacks.add(pk);
            avayaAvailablePacks.add(pk);
        }
        objIn.close();
        Debug.init();
        String dir = OsVersion.IS_WINDOWS ? this.buildWindowsDefaultPath() : (OsVersion.IS_OSX ? "/Applications" : (new File("/usr/local/").canWrite() ? "/usr/local" : System.getProperty("user.home")));
        try {
            InetAddress addr = InetAddress.getLocalHost();
            IPAddress = addr.getHostAddress();
            hostname = addr.getHostName();
        }
        catch (Exception e) {
            hostname = "";
            IPAddress = "";
        }
        dir = dir + File.separator + "Avaya";
        installdata.setVariable("APPLICATIONS_DEFAULT_ROOT", dir);
        dir = dir + File.separator;
        installdata.setVariable("JAVA_HOME", System.getProperty("java.home"));
        installdata.setVariable("JAVA_SPEC_VERSION", System.getProperty("java.specification.version"));
        installdata.setVariable("CLASS_PATH", System.getProperty("java.class.path"));
        installdata.setVariable("USER_HOME", System.getProperty("user.home"));
        installdata.setVariable("USER_NAME", System.getProperty("user.name"));
        installdata.setVariable("IP_ADDRESS", IPAddress);
        installdata.setVariable("HOST_NAME", hostname);
        installdata.setVariable("FILE_SEPARATOR", File.separator);
        InstallerBase.setPlatformVariables(installdata);
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            String varName = (String)e.nextElement();
            String varValue = System.getProperty(varName);
            if (varValue == null) continue;
            varName = varName.replace('.', '_');
            installdata.setVariable("SYSTEM_" + varName, varValue);
        }
        String allPwdFields = installdata.getVariable("ALL_PASSWD_FIELDS");
        if (null != allPwdFields && !"".equals(allPwdFields) && (null == PasswordEncryptionandDecrpytion.USER_INPUT_KEY || PasswordEncryptionandDecrpytion.USER_INPUT_KEY.equals(""))) {
            PasswordEncryptionandDecrpytion.USER_INPUT_KEY = HidePassword.readPassword("Enter the Encryption Key :");
        }
        if (!AvayaInstallerBase.isUninstall()) {
            new ConsoleProgressBar().start();
        }
        if (AvayaInstallerBase.isUninstall()) {
            installdata.setResourceFactory(new UninstallAvayaFactory());
        } else {
            installdata.setResourceFactory(new InstallAvayaFactory());
        }
        installdata.info = inf;
        installdata.panelsOrder = panelsOrder;
        installdata.availablePacks = availablePacks;
        installdata.avayaAvailablePacks = avayaAvailablePacks;
        installdata.allPacks = allPacks;
        AvayaInstallerBase avayaInstallerBase = new AvayaInstallerBase();
        String logMsgFile = AvayaInstallerBase.isUninstall() ? "ifmessages_uninstall.xml" : "ifmessages_install.xml";
        InputStream stream = this.getClass().getResourceAsStream("/langpacks/" + logMsgFile);
        installdata.logMessages = new LocaleDatabase(stream);
        Debug.log(installdata.logMessages.getString("mode") + " Started");
        Debug.log("Arguments passed through command line " + AvayaInstaller.arguments);
        if (!VersionInfo.printVersion()) {
            Debug.log("Product Name: " + installdata.getVariable("APP_NAME"));
            Debug.log("Product Version: " + installdata.getVariable("APP_VER"));
            Debug.log("Install type: " + installdata.info.getInstallType());
            Debug.log("Cumulative:  " + installdata.info.isCumulative());
        }
        if (AvayaInstaller.panther.getDefConFile() != null && !AvayaInstallerBase.isUninstall()) {
            Debug.log("Loading Default config file.");
            AvayaBaseUtil.loadVariablesFromConfigFile(installdata, AvayaInstaller.panther.getDefConFile());
        }
        if (AvayaInstaller.panther.getResFileLoc() != null) {
            Debug.log("Loading response file.");
            AvayaBaseUtil.loadVariablesFromConfigFile(installdata, AvayaInstaller.panther.getResFileLoc());
            AvayaInstallerBase.setSpecialInstallVariables(installdata);
        }
        String installPath = installdata.getInstallPath();
        if (AvayaInstallerBase.isUninstall()) {
            Class<InstallerBase> clazz = InstallerBase.class;
            String jarPath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            File file = new File(jarPath);
            jarPath = file.getAbsolutePath();
            String install_path = "";
            if ((jarPath.endsWith(".jar") || jarPath.endsWith(".ear") || jarPath.endsWith(".war") || jarPath.endsWith(".sar") || jarPath.endsWith(".zip")) && (install_path = new File(jarPath = file.getParent()).getParent()).indexOf("\\") > -1) {
                install_path = install_path.replaceAll("\\\\", "/");
            }
            installdata.setInstallPath(install_path);
            Debug.log("Install Path = " + install_path);
            Debug.log("Loading config param file.");
            ConfigParamFileHandler.loadConfigParamFile(installdata);
            if (AvayaInstaller.panther.getResFileLoc() != null) {
                Debug.log("Loading response file.");
                AvayaBaseUtil.loadVariablesFromConfigFile(installdata, AvayaInstaller.panther.getResFileLoc());
                AvayaInstallerBase.setSpecialInstallVariables(installdata);
            }
            new ConsoleProgressBar().start();
            AutomatedInstallData.doValidation = false;
        } else if (AvayaInstaller.panther.isAllowAvayaBaseDefinition()) {
            if (installPath == null || installPath.equals("")) {
                if (OsVersion.IS_WINDOWS) {
                    installdata.setInstallPath("C:/AVAYA_BASE");
                } else {
                    installdata.setInstallPath("/opt/Avaya");
                }
            }
            Debug.log("Avaya base creation is unlocked.");
        } else {
            Debug.log("Avaya base creation is locked.");
            AvayaBaseInventory avayaBaseInventory = null;
            avayaBaseInventory = OsVersion.IS_WINDOWS ? new AvayaBaseInventory(AvayaBaseInventory.Os.WINDOWS) : new AvayaBaseInventory(AvayaBaseInventory.Os.UNIX);
            String[] avayaBases = avayaBaseInventory.getAvayaBases();
            if (avayaBases.length == 0) {
                Debug.error("No avaya base found.");
                System.out.println("No avaya base found, can not continue the installation.");
                System.exit(-1);
            }
            String avayaBaseStr = "";
            for (String ab : avayaBases) {
                avayaBaseStr = avayaBaseStr + " : " + ab;
            }
            Debug.log("Avaya base(s) available :" + avayaBaseStr);
            boolean validInstallPath = false;
            if (installPath != null && !installPath.equals("")) {
                installPath = new File(installPath).getAbsolutePath();
                for (int j = 0; j < avayaBases.length; ++j) {
                    if (!installPath.equals(avayaBases[j])) continue;
                    validInstallPath = true;
                    break;
                }
            } else {
                validInstallPath = true;
            }
            if (!validInstallPath) {
                String msg = "Install path specified in one of the response file is not present in AVAYA_BASE";
                msg = msg + ", please blank out value of INSTALL_PATH variable or change the value of INSTALL_PATH in the properties file with the one present in AVAYA_BASE.";
                Debug.error(msg);
                System.out.println(msg);
                System.exit(-1);
            }
            Vector<String> avayaBaseList = new Vector<String>();
            for (int count = 0; count < avayaBases.length; ++count) {
                avayaBaseList.add(avayaBases[count]);
            }
            installdata.setAttribute("ALL_AVAYA_BASES", avayaBaseList);
            if (avayaBases.length == 1) {
                Debug.log("Taking AVAYA_BASE = " + avayaBases[0]);
                installdata.setInstallPath(avayaBases[0]);
            }
        }
        avayaInstallerBase.setPanelVariables(installdata);
        this.loadCustomData(installdata);
        InvAvayaInstallListener invAvayaInstallListener = new InvAvayaInstallListener();
        invAvayaInstallListener.executeBeforeInstallListeners(installdata);
        if (PasswordEncryptionandDecrpytion.USER_INPUT_KEY == null || PasswordEncryptionandDecrpytion.USER_INPUT_KEY.equals("")) {
            PasswordEncryptionandDecrpytion.USER_INPUT_KEY = "avaya123";
        }
    }

    protected void addCustomLangpack(AutomatedInstallData idata) {
        try {
            idata.langpack.add(ResourceManager.getInstance().getInputStream(LANG_FILE_NAME));
        }
        catch (Throwable exception) {
            Debug.trace("No custom langpack available.");
            return;
        }
        Debug.trace("Custom langpack for " + idata.localeISO3 + " available.");
    }

    private String buildWindowsDefaultPath() {
        try {
            String prgFilesPath = IoHelper.getenv("ProgramFiles");
            if (prgFilesPath != null && prgFilesPath.length() > 0) {
                return prgFilesPath;
            }
            return this.buildWindowsDefaultPathFromProps();
        }
        catch (Exception x) {
            x.printStackTrace();
            return this.buildWindowsDefaultPathFromProps();
        }
    }

    private String buildWindowsDefaultPathFromProps() {
        StringBuffer dpath = new StringBuffer("");
        try {
            Properties props = new Properties();
            props.load(InstallerBase.class.getResourceAsStream("/com/izforge/izpack/installer/win32-defaultpaths.properties"));
            String drive = System.getProperty("user.home");
            if (drive.length() > 3) {
                drive = drive.substring(0, 3);
            }
            dpath.append(drive);
            if (drive.length() == 2) {
                dpath.append("\\");
            }
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String language_country = language + "_" + country;
            if (null != props.getProperty(language_country)) {
                dpath.append(props.getProperty(language_country));
            } else if (null != props.getProperty(language)) {
                dpath.append(props.getProperty(language));
            } else {
                dpath.append(props.getProperty(Locale.ENGLISH.getLanguage()));
            }
        }
        catch (Exception err) {
            dpath = new StringBuffer("C:\\Program Files");
        }
        return dpath.toString();
    }

    private void loadCustomData(AutomatedInstallData installdata) throws Exception {
        int i;
        String[] streamNames = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] out = new List[streamNames.length];
        for (i = 0; i < streamNames.length; ++i) {
            out[i] = new ArrayList();
        }
        InputStream in = InstallerBase.class.getResourceAsStream("/customData");
        if (in != null) {
            ObjectInputStream objIn = new ObjectInputStream(in);
            Object listeners = objIn.readObject();
            objIn.close();
            Iterator keys = ((List)listeners).iterator();
            while (keys != null && keys.hasNext()) {
                CustomData ca = (CustomData)keys.next();
                if (ca.osConstraints != null && !OsConstraint.oneMatchesCurrentSystem(ca.osConstraints)) continue;
                switch (ca.type) {
                    case 0: {
                        Class<?> clazz = Class.forName(ca.listenerName);
                        if (clazz == null) {
                            throw new InstallerException("Custom action " + ca.listenerName + " not bound!");
                        }
                        out[ca.type].add(clazz.newInstance());
                        break;
                    }
                    case 1: 
                    case 3: {
                        out[ca.type].add(ca);
                        break;
                    }
                    case 2: {
                        out[ca.type].add(ca.contents);
                    }
                }
            }
            for (i = 0; i < streamNames.length; ++i) {
                installdata.customData.put(streamNames[i], out[i]);
            }
        }
    }

    public static void setPlatformVariables(AutomatedInstallData idata) {
        try {
            idata.setVariable("IS_LINUX", OsVersion.IS_LINUX + "");
            idata.setVariable("IS_UNIX", OsVersion.IS_UNIX + "");
            idata.setVariable("IS_REDHAT_LINUX", OsVersion.IS_REDHAT_LINUX + "");
            idata.setVariable("IS_FEDORA_LINUX", OsVersion.IS_FEDORA_LINUX + "");
            idata.setVariable("IS_DEBIAN_LINUX", OsVersion.IS_DEBIAN_LINUX + "");
            idata.setVariable("IS_SUSE_LINUX", OsVersion.IS_SUSE_LINUX + "");
            idata.setVariable("IS_MANDRAKE_LINUX", OsVersion.IS_MANDRAKE_LINUX + "");
            idata.setVariable("IS_MANDRIVA_LINUX", OsVersion.IS_MANDRIVA_LINUX + "");
            idata.setVariable("IS_SUNOS_SPARC", OsVersion.IS_SUNOS_SPARC + "");
            idata.setVariable("IS_WINDOWS", OsVersion.IS_WINDOWS + "");
            idata.setVariable("IS_SPARC", OsVersion.IS_SPARC + "");
            idata.setVariable("IS_HPUX", OsVersion.IS_HPUX + "");
            idata.setVariable("IS_AIX", OsVersion.IS_AIX + "");
            idata.setVariable("IS_SUNOS", OsVersion.IS_SUNOS + "");
            idata.setVariable("IS_OS2", OsVersion.IS_OS2 + "");
            idata.setVariable("IS_MAC", OsVersion.IS_MAC + "");
            idata.setVariable("IS_FREEBSD", OsVersion.IS_FREEBSD + "");
            idata.setVariable("IS_SUNOS_X86", OsVersion.IS_SUNOS_X86 + "");
            idata.setVariable("IS_OSX", OsVersion.IS_OSX + "");
        }
        catch (Exception e) {
            Debug.error(e.toString());
        }
    }
}

