/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.avaya.panther.panels.AvayaCustomDialog;
import com.avaya.panther.util.ConsoleProgressBar;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPackMetalTheme;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class GUIInstaller
extends InstallerBase {
    private InstallData installdata = new InstallData();
    protected String lnf;
    private static final String[] LANGUAGE_DISPLAY_TYPES = new String[]{"iso3", "native", "default"};
    public static final String[][] LANG_CODES = new String[][]{{"cat", "ca"}, {"chn", "zh"}, {"cze", "cs"}, {"dan", "da"}, {"deu", "de"}, {"eng", "en"}, {"fin", "fi"}, {"fra", "fr"}, {"hun", "hu"}, {"ita", "it"}, {"jpn", "ja"}, {"mys", "ms"}, {"ned", "nl"}, {"nor", "no"}, {"pol", "pl"}, {"por", "pt"}, {"rom", "or"}, {"rus", "ru"}, {"spa", "es"}, {"svk", "sk"}, {"swe", "sv"}, {"tur", "tr"}, {"ukr", "uk"}};
    private static HashMap isoTable;

    public GUIInstaller() throws Exception {
        this.loadInstallData(this.installdata);
        this.loadGUIInstallData();
        this.loadLookAndFeel();
        this.checkJavaVersion();
        this.checkJDKAvailable();
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    GUIInstaller.this.loadLangPack();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.installdata.avayaAvailablePacks == null || this.installdata.avayaAvailablePacks.size() == 0) {
            Debug.error("Validation for all the available packs has failed.");
            AvayaCustomDialog avDlg = new AvayaCustomDialog(new JFrame(), true);
            avDlg.emitError(this.installdata.langpack.getString("installer.error"), this.installdata.langpack.getString("no.available.packs"));
            System.exit(1);
        }
        ResourceManager.create(this.installdata);
        this.addCustomLangpack(this.installdata);
        if ("uninstall".equals(this.installdata.getVariable("INSTALLER_MODE"))) {
            Debug.log("[ Starting Interactive Uninstallation ]");
        } else {
            Debug.log("[ Starting Interactive Installation ]");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    GUIInstaller.this.loadGUI();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void loadGUIInstallData() throws Exception {
        InputStream in = GUIInstaller.class.getResourceAsStream("/GUIPrefs");
        ObjectInputStream objIn = new ObjectInputStream(in);
        this.installdata.guiPrefs = (GUIPrefs)objIn.readObject();
        objIn.close();
    }

    private void checkJavaVersion() throws Exception {
        String required;
        String version = System.getProperty("java.version");
        if (version.compareTo(required = this.installdata.info.getJavaVersion()) < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("The application that you are trying to install requires a ");
            msg.append(required);
            msg.append(" version or later of the Java platform.\n");
            msg.append("You are running a ");
            msg.append(version);
            msg.append(" version of the Java platform.\n");
            msg.append("Please upgrade to a newer version.");
            System.out.println(msg.toString());
            JOptionPane.showMessageDialog(null, msg.toString(), "Error", 0);
            System.exit(1);
        }
    }

    private void checkJDKAvailable() {
        String[] message;
        int status;
        if (!this.installdata.info.isJdkRequired()) {
            return;
        }
        FileExecutor exec = new FileExecutor();
        String[] params = new String[]{"javac", "-help"};
        String[] output = new String[2];
        if (exec.executeCommand(params, output) != 0 && (status = JOptionPane.showConfirmDialog(null, message = new String[]{"It looks like your system does not have a Java Development Kit (JDK) available.", "The software that you plan to install requires a JDK for both its installation and execution.", "\n", "Do you still want to proceed with the installation process?"}, "Warning", 0, 2)) == 1) {
            System.exit(1);
        }
    }

    private void loadLangPack() throws Exception {
        String selectedPack;
        int npacks;
        List availableLangPacks = this.getAvailableLangPacks();
        if (availableLangPacks.contains("ifmessages_install")) {
            availableLangPacks.remove("ifmessages_install");
        }
        if (availableLangPacks.contains("ifmessages_uninstall")) {
            availableLangPacks.remove("ifmessages_uninstall");
        }
        if (availableLangPacks.contains("ifmessages_rollback")) {
            availableLangPacks.remove("ifmessages_rollback");
        }
        if ((npacks = availableLangPacks.size()) == 0) {
            throw new Exception("no language pack available");
        }
        JFrame frame = new JFrame();
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 - 10);
        if (npacks != 1) {
            LanguageDialog picker = new LanguageDialog(frame, availableLangPacks.toArray());
            picker.setSelection(Locale.getDefault().getISO3Language().toLowerCase());
            picker.setModal(true);
            picker.toFront();
            frame.setVisible(false);
            picker.setVisible(true);
            selectedPack = (String)picker.getSelection();
            if (selectedPack == null) {
                throw new Exception("installation canceled");
            }
        } else {
            selectedPack = (String)availableLangPacks.get(0);
        }
        this.installdata.xmlData.setAttribute("langpack", selectedPack);
        this.installdata.localeISO3 = selectedPack;
        Debug.log("Selected Language " + selectedPack);
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + selectedPack + ".xml");
        this.installdata.langpack = new LocaleDatabase(in);
        ConsoleProgressBar.setInitialized(true);
    }

    private List getAvailableLangPacks() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/langpacks.info");
        ObjectInputStream objIn = new ObjectInputStream(in);
        List available = (List)objIn.readObject();
        objIn.close();
        return available;
    }

    protected void loadLookAndFeel() throws Exception {
        String syskey = "unix";
        if (OsVersion.IS_WINDOWS) {
            syskey = "windows";
        } else if (OsVersion.IS_OSX) {
            syskey = "mac";
        }
        String laf = null;
        if (this.installdata.guiPrefs.lookAndFeelMapping.containsKey(syskey)) {
            laf = (String)this.installdata.guiPrefs.lookAndFeelMapping.get(syskey);
        }
        boolean useButtonIcons = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useButtonIcons") && "no".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("useButtonIcons"))) {
            useButtonIcons = false;
        }
        ButtonFactory.useButtonIcons(useButtonIcons);
        boolean useLabelIcons = true;
        if (this.installdata.guiPrefs.modifier.containsKey("useLabelIcons") && "no".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("useLabelIcons"))) {
            useLabelIcons = false;
        }
        LabelFactory.setUseLabelIcons(useLabelIcons);
        if (laf == null) {
            if (!"mac".equals(syskey)) {
                if ("unix".equals(syskey)) {
                    Locale.setDefault(Locale.ENGLISH);
                }
                String syslaf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(syslaf);
                if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                    MetalLookAndFeel.setCurrentTheme(new IzPackMetalTheme());
                    ButtonFactory.useHighlightButtons();
                    ButtonFactory.useButtonIcons(useButtonIcons);
                    this.installdata.buttonsHColor = new Color(182, 182, 204);
                }
            }
            this.lnf = "swing";
            return;
        }
        if ("kunststoff".equals(laf)) {
            ButtonFactory.useHighlightButtons();
            ButtonFactory.useButtonIcons(useButtonIcons);
            this.installdata.buttonsHColor = new Color(255, 255, 255);
            Class<?> lafClass = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> mtheme = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] params = new Class[]{mtheme};
            Class<?> theme = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method setCurrentThemeMethod = lafClass.getMethod("setCurrentTheme", params);
            LookAndFeel kunststoff = (LookAndFeel)lafClass.newInstance();
            MetalTheme ktheme = (MetalTheme)theme.newInstance();
            Object[] kparams = new Object[]{ktheme};
            UIManager.setLookAndFeel(kunststoff);
            setCurrentThemeMethod.invoke((Object)kunststoff, kparams);
            this.lnf = "kunststoff";
            return;
        }
        if ("liquid".equals(laf)) {
            String value;
            UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
            this.lnf = "liquid";
            Map params = (Map)this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("decorate.frames") && "yes".equals(value = (String)params.get("decorate.frames"))) {
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
            if (params.containsKey("decorate.dialogs") && "yes".equals(value = (String)params.get("decorate.dialogs"))) {
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            return;
        }
        if ("metouia".equals(laf)) {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
            this.lnf = "metouia";
            return;
        }
        if ("nimbus".equals(laf)) {
            UIManager.setLookAndFeel("org.jdesktop.swingx.plaf.nimbus.NimbusLookAndFeel");
            return;
        }
        if ("looks".equals(laf)) {
            String param;
            TreeMap<String, String> variants = new TreeMap<String, String>();
            variants.put("windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            variants.put("plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            variants.put("plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            variants.put("plasticXP", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            String variant = (String)variants.get("plasticXP");
            Map params = (Map)this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("variant") && variants.containsKey(param = (String)params.get("variant"))) {
                variant = (String)variants.get(param);
            }
            UIManager.setLookAndFeel(variant);
            return;
        }
        if ("substance".equals(laf)) {
            String param;
            TreeMap<String, String> variants = new TreeMap<String, String>();
            variants.put("default", "org.jvnet.substance.SubstanceLookAndFeel");
            variants.put("business", "org.jvnet.substance.skin.SubstanceBusinessLookAndFeel");
            variants.put("business-blue", "org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel");
            variants.put("business-black", "org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel");
            variants.put("creme", "org.jvnet.substance.skin.SubstanceCremeLookAndFeel");
            variants.put("sahara", "org.jvnet.substance.skin.SubstanceSaharaLookAndFeel");
            variants.put("moderate", "org.jvnet.substance.skin.SubstanceModerateLookAndFeel");
            variants.put("officesilver", "org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel");
            String variant = (String)variants.get("default");
            Map params = (Map)this.installdata.guiPrefs.lookAndFeelParams.get(laf);
            if (params.containsKey("variant") && variants.containsKey(param = (String)params.get("variant"))) {
                variant = (String)variants.get(param);
            }
            UIManager.setLookAndFeel(variant);
        }
    }

    private void loadGUI() throws Exception {
        String title;
        UIManager.put("OptionPane.yesButtonText", this.installdata.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.installdata.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.installdata.langpack.getString("installer.cancel"));
        String key = "installer.reversetitle";
        String message = this.installdata.langpack.getString("installer.reversetitle");
        if (message.indexOf("installer.reversetitle") > -1) {
            boolean uninstallMode = "uninstall".equalsIgnoreCase(this.installdata.getVariable("INSTALLER_MODE"));
            String titleMsg = uninstallMode ? "uninstaller.title" : "installer.title";
            title = this.installdata.langpack.getString(titleMsg) + (uninstallMode ? "" : this.installdata.info.getAppName() + " - " + this.installdata.info.getAppVersion());
        } else {
            VariableSubstitutor vs = new VariableSubstitutor(this.installdata.getVariables());
            title = vs.substitute(message, null);
        }
        new InstallerFrame(title, this.installdata);
    }

    protected boolean useFlags() {
        return !this.installdata.guiPrefs.modifier.containsKey("useFlags") || !"no".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("useFlags"));
    }

    protected String getLangType() {
        if (this.installdata.guiPrefs.modifier.containsKey("langDisplayType")) {
            String val = (String)this.installdata.guiPrefs.modifier.get("langDisplayType");
            val = val.toLowerCase();
            for (int i = 0; i < LANGUAGE_DISPLAY_TYPES.length; ++i) {
                if (!val.equalsIgnoreCase(LANGUAGE_DISPLAY_TYPES[i])) continue;
                return val;
            }
            Debug.trace("Value for language display type not valid; value: " + val);
        }
        return LANGUAGE_DISPLAY_TYPES[0];
    }

    private static class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3832899961942782769L;
        private TreeMap icons = new TreeMap();
        private TreeMap grayIcons = new TreeMap();

        public FlagRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String iso3 = (String)value;
            this.setText(iso3);
            if (isoTable != null) {
                iso3 = (String)isoTable.get(iso3);
            }
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            if (!this.icons.containsKey(iso3)) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/res/flag." + iso3));
                this.icons.put(iso3, icon);
                icon = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
                this.grayIcons.put(iso3, icon);
            }
            if (isSelected || index == -1) {
                this.setIcon((ImageIcon)this.icons.get(iso3));
            } else {
                this.setIcon((ImageIcon)this.grayIcons.get(iso3));
            }
            return this;
        }
    }

    private final class LanguageDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 3256443616359887667L;
        private JComboBox comboBox;
        private HashMap iso3Toiso2;
        private boolean isoMapExpanded;

        public LanguageDialog(JFrame frame, Object[] items) {
            super(frame);
            this.iso3Toiso2 = null;
            this.isoMapExpanded = false;
            try {
                GUIInstaller.this.loadLookAndFeel();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            this.addWindowListener(new WindowHandler());
            JPanel contentPane = (JPanel)this.getContentPane();
            this.setTitle("Language selection");
            GridBagLayout layout = new GridBagLayout();
            contentPane.setLayout(layout);
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.anchor = 10;
            gbConstraints.insets = new Insets(5, 5, 5, 5);
            gbConstraints.fill = 2;
            gbConstraints.gridx = 0;
            gbConstraints.weightx = 1.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.ipadx = 0;
            gbConstraints.ipady = 6;
            ImageIcon img = this.getImage();
            JLabel imgLabel = new JLabel(img);
            gbConstraints.gridy = 0;
            contentPane.add(imgLabel);
            String firstMessage = "Please select your language";
            if (GUIInstaller.this.getLangType().equals(LANGUAGE_DISPLAY_TYPES[0])) {
                firstMessage = "Please select your language below";
            }
            JLabel label1 = new JLabel(firstMessage, 10);
            gbConstraints.gridy = 1;
            gbConstraints.insets = new Insets(15, 5, 5, 5);
            layout.addLayoutComponent(label1, gbConstraints);
            contentPane.add(label1);
            gbConstraints.insets = new Insets(5, 5, 5, 5);
            items = this.reviseItems(items);
            this.comboBox = new JComboBox<Object>(items);
            if (GUIInstaller.this.useFlags()) {
                this.comboBox.setRenderer(new FlagRenderer());
            }
            gbConstraints.gridy = 3;
            layout.addLayoutComponent(this.comboBox, gbConstraints);
            contentPane.add(this.comboBox);
            gbConstraints.insets = new Insets(15, 5, 15, 5);
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(this);
            gbConstraints.fill = 0;
            gbConstraints.gridy = 4;
            gbConstraints.anchor = 10;
            layout.addLayoutComponent(okButton, gbConstraints);
            contentPane.add(okButton);
            this.getRootPane().setDefaultButton(okButton);
            if (System.getProperty("mrj.version") == null) {
                this.pack();
            }
            this.setSize(this.getPreferredSize());
            Dimension frameSize = this.getSize();
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            this.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
            this.setResizable(true);
        }

        private Object[] reviseItems(Object[] items) {
            String langType = GUIInstaller.this.getLangType();
            if (langType.equals(LANGUAGE_DISPLAY_TYPES[0])) {
                return items;
            }
            if (langType.equals(LANGUAGE_DISPLAY_TYPES[1])) {
                return this.expandItems(items, new JComboBox().getFont());
            }
            if (langType.equals(LANGUAGE_DISPLAY_TYPES[2])) {
                return this.expandItems(items, null);
            }
            return items;
        }

        private Object[] expandItems(Object[] items, Font testFont) {
            int i;
            if (this.iso3Toiso2 == null) {
                this.iso3Toiso2 = new HashMap(32);
                isoTable = new HashMap();
                for (i = 0; i < LANG_CODES.length; ++i) {
                    this.iso3Toiso2.put(LANG_CODES[i][0], LANG_CODES[i][1]);
                }
            }
            for (i = 0; i < items.length; ++i) {
                Object it = this.expandItem(items[i], testFont);
                isoTable.put(it, items[i]);
                items[i] = it;
            }
            return items;
        }

        private Object expandItem(Object item, Font testFont) {
            Object iso2Str = this.iso3Toiso2.get(item);
            if (iso2Str == null && !this.isoMapExpanded) {
                this.isoMapExpanded = true;
                Locale[] loc = Locale.getAvailableLocales();
                for (int i = 0; i < loc.length; ++i) {
                    this.iso3Toiso2.put(loc[i].getISO3Language(), loc[i].getLanguage());
                }
                iso2Str = this.iso3Toiso2.get(item);
            }
            if (iso2Str == null) {
                return item;
            }
            Locale locale = new Locale((String)iso2Str);
            if (testFont == null) {
                return locale.getDisplayLanguage();
            }
            String str = locale.getDisplayLanguage(locale);
            int cdut = testFont.canDisplayUpTo(str);
            if (cdut > -1) {
                str = locale.getDisplayLanguage();
            }
            return str;
        }

        public ImageIcon getImage() {
            ImageIcon img;
            try {
                img = new ImageIcon(LanguageDialog.class.getResource("/res/installer.langsel.img"));
            }
            catch (NullPointerException err) {
                img = null;
            }
            return img;
        }

        public Object getSelection() {
            Object retval = null;
            if (isoTable != null) {
                retval = isoTable.get(this.comboBox.getSelectedItem());
            }
            return retval != null ? retval : this.comboBox.getSelectedItem();
        }

        public void setSelection(Object item) {
            Object mapped = null;
            if (isoTable != null) {
                for (Object key : isoTable.keySet()) {
                    if (!isoTable.get(key).equals(item)) continue;
                    mapped = key;
                    break;
                }
            }
            if (mapped == null) {
                mapped = item;
            }
            this.comboBox.setSelectedItem(mapped);
        }

        public void actionPerformed(ActionEvent e) {
            this.dispose();
        }

        private class WindowHandler
        extends WindowAdapter {
            private WindowHandler() {
            }

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        }
    }
}

