/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.installer.IResponseFileHandler;
import com.avaya.panther.panels.AvCAFPanelAutomationHelper;
import com.avaya.panther.util.ConsoleProgressBar;
import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.LogFileMover;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

public class AutomatedInstaller
extends InstallerBase {
    private TreeMap panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();
    private boolean result = false;
    protected RulesEngine rules;
    private static final String CONDITIONS_SPECRESOURCENAME = "conditions.xml";
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";
    private Map dynamicvariables;
    private VariableSubstitutor substitutor;

    public AutomatedInstaller() throws Exception {
        InputStream inputStream = ResourceManager.create(this.idata).getInputStream("dummy");
        this.loadInstallData(this.idata);
        this.substitutor = new VariableSubstitutor(this.idata.variables);
        AvayaInstallerBase.resolveLocale(this.idata);
        this.loadConditions();
        this.idata.setRules(this.rules);
        this.loadDynamicVariables();
        this.idata.xmlData = this.getXMLData(inputStream);
        ResourceManager.create(this.idata);
        this.addCustomLangpack(this.idata);
        this.panelInstanceCount = new TreeMap();
        this.idata.setAttribute("AutomatedInstaller_Ref", this);
        ConsoleProgressBar.setInitialized(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeUninstallData() {
        ZipOutputStream outJar;
        List files;
        UninstallData udata;
        block27: {
            udata = UninstallData.getInstance();
            files = udata.getUninstalableFilesList();
            outJar = this.idata.uninstallOutJar;
            if (outJar != null) break block27;
            boolean bl = true;
            return bl;
        }
        try {
            System.out.println("[ " + this.idata.langpack.getString("automated.uninstaller.data") + " ... ]");
            BufferedWriter logWriter = null;
            Iterator<Object> iter = null;
            for (Pack pack : this.idata.selectedPacks) {
                outJar.putNextEntry(new ZipEntry(pack.id + "-" + pack.getVersion() + ".log"));
                logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
                logWriter.write(this.idata.getInstallPath());
                logWriter.newLine();
                iter = files.iterator();
                while (iter.hasNext()) {
                    logWriter.write((String)iter.next());
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                }
                logWriter.flush();
                outJar.closeEntry();
            }
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("rollbackExecutables"));
            ObjectOutputStream execStream1 = new ObjectOutputStream(outJar);
            iter = udata.getRollbackExecutablesList().iterator();
            execStream1.writeInt(udata.getRollbackExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream1.writeObject(file);
            }
            execStream1.flush();
            outJar.closeEntry();
            Map additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = (String)keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            outJar.putNextEntry(new ZipEntry("rootscript"));
            ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
            String rootScript = udata.getRootScript();
            rootStream.writeUTF(rootScript);
            rootStream.flush();
            outJar.closeEntry();
            outJar.flush();
            outJar.close();
            for (Pack pack : this.idata.selectedPacks) {
                IoHelper.copyZipFile(this.idata.getInstallPath() + File.separator + this.idata.info.getUninstallerName(), AvayaInstallerBase.generatePackMetadataPath(pack.id, pack.getVersion(), this.idata.getInstallPath()) + File.separator + this.idata.info.getUninstallerName());
            }
            File uninstaller = new File(this.idata.getInstallPath() + File.separator + this.idata.info.getUninstallerName());
            if (uninstaller.exists()) {
                IoHelper.deleteFile(uninstaller);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception err) {
            err.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstall() throws Exception {
        if (this.idata.avayaAvailablePacks == null || this.idata.avayaAvailablePacks.size() == 0) {
            Debug.error("Validation for all the available packs has failed.");
            System.out.println(this.idata.langpack.getString("no.available.packs"));
            System.exit(1);
        }
        System.out.println("[ " + this.idata.langpack.getString("automated.starting") + this.idata.logMessages.getString("mode") + " ]");
        Debug.log("[ " + this.idata.langpack.getString("automated.starting") + this.idata.logMessages.getString("mode") + " ]");
        try {
            this.result = true;
            for (Panel p : this.idata.panelsOrder) {
                if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
                String panelClassName = p.className.substring(p.className.lastIndexOf(".") + 1);
                String prefix = "com.avaya.panther.panels.Av";
                String automationHelperClassName = prefix + panelClassName + "AutomationHelper";
                Class<?> automationHelperClass = null;
                try {
                    automationHelperClass = Class.forName(automationHelperClassName);
                }
                catch (ClassNotFoundException e) {
                    Debug.trace("ClassNotFoundException-skip :" + automationHelperClassName);
                    continue;
                }
                AvayaPanelAutomation automationHelperInstance = null;
                if (automationHelperClass != null) {
                    try {
                        Debug.trace("Instantiate :" + automationHelperClassName);
                        automationHelperInstance = (AvayaPanelAutomation)automationHelperClass.newInstance();
                    }
                    catch (Exception e) {
                        Debug.trace("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
                        continue;
                    }
                }
                String name = panelClassName;
                Vector panelRoots = this.idata.xmlData.getChildrenNamed(name);
                int panelRootNo = 0;
                if (this.panelInstanceCount.containsKey(panelClassName)) {
                    panelRootNo = (Integer)this.panelInstanceCount.get(panelClassName);
                }
                XMLElement panelRoot = (XMLElement)panelRoots.elementAt(panelRootNo);
                this.panelInstanceCount.put(panelClassName, new Integer(panelRootNo + 1));
                if (p.hasCondition() && !this.idata.getRules().isConditionTrue(p.getCondition())) {
                    if (!p.className.contains("CAFPanel")) continue;
                    AvCAFPanelAutomationHelper.setInstanceCount(AvCAFPanelAutomationHelper.getInstanceCount() + 1);
                    continue;
                }
                if (automationHelperInstance == null) continue;
                try {
                    Debug.trace("automationHelperInstance.runAutomated :" + automationHelperClassName + " entered.");
                    if (!automationHelperInstance.runAutomated(this.idata, panelRoot)) {
                        this.result = false;
                    } else {
                        if (!automationHelperInstance.isValidated(this.idata)) {
                            Debug.error(" Validation failed for:  " + panelClassName);
                            Housekeeper.getInstance().shutDown(2);
                        }
                        if (!automationHelperInstance.isPanelValidated(this.idata, p)) {
                            Debug.error(" Post Panel  Validation failed for:  " + panelClassName);
                            Housekeeper.getInstance().shutDown(2);
                        }
                        Debug.trace("automationHelperInstance.runAutomated :" + automationHelperClassName + " successfully done.");
                    }
                    this.refreshDynamicVariables();
                }
                catch (Exception e) {
                    Debug.error(this.idata.logMessages.getString("automated.failed") + " for panel " + panelClassName);
                    e.printStackTrace();
                    this.result = false;
                }
                if ("error".equals(AvayaInstaller.panther.getInstallStatus())) {
                    if (AvayaInstaller.panther.rollBackOnFaliure) {
                        Debug.error(this.idata.logMessages.getString("error"));
                        this.exit();
                    } else if (!AvayaInstaller.panther.rollBackOnFaliure) {
                        System.out.println("[ " + this.idata.logMessages.getString("automated.failed") + "! ]");
                        Debug.error(this.idata.logMessages.getString("automated.failed"));
                        Debug.error("-r (Roll back on faliure) option was set to false.Installation ended without any cleanup");
                        System.exit(1);
                    }
                }
                if (!AvayaInstaller.panther.getInstallStage().equals("preinstall") || !"error".equals(AvayaInstaller.panther.getPreInstallStatus())) continue;
                if (AvayaInstaller.panther.prerequisiteIgnorer.equals("abort")) {
                    Debug.error("Aborting Installation as pre-requisite check failed");
                    AvayaInstaller.panther.setInstallStatus("error");
                    Housekeeper.getInstance().setAutomatedInstallData(this.idata);
                    Housekeeper.getInstance().shutDown(2);
                    continue;
                }
                if (!AvayaInstaller.panther.prerequisiteIgnorer.equals("ignore")) continue;
                AvayaInstaller.panther.setInstallStatus("warning");
                ++AvayaInstallData.install_warnings_count;
                Debug.log("Pre-reqisite check failed.User chose to ignore this faliure");
                Debug.log("Installation may fail");
                AvayaInstaller.panther.setPreInstallStatus("success");
            }
            this.writeUninstallData();
            IResponseFileHandler responseFileHandler = this.idata.getResourceFactory().getResponseFileHandler(this.idata);
            if (this.idata.getInstallPath() != null) {
                responseFileHandler.writeOutputResponseFile(this.idata);
                responseFileHandler.compareInputOutputResponseFile();
            }
            if ("warning".equals(AvayaInstaller.panther.getInstallStatus())) {
                System.out.println("[" + this.idata.logMessages.getString("automated") + " Completed with Warnings!]");
                Debug.log("[" + this.idata.logMessages.getString("automated") + " Completed with Warnings!]");
                LogFileMover.moveLogFile();
                System.exit(1);
            } else {
                System.out.println("[" + this.idata.logMessages.getString("automated") + " Completed !]");
                Debug.log("[" + this.idata.logMessages.getString("automated") + " Completed !]");
                LogFileMover.moveLogFile();
                System.exit(0);
            }
            Housekeeper.getInstance().setAutomatedInstallData(this.idata);
        }
        catch (Exception e) {
            try {
                this.result = false;
                System.err.println(e.toString());
                e.printStackTrace();
                AvayaInstaller.panther.setInstallStatus("error");
                System.out.println("[ " + this.idata.logMessages.getString("automated.failed") + " ]");
                Housekeeper.getInstance().setAutomatedInstallData(this.idata);
            }
            catch (Throwable throwable) {
                Housekeeper.getInstance().setAutomatedInstallData(this.idata);
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
            Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    public XMLElement getXMLData(InputStream in) throws Exception {
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setReader(new StdXMLReader(in));
        parser.setValidator(new NonValidator());
        XMLElement rtn = (XMLElement)parser.parse();
        in.close();
        return rtn;
    }

    public boolean getResult() {
        return this.result;
    }

    public void exit() {
        if (this.idata.canClose) {
            this.writeUninstallData();
            Housekeeper.getInstance().setAutomatedInstallData(this.idata);
            Housekeeper.getInstance().shutDown(2);
        } else {
            this.wipeAborted();
            Housekeeper.getInstance().setAutomatedInstallData(this.idata);
            Housekeeper.getInstance().shutDown(2);
        }
    }

    protected void wipeAborted() {
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
    }

    private void cleanWipe(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                this.cleanWipe(files[i]);
            }
        }
        file.delete();
    }

    public void refreshDynamicVariables() {
        if (this.dynamicvariables != null) {
            for (String dynvarname : this.dynamicvariables.keySet()) {
                List dynvarList = (List)this.dynamicvariables.get(dynvarname);
                for (DynamicVariable dynvar : dynvarList) {
                    boolean refresh = false;
                    if (dynvar.getConditionid() != null) {
                        if (this.rules != null && this.rules.isConditionTrue(dynvar.getConditionid())) {
                            refresh = true;
                        }
                    } else {
                        refresh = true;
                    }
                    if (!refresh) continue;
                    String newvalue = this.substitutor.substitute(dynvar.getValue(), null);
                    this.idata.variables.setProperty(dynvar.getName(), newvalue);
                }
            }
        }
    }

    private void loadDynamicVariables() {
        try {
            InputStream in = InstallerFrame.class.getResourceAsStream("/dynvariables");
            ObjectInputStream objIn = new ObjectInputStream(in);
            this.dynamicvariables = (Map)objIn.readObject();
            objIn.close();
        }
        catch (Exception e) {
            Debug.trace("Can not find optional dynamic variables");
            System.out.println(e);
        }
    }

    protected void loadConditions() {
        try {
            InputStream in = InstallerFrame.class.getResourceAsStream("/rules");
            ObjectInputStream objIn = new ObjectInputStream(in);
            Map rules = (Map)objIn.readObject();
            if (rules != null && rules.size() != 0) {
                this.rules = new RulesEngine(rules, this.idata);
            }
            objIn.close();
        }
        catch (Exception e) {
            Debug.trace("Can not find optional rules");
        }
        if (this.rules != null) {
            return;
        }
        try {
            InputStream input = null;
            input = this.getResource(CONDITIONS_SPECRESOURCENAME);
            if (input == null) {
                this.rules = new RulesEngine((XMLElement)null, this.idata);
                return;
            }
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
            parser.setValidator(new NonValidator());
            parser.setReader(new StdXMLReader(input));
            XMLElement conditionsxml = (XMLElement)parser.parse();
            this.rules = new RulesEngine(conditionsxml, this.idata);
        }
        catch (Exception e) {
            Debug.trace("Can not find optional resource conditions.xml");
            this.rules = new RulesEngine((XMLElement)null, this.idata);
        }
    }

    public InputStream getResource(String res) throws Exception {
        String basePath = "";
        ResourceManager rm = null;
        try {
            rm = ResourceManager.getInstance();
            rm.getClass();
            basePath = "/res/";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream result = this.getClass().getResourceAsStream(basePath + res);
        if (result == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + res);
        }
        return result;
    }
}

