/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.HighlightJButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class ButtonFactory {
    private static boolean useHighlightButtons = false;
    private static boolean useButtonIcons = false;

    public static void useButtonIcons() {
        ButtonFactory.useButtonIcons(true);
    }

    public static void useButtonIcons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useButtonIcons = useit;
        }
    }

    public static void useHighlightButtons() {
        ButtonFactory.useHighlightButtons(true);
    }

    public static void useHighlightButtons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useHighlightButtons = useit;
        }
        ButtonFactory.useButtonIcons(useit);
    }

    public static JButton createButton(Icon icon, Color color) {
        if (useHighlightButtons) {
            if (useButtonIcons) {
                return new HighlightJButton(icon, color);
            }
            return new HighlightJButton("", color);
        }
        if (useButtonIcons) {
            JButton button = new JButton(icon);
            button.setBorder(new RoundedBorder());
            button.setSize(3, 20);
            return button;
        }
        JButton button = new JButton();
        button.setBorder(new RoundedBorder());
        button.setSize(3, 20);
        return button;
    }

    public static JButton createButton(String text, Color color) {
        if (useHighlightButtons) {
            return new HighlightJButton(text, color);
        }
        JButton button = new JButton(text);
        button.setBorder(new RoundedBorder());
        button.setSize(3, 20);
        return button;
    }

    public static JButton createButton(String text, Icon icon, Color color) {
        if (useHighlightButtons) {
            if (useButtonIcons) {
                return new HighlightJButton(text, icon, color);
            }
            return new HighlightJButton(text, color);
        }
        if (useButtonIcons) {
            JButton button = new JButton(text, icon);
            button.setBorder(new RoundedBorder());
            button.setSize(3, 20);
            return button;
        }
        JButton button = new JButton(text);
        button.setBorder(new RoundedBorder());
        button.setSize(3, 20);
        return button;
    }

    public static JButton createButton(Action a, Color color) {
        if (useHighlightButtons) {
            return new HighlightJButton(a, color);
        }
        JButton button = new JButton(a);
        button.setBorder(new RoundedBorder());
        button.setSize(3, 20);
        return button;
    }

    static class RoundedBorder
    implements Border {
        protected int m_w = 20;
        protected int m_h = 3;
        protected Color m_topColor = Color.black;
        protected Color m_bottomColor = Color.black;

        public Insets getBorderInsets(Component c) {
            return new Insets(this.m_h, this.m_w, this.m_h, this.m_w);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(this.m_topColor);
            g.drawLine(++x, ++y + 2, x, y + (h -= 3) - 2);
            g.drawLine(x + 2, y, x + (w -= 3) - 2, y);
            g.drawLine(x, y + 2, x + 2, y);
            g.drawLine(x, y + h - 2, x + 2, y + h);
            g.setColor(this.m_bottomColor);
            g.drawLine(x + w, y + 2, x + w, y + h - 2);
            g.drawLine(x + 2, y + h, x + w - 2, y + h);
            g.drawLine(x + w - 2, y, x + w, y + 2);
            g.drawLine(x + w, y + h - 2, x + w - 2, y + h);
        }
    }
}

