/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.SummaryProcessor;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SummaryLoggerInstallerListener
extends SimpleInstallerListener {
    public SummaryLoggerInstallerListener() {
        super(false);
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (!this.getInstalldata().installSuccess) {
            return;
        }
        if (this.getInstalldata().panels == null || this.getInstalldata().panels.size() < 1) {
            return;
        }
        String path = this.getInstalldata().info.getSummaryLogFilePath();
        if (path == null) {
            return;
        }
        VariableSubstitutor vs = new VariableSubstitutor(this.getInstalldata().getVariables());
        File parent = new File(path = IoHelper.translatePath(path, vs)).getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String summary = SummaryProcessor.getSummary(this.getInstalldata());
        FileOutputStream out = new FileOutputStream(path);
        ((OutputStream)out).write(summary.getBytes("utf-8"));
        ((OutputStream)out).close();
    }
}

