/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.event.NativeInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class LinuxEnvInstallerListener
extends NativeInstallerListener {
    private static final String SPEC_FILE_NAME = "LinuxEnvSpec.xml";

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        this.setSpecHelper(new SpecHelper());
        this.getSpecHelper().readSpec(SPEC_FILE_NAME);
        XMLElement data = this.getSpecHelper().getSpec();
        Vector specElements = null;
        if (data.hasChildren()) {
            specElements = data.getChildrenNamed("env_variable");
            for (int i = 0; i < specElements.size(); ++i) {
                String cmd = null;
                data = (XMLElement)specElements.elementAt(i);
                String variable = data.getAttribute("name");
                String value = data.getAttribute("value");
                String substitute = data.getAttribute("substitute");
                value = vs.substitute(value, "plain");
                if (substitute == null) {
                    substitute = "ignore";
                }
                if ("ignore".equals(substitute)) {
                    cmd = System.getenv(variable) == null ? "echo export " + variable + "=" + value + " >> $HOME/.profile" : "";
                } else if ("append".equals(substitute)) {
                    cmd = "echo export " + variable + "=" + "$" + variable + ":" + value + " >> $HOME/.profile";
                } else if (substitute.equals("overwrite")) {
                    cmd = "echo export " + variable + "=" + value + " >> $HOME/.profile";
                }
                if (cmd == "") continue;
                String[] cmdArray = new String[]{"/bin/sh", "-c", cmd};
                Process process = Runtime.getRuntime().exec(cmdArray);
                process.waitFor();
                int exitValue = process.exitValue();
            }
        }
    }
}

