/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.Pack;
import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ExtendedUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class AntActionInstallerListener
extends SimpleInstallerListener {
    public static final String SPEC_FILE_NAME = "AntActionsSpec.xml";
    private HashMap actions = new HashMap();
    private ArrayList uninstActions = new ArrayList();

    public AntActionInstallerListener() {
        super(true);
    }

    public HashMap getActions() {
        return this.actions;
    }

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME, new VariableSubstitutor(idata.getVariables()));
        if (this.getSpecHelper().getSpec() == null) {
            return;
        }
        Iterator iter = idata.selectedPacks.iterator();
        Pack p = null;
        while (iter != null && iter.hasNext()) {
            p = (Pack)iter.next();
            XMLElement pack = this.getSpecHelper().getPackForName(p.name);
            if (pack == null) continue;
            HashMap packActions = new HashMap();
            packActions.put("beforepack", new ArrayList());
            packActions.put("afterpack", new ArrayList());
            packActions.put("beforepacks", new ArrayList());
            packActions.put("afterpacks", new ArrayList());
            Vector antCallEntries = pack.getChildrenNamed("antcall");
            if (antCallEntries != null && antCallEntries.size() >= 1) {
                Iterator entriesIter = antCallEntries.iterator();
                while (entriesIter != null && entriesIter.hasNext()) {
                    AntAction act = this.readAntCall((XMLElement)entriesIter.next());
                    if (act == null) continue;
                    ((ArrayList)packActions.get(act.getOrder())).add(act);
                }
                if (((ArrayList)packActions.get("afterpacks")).size() > 0) {
                    this.setProgressBarCaller();
                }
            }
            this.actions.put(p.name, packActions);
        }
        iter = idata.availablePacks.iterator();
        while (iter.hasNext()) {
            String currentPack = ((Pack)iter.next()).name;
            this.performAllActions(currentPack, "beforepacks", null);
        }
    }

    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.name, "beforepack", handler);
    }

    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.name, "afterpack", handler);
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (this.informProgressBar()) {
            handler.nextStep(this.getMsg("AntAction.pack"), this.getProgressBarCallerId(), this.getActionCount(idata, "afterpacks"));
        }
        Iterator iter = idata.selectedPacks.iterator();
        while (iter.hasNext()) {
            String currentPack = ((Pack)iter.next()).name;
            this.performAllActions(currentPack, "afterpacks", handler);
        }
        if (this.uninstActions.size() > 0) {
            UninstallData.getInstance().addAdditionalData("antActions", this.uninstActions);
        }
    }

    private int getActionCount(AutomatedInstallData idata, String order) {
        int retval = 0;
        Iterator iter = idata.selectedPacks.iterator();
        while (iter.hasNext()) {
            String currentPack = ((Pack)iter.next()).name;
            ArrayList actList = this.getActions(currentPack, order);
            if (actList == null) continue;
            retval += actList.size();
        }
        return retval;
    }

    protected ArrayList getActions(String packName, String order) {
        if (this.actions == null) {
            return null;
        }
        HashMap packActions = (HashMap)this.actions.get(packName);
        if (packActions == null || packActions.size() == 0) {
            return null;
        }
        return (ArrayList)packActions.get(order);
    }

    private void performAllActions(String packName, String order, AbstractUIProgressHandler handler) throws InstallerException {
        ArrayList actList = this.getActions(packName, order);
        if (actList == null || actList.size() == 0) {
            return;
        }
        Debug.trace("******* Executing all " + order + " actions of " + packName + " ...");
        for (int i = 0; i < actList.size(); ++i) {
            AntAction act = (AntAction)actList.get(i);
            if (this.informProgressBar() && handler != null && handler instanceof ExtendedUIProgressHandler && order.equals("afterpacks")) {
                ((ExtendedUIProgressHandler)((Object)handler)).progress(act.getMessageID() != null ? this.getMsg(act.getMessageID()) : "");
            }
            try {
                act.performInstallAction();
            }
            catch (Exception e) {
                throw new InstallerException(e);
            }
            if (act.getUninstallTargets().size() <= 0) continue;
            this.uninstActions.add(act);
        }
    }

    private AntAction readAntCall(XMLElement el) throws InstallerException {
        String msgId;
        if (el == null) {
            return null;
        }
        SpecHelper spec = this.getSpecHelper();
        AntAction act = new AntAction();
        try {
            act.setOrder(spec.getRequiredAttribute(el, "order"));
            act.setUninstallOrder(el.getAttribute("uninstall_order", "beforedeletion"));
        }
        catch (Exception e) {
            throw new InstallerException(e);
        }
        act.setQuiet(spec.isAttributeYes(el, "quiet", false));
        act.setVerbose(spec.isAttributeYes(el, "verbose", false));
        act.setBuildFile(spec.getRequiredAttribute(el, "buildfile"));
        String str = el.getAttribute("logfile");
        if (str != null) {
            act.setLogFile(str);
        }
        if ((msgId = el.getAttribute("messageid")) != null && msgId.length() > 0) {
            act.setMessageID(msgId);
        }
        for (XMLElement propEl : el.getChildrenNamed("propertyfile")) {
            act.addPropertyFile(spec.getRequiredAttribute(propEl, "path"));
        }
        for (XMLElement propEl : el.getChildrenNamed("property")) {
            act.setProperty(spec.getRequiredAttribute(propEl, "name"), spec.getRequiredAttribute(propEl, "value"));
        }
        for (XMLElement targEl : el.getChildrenNamed("target")) {
            act.addTarget(spec.getRequiredAttribute(targEl, "name"));
        }
        for (XMLElement utargEl : el.getChildrenNamed("uninstall_target")) {
            act.addUninstallTarget(spec.getRequiredAttribute(utargEl, "name"));
        }
        return act;
    }
}

