/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.event.ActionBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.util.JavaEnvUtils;

public class AntAction
extends ActionBase {
    private static final long serialVersionUID = 3258131345250005557L;
    public static final String ANTACTIONS = "antactions";
    public static final String ANTACTION = "antaction";
    public static final String ANTCALL = "antcall";
    private boolean quiet = false;
    private boolean verbose = false;
    private Properties properties = new Properties();
    private List targets = new ArrayList();
    private List uninstallTargets = new ArrayList();
    private String logFile = null;
    private String buildFile = null;
    private List propertyFiles = new ArrayList();

    public void performInstallAction() throws Exception {
        this.performAction(false);
    }

    public void performUninstallAction() throws Exception {
        this.performAction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(boolean uninstall) throws Exception {
        if (this.verbose) {
            System.out.println("Calling ANT with buildfile: " + this.buildFile);
        }
        SecurityManager oldsm = null;
        if (!JavaEnvUtils.isJavaVersion((String)"1.0") && !JavaEnvUtils.isJavaVersion((String)"1.1")) {
            oldsm = System.getSecurityManager();
        }
        PrintStream err = System.err;
        PrintStream out = System.out;
        try {
            int i;
            List choosenTargets;
            Project antProj = new Project();
            antProj.setName("antcallproject");
            antProj.addBuildListener((BuildListener)this.createLogger());
            antProj.setInputHandler((InputHandler)new DefaultInputHandler());
            antProj.setSystemProperties();
            this.addProperties(antProj, this.getProperties());
            this.addPropertiesFromPropertyFiles(antProj);
            antProj.fireBuildStarted();
            antProj.init();
            ArrayList<Ant> antcalls = new ArrayList<Ant>();
            List list = choosenTargets = uninstall ? this.uninstallTargets : this.targets;
            if (choosenTargets.size() > 0) {
                Ant antcall = null;
                for (i = 0; i < choosenTargets.size(); ++i) {
                    antcall = (Ant)antProj.createTask("ant");
                    antcall.setAntfile(this.getBuildFile());
                    antcall.setTarget((String)choosenTargets.get(i));
                    antcalls.add(antcall);
                }
            }
            Target target = new Target();
            target.setName("calltarget");
            for (i = 0; i < antcalls.size(); ++i) {
                target.addTask((Task)((Ant)antcalls.get(i)));
            }
            antProj.addTarget(target);
            System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(antProj, false)));
            System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(antProj, true)));
            antProj.executeTarget("calltarget");
        }
        finally {
            if (oldsm != null) {
                System.setSecurityManager(oldsm);
            }
            System.setOut(out);
            System.setErr(err);
        }
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public List getPropertyFiles() {
        return this.propertyFiles;
    }

    public void addPropertyFile(String propertyFile) {
        this.propertyFiles.add(propertyFile);
    }

    public void setPropertyFiles(List propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public List getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList targets) {
        this.targets = targets;
    }

    public void addTarget(String target) {
        this.targets.add(target);
    }

    public List getUninstallTargets() {
        return this.uninstallTargets;
    }

    public void setUninstallTargets(ArrayList targets) {
        this.uninstallTargets = targets;
    }

    public void addUninstallTarget(String target) {
        this.uninstallTargets.add(target);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private BuildLogger createLogger() {
        int msgOutputLevel = 2;
        if (this.verbose) {
            msgOutputLevel = 4;
        } else if (this.quiet) {
            msgOutputLevel = 1;
        }
        DefaultLogger logger = new DefaultLogger();
        logger.setMessageOutputLevel(msgOutputLevel);
        if (this.logFile != null) {
            try {
                PrintStream printStream = new PrintStream(new FileOutputStream(this.logFile));
                logger.setOutputPrintStream(printStream);
                logger.setErrorPrintStream(printStream);
            }
            catch (FileNotFoundException e) {
                logger.setOutputPrintStream(System.out);
                logger.setErrorPrintStream(System.err);
            }
        } else {
            logger.setOutputPrintStream(System.out);
            logger.setErrorPrintStream(System.err);
        }
        return logger;
    }

    private void addProperties(Project proj, Properties props) {
        if (proj == null) {
            return;
        }
        if (props.size() > 0) {
            Iterator<Object> iter = props.keySet().iterator();
            String key = null;
            while (iter.hasNext()) {
                key = (String)iter.next();
                proj.setProperty(key, props.getProperty(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertiesFromPropertyFiles(Project proj) throws Exception {
        if (proj == null) {
            return;
        }
        Properties props = new Properties();
        File pf = null;
        FileInputStream fis = null;
        try {
            for (int i = 0; i < this.propertyFiles.size(); ++i) {
                pf = new File((String)this.propertyFiles.get(i));
                if (!pf.exists()) {
                    throw new Exception("Required propertyfile " + pf + " for antcall doesn't exist.");
                }
                fis = new FileInputStream(pf);
                props.load(fis);
                fis.close();
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        this.addProperties(proj, props);
    }
}

