/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.io.File;

public class WASFieldValidator
implements Validator {
    public boolean validate(ProcessingClient client) {
        boolean isDataAvailable = true;
        AutomatedInstallData installData = AutomatedInstallData.getInstance();
        String jbossPath = client.getText();
        String jbossServerName = "avmgmt";
        try {
            if (!this.validateJBossPath(jbossPath)) {
                installData.setVariable("JBOSSFieldValidationError", installData.langpack.getString("JbossDir.component.txt"));
                isDataAvailable = false;
            } else if (!this.validateJBossServerName(jbossPath, jbossServerName)) {
                installData.setVariable("JBOSSFieldValidationError", installData.langpack.getString("JbossServerName.component.txt"));
                isDataAvailable = false;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return isDataAvailable;
    }

    public boolean validateJBossPath(String path) {
        boolean valid = false;
        File file = null;
        try {
            String inputPath = path;
            if (inputPath != null && !"null".equalsIgnoreCase(inputPath) && inputPath.trim().length() > 0) {
                if (!inputPath.endsWith("\\") || !inputPath.endsWith("/")) {
                    inputPath = inputPath + File.separator;
                }
                String fileName = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? "run.bat" : "run.sh";
                file = new File(inputPath + File.separator + "bin" + File.separator + fileName);
                if (file != null && file.exists()) {
                    valid = true;
                }
            }
        }
        catch (Exception ex) {
            valid = false;
        }
        return valid;
    }

    public boolean validateJBossServerName(String path, String serverName) {
        boolean valid = false;
        File file = null;
        try {
            String inputPath = path + File.separator + "server" + File.separator + (serverName != null ? serverName.toLowerCase() : "");
            if (inputPath != null && !"null".equalsIgnoreCase(inputPath) && inputPath.trim().length() > 0 && (file = new File(inputPath)) != null && file.isDirectory()) {
                valid = true;
            }
        }
        catch (Exception ex) {
            valid = false;
        }
        return valid;
    }
}

