/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.avaya.panther.panels.SimpleProcessingClient;
import com.izforge.izpack.installer.AutomatedInstallData;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class ValidatorUtil {
    private static final String executablePath = "." + File.separator + "utils" + File.separator;

    public static boolean validateIPAddress(String ipAddress) {
        try {
            return InetAddress.getByName(ipAddress) != null;
        }
        catch (NumberFormatException ex) {
            return false;
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    public static boolean validatePort(String hostName, String portNumber) {
        boolean isValid = false;
        InetAddress inetAddress = null;
        ServerSocket serverSocket = null;
        try {
            inetAddress = InetAddress.getByName(hostName.trim());
            serverSocket = new ServerSocket(new Integer(portNumber), 0, inetAddress);
            isValid = serverSocket.isBound();
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
        catch (Exception ex) {
            isValid = false;
        }
        return isValid;
    }

    public static String getWASHostName(String wasPath, String wasNodeName, String wasUserName, String wasPassword) {
        Process process = null;
        Runtime runtime = null;
        InputStream inputStream = null;
        String batchFilePath = null;
        String pythonPath = null;
        StringBuffer hostName = new StringBuffer();
        String[] hostNameArray = null;
        int ch = 0;
        if (!wasPath.endsWith("\\") || !wasPath.endsWith("/")) {
            wasPath = wasPath + File.separator;
        }
        String fileName = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? "getWASHost.bat" : "getWASHost.sh";
        File batchFile = new File(executablePath + fileName);
        File pythonFile = new File(executablePath + "serverHostIP.py");
        if (batchFile.exists()) {
            batchFilePath = batchFile.getAbsolutePath();
        }
        if (pythonFile.exists()) {
            pythonPath = pythonFile.getAbsolutePath();
        }
        try {
            runtime = Runtime.getRuntime();
            File file = new File(wasPath);
            String[] cmd = batchFilePath.endsWith("sh") ? new String[]{"sh", batchFilePath, wasPath, wasUserName, wasPassword, pythonPath, wasNodeName} : new String[]{wasPath, wasUserName, wasPassword, pythonPath, wasNodeName};
            process = runtime.exec(cmd, null, file);
            inputStream = process.getInputStream();
            while ((ch = inputStream.read()) != -1) {
                hostName.append((char)ch);
            }
            inputStream.close();
            process.destroy();
            if (hostName.length() > 0) {
                hostNameArray = hostName.toString().split("\\n");
            }
        }
        catch (Exception ex) {
            return null;
        }
        if (hostNameArray != null && hostNameArray.length > 0) {
            return hostNameArray[hostNameArray.length - 1];
        }
        return null;
    }

    public boolean validateAddress(String address) {
        if (address == null || address.length() <= 0) {
            return false;
        }
        boolean isValidIpFormat = this.validateIPAddressFormat(address.trim());
        String hostName = address.trim();
        try {
            if (isValidIpFormat) {
                if (!ValidatorUtil.validateIPAddress(hostName)) {
                    SimpleProcessingClient.setErrorMsg(AutomatedInstallData.getInstance().langpack.getString("database.invalid.error"));
                }
                return ValidatorUtil.validateIPAddress(hostName);
            }
            SimpleProcessingClient.setErrorMsg(AutomatedInstallData.getInstance().langpack.getString("database.ipformat.error"));
            if (hostName != null && !"null".equalsIgnoreCase(hostName) && hostName.trim().length() > 0) {
                if (InetAddress.getByName(hostName) == null) {
                    SimpleProcessingClient.setErrorMsg(AutomatedInstallData.getInstance().langpack.getString("database.notreachable.error"));
                }
                return InetAddress.getByName(hostName) != null;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean validateIPAddressFormat(String ipAddress) {
        String[] ipArray = ipAddress.split("\\p{Punct}");
        if (ipArray.length != 4) {
            return false;
        }
        boolean isIPAddress = true;
        try {
            for (int i = 0; i < 4; ++i) {
                int value = Integer.parseInt(ipArray[i]);
                if (value >= 0 && value <= 255) continue;
                isIPAddress = false;
            }
        }
        catch (Throwable ex) {
            isIPAddress = false;
        }
        return isIPAddress;
    }

    public boolean validatePortFormat(String portNumber) {
        int port = 0;
        if (portNumber == null || portNumber.length() <= 0) {
            return false;
        }
        try {
            port = Integer.parseInt(portNumber);
            if (port > 0 && port < 65535) {
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public boolean validateOSPortFormat(String portNumber) {
        int port = 0;
        if (portNumber == null || portNumber.length() <= 0) {
            return false;
        }
        try {
            port = Integer.parseInt(portNumber);
            if (port > 0 && port < 1023) {
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean notEmptyValidator(String dataToValidate) {
        return dataToValidate != null && dataToValidate.length() > 0;
    }

    public boolean validateClientPort(String hostName, int portNumber) {
        try {
            Socket socket = new Socket(InetAddress.getByName(hostName.trim()), portNumber);
            socket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

