/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLFileParser {
    private static final int DB_CONNECT_ERROR = 1;
    private static final int FILE_NOT_FOUND_ERROR = 2;
    private static final int SQL_EXECUTION_ERROR = 3;
    private static boolean USE_DEFAULT_TOKEN_DELIMITER = true;
    private static String DEFAULT_TOKEN_DELIMITER = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? "\r\n;" : "\n;";
    private static String NEW_LINE = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? "\r\n" : "\n";
    private static final String TOKEN_REGEX_PATTERN = "[ \r\n\t/]*$";
    private Connection mConnection;
    private Statement mStatement;

    private void usage() {
        System.out.println("Usage:" + NEW_LINE + "required command line arguments:" + NEW_LINE + "1. Database Connection URL" + NEW_LINE + "2. Database User Name" + NEW_LINE + "3. Database Password" + NEW_LINE + "4. Database Driver" + NEW_LINE + "5. Absolute path of the SQL file to execute" + NEW_LINE + "optional command line arguments:" + NEW_LINE + "6. Token Delimiter");
    }

    private void getDBConnection(String jdbcDriver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        Class.forName(jdbcDriver);
        this.mConnection = DriverManager.getConnection(url, username, password);
        this.mStatement = this.mConnection.createStatement();
    }

    private void executeQuery(String sql) throws SQLException {
        if (this.mStatement != null && sql != null) {
            this.mStatement.execute(sql);
        }
    }

    private void closeDBConnection() throws SQLException {
        if (this.mStatement != null) {
            this.mStatement.close();
        }
        if (this.mConnection != null) {
            this.mConnection.close();
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length >= 5) {
            new SQLFileParser().parseSQLFile(args);
        } else {
            System.out.println("ERROR : Insufficient number of arguments.....");
            new SQLFileParser().usage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseSQLFile(String[] args) {
        File file = null;
        String sql = null;
        try {
            file = new File(args[4]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        try {
            this.getDBConnection(args[3], args[0], args[1], args[2]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        try {
            USE_DEFAULT_TOKEN_DELIMITER = DEFAULT_TOKEN_DELIMITER.equals(args[5]);
        }
        catch (Exception ex) {
            USE_DEFAULT_TOKEN_DELIMITER = true;
        }
        Scanner scanner = null;
        try {
            try {
                scanner = new Scanner(file);
            }
            catch (FileNotFoundException fnfEx) {
                fnfEx.printStackTrace();
                System.exit(2);
            }
            if (USE_DEFAULT_TOKEN_DELIMITER) {
                scanner.useDelimiter(Pattern.compile(DEFAULT_TOKEN_DELIMITER + TOKEN_REGEX_PATTERN, 8));
            } else {
                scanner.useDelimiter(Pattern.compile(args[5] + TOKEN_REGEX_PATTERN, 8));
                System.out.println("INFO: Using " + args[5] + " as the token delimiter");
            }
            while (scanner.hasNext()) {
                sql = scanner.next();
                if (USE_DEFAULT_TOKEN_DELIMITER) {
                    String string = sql = sql != null ? sql.trim().replaceAll(NEW_LINE, " ") : null;
                }
                if (sql == null || "".equals(sql)) continue;
                try {
                    this.executeQuery(sql.trim());
                }
                catch (SQLException sqlEx) {
                    Pattern pattern = Pattern.compile("[dD][rR][oO][pP]");
                    Matcher matcher = pattern.matcher(sql);
                    if (!matcher.matches()) continue;
                    sqlEx.printStackTrace();
                    System.exit(3);
                }
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            try {
                this.closeDBConnection();
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                System.exit(1);
            }
        }
    }
}

