/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.avaya.panther.util.IExecutableClass;
import com.avaya.panther.util.SPIRITBaseConfig;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SPIRITDefaultProductInventory
implements IExecutableClass {
    public int execute(String[] args) {
        return this.updateBaseConfig(args);
    }

    public int updateBaseConfig(String ... args) {
        String productID = null;
        String productName = null;
        String productIP = null;
        AutomatedInstallData idata = InstallData.getInstance();
        String filePath = idata.getVariable("SPIRIT_AGENT_CONFIG_INVENTORY") + File.separator + "default_product_inventory.xml";
        Document doc = SPIRITBaseConfig.readXMLDoc(filePath);
        Object node = null;
        if (doc == null) {
            return 1;
        }
        try {
            for (String parameter : args) {
                String type = parameter.substring(0, parameter.indexOf(":"));
                parameter = parameter.substring(parameter.indexOf(":") + 1, parameter.length());
                if ("-pID".equalsIgnoreCase(type)) {
                    if (parameter.length() <= 0) continue;
                    productID = parameter;
                    continue;
                }
                if ("-pName".equalsIgnoreCase(type)) {
                    if (parameter.length() <= 0) continue;
                    productName = parameter;
                    continue;
                }
                if (!"-pIP".equalsIgnoreCase(type) || parameter.length() <= 0) continue;
                productIP = parameter;
            }
            if (productID != null && productIP != null && productName != null) {
                SPIRITDefaultProductInventory.addElement(doc, productName, productID, productIP);
                if (SPIRITBaseConfig.writeXMLDoc(null, doc, filePath)) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static void addElement(Document doc, String productName, String productID, String IPAddress) {
        NodeList nodeList = doc.getElementsByTagName("product_inventory");
        Node parentNode = nodeList.item(0);
        Element tmp_product_element_Node = doc.createElement("product_element");
        Element tmp_productname_Node = doc.createElement("productname");
        tmp_productname_Node.setTextContent(productName);
        Element tmp_productid_Node = doc.createElement("productid");
        tmp_productid_Node.setTextContent(productID);
        Element tmp_ipAddress_Node = doc.createElement("ipAddress");
        tmp_ipAddress_Node.setTextContent(IPAddress);
        tmp_product_element_Node.appendChild(tmp_productname_Node);
        tmp_product_element_Node.appendChild(tmp_productid_Node);
        tmp_product_element_Node.appendChild(tmp_ipAddress_Node);
        parentNode.appendChild(tmp_product_element_Node);
    }
}

