/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.IAvayaPostPanelAction;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.Installer;
import com.izforge.izpack.util.Debug;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SPIRITDatabasePostPanelAction
implements IAvayaPostPanelAction {
    private Connection mConnection;

    public boolean performPostPanelAction(AutomatedInstallData installData) {
        if (installData.getVariable("Database1").equals("Postgres")) {
            return this.postgresCheck(installData);
        }
        if (installData.getVariable("Database1").startsWith("Oracle")) {
            return this.oracleCheck(installData);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postgresCheck(AutomatedInstallData installData) {
        block18: {
            String errMsg = installData.langpack.getString("spirit.database.invalid.conn.details");
            String driver = "org.postgresql.Driver";
            String url = "jdbc:postgresql://" + installData.getVariable("DatabaseHost") + ":" + installData.getVariable("DatabaseHostPort") + "/" + installData.getVariable("DatabaseName");
            try {
                this.getDBConnection(driver, url, installData.getVariable("SPIRITDatabaseUsername"), installData.getVariable("SPIRITDatabasePassword"));
                Debug.log("Oracle SPIRIT Database Connection : Pass");
                errMsg = installData.langpack.getString("spirit.admin.database.invalid.conn.details");
                this.getDBConnection(driver, url, installData.getVariable("SPIRITAdminDatabaseUsername"), installData.getVariable("SPIRITAdminDatabasePassword"));
                Debug.log("Oracle SPIRIT Admin Database Connection : Pass");
            }
            catch (SQLException e) {
                Debug.error(errMsg);
                if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                    System.err.println(errMsg);
                    System.exit(-1);
                    break block18;
                }
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, errMsg, installData.langpack.getString("title.db.conn.err"), 2);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                Debug.error("Post panel action for SPIRIT Database panel failed " + e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    this.closeDBConnection();
                }
                catch (SQLException e) {
                    Debug.error("Error in closing Connection " + e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean oracleCheck(AutomatedInstallData installData) {
        block18: {
            String driver = "oracle.jdbc.driver.OracleDriver";
            String errMsg = installData.langpack.getString("spirit.database.invalid.conn.details");
            String url = "jdbc:oracle:thin:@" + installData.getVariable("DatabaseHost") + ":" + installData.getVariable("DatabaseHostPort") + ":" + installData.getVariable("DatabaseName");
            try {
                this.getDBConnection(driver, url, installData.getVariable("SPIRITDatabaseUsername"), installData.getVariable("SPIRITDatabasePassword"));
                Debug.log("Oracle SPIRIT Database Connection : Pass");
                errMsg = installData.langpack.getString("spirit.admin.database.invalid.conn.details");
                this.getDBConnection(driver, url, installData.getVariable("SPIRITAdminDatabaseUsername"), installData.getVariable("SPIRITAdminDatabasePassword"));
                Debug.log("Oracle SPIRIT Admin Database Connection : Pass");
            }
            catch (SQLException e) {
                Debug.error(errMsg);
                if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                    System.err.println(errMsg);
                    System.exit(-1);
                    break block18;
                }
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, errMsg, installData.langpack.getString("title.db.conn.err"), 2);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                Debug.error("Post panel action for SPIRIT Database panel failed " + e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    this.closeDBConnection();
                }
                catch (SQLException e) {
                    Debug.error("Error in closing Connection " + e);
                }
            }
        }
        return true;
    }

    private void getDBConnection(String jdbcDriver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        Class.forName(jdbcDriver, true, Installer.class.getClassLoader());
        this.mConnection = DriverManager.getConnection(url, username, password);
    }

    private void closeDBConnection() throws SQLException {
        if (this.mConnection != null) {
            this.mConnection.close();
        }
    }
}

