/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;

public class OsBitSize {
    private OsBitSize() {
    }

    public static BitSize getBitSize() {
        if (!OsVersion.IS_UNIX) {
            String bitSize = System.getProperty("sun.arch.data.model", "32");
            if (bitSize.equals(BitSize.BIT_64.toString())) {
                return BitSize.BIT_64;
            }
            return BitSize.BIT_32;
        }
        if (OsVersion.IS_SUNOS) {
            String[] commandToExecute = new String[]{"/bin/bash", "-c", "isainfo -b"};
            String commandOutput = FileExecutor.getExecOutput(commandToExecute);
            if (commandOutput.toLowerCase().contains("32")) {
                return BitSize.BIT_32;
            }
            if (commandOutput.toLowerCase().contains("64")) {
                return BitSize.BIT_64;
            }
        } else {
            String[] commandToExecute = new String[]{"/bin/bash", "-c", "uname -a"};
            String commandOutput = FileExecutor.getExecOutput(commandToExecute);
            if (commandOutput.toLowerCase().contains("ia32") || commandOutput.toLowerCase().contains("i386") || commandOutput.toLowerCase().contains("i586")) {
                return BitSize.BIT_32;
            }
            if (commandOutput.toLowerCase().contains("ia64") || commandOutput.toLowerCase().contains("amd64") || commandOutput.toLowerCase().contains("x86_64")) {
                return BitSize.BIT_64;
            }
        }
        return BitSize.BIT_32;
    }

    public static void main(String[] args) {
        System.out.println((Object)OsBitSize.getBitSize());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BitSize {
        BIT_32(32),
        BIT_64(64);

        private int size;

        private BitSize(int size) {
            this.size = size;
        }

        public String toString() {
            return Integer.toString(this.size);
        }
    }
}

