/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.util.HashMap;
import java.util.Iterator;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSValidator {
    public static void validateOperatingSystem(AutomatedInstallData idata) {
        HashMap osMap = OsVersion.getplatformSupportMap();
        if (idata.info.getPlatform() != null) {
            for (XMLElement platform : idata.info.getPlatform()) {
                String supportedPlatform = platform.getContent();
                if (supportedPlatform == null || osMap == null || !osMap.containsKey(supportedPlatform.toUpperCase().trim()) || !((Boolean)osMap.get(supportedPlatform.toUpperCase().trim())).booleanValue()) continue;
                return;
            }
        } else {
            return;
        }
        if (idata.info.getPlatformImplementation() != null && idata.info.getPlatformImplementation().equals("warning")) {
            Debug.error("Unsupported Operating system");
            System.err.println("Warning: Unsupported Operating system");
            OSValidator.printSupportedOS(osMap);
            return;
        }
        System.err.println("Unsupported Operating System");
        OSValidator.printSupportedOS(osMap);
        System.exit(2);
    }

    public static void printSupportedOS(HashMap<String, Boolean> osMap) {
        String os = "";
        if (osMap != null) {
            Iterator<String> iter = osMap.keySet().iterator();
            System.out.println("List of supported Operating System");
            while (iter.hasNext()) {
                os = os + iter.next() + "\n";
            }
            System.out.println(os);
        }
    }
}

