/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.installer.IAvayaPostPanelAction;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.Installer;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DatabasePostPanelAction
implements IAvayaPostPanelAction {
    private Connection mConnection;
    private Statement mStatement;
    boolean flag = false;

    public boolean performPostPanelAction(AutomatedInstallData installData) {
        if (installData.getVariable("Database1").equals("Postgres")) {
            return this.postgresCheck(installData);
        }
        if (installData.getVariable("Database1").startsWith("Oracle")) {
            boolean result = this.addOracleDriverInClasspath(installData);
            if (!result) {
                return false;
            }
            return this.oracleCheck(installData);
        }
        return false;
    }

    public boolean postgresCheck(AutomatedInstallData installData) {
        String sql;
        ResultSet resultSet = null;
        String errMsg = installData.langpack.getString("admin.database.invalid.conn.details");
        String driver = "org.postgresql.Driver";
        String url = "jdbc:postgresql://" + installData.getVariable("DatabaseHost") + ":" + installData.getVariable("DatabaseHostPort") + "/" + installData.getVariable("DatabaseName");
        try {
            this.getDBConnection(driver, url, installData.getVariable("DatabaseUsername"), installData.getVariable("DatabasePassword"));
            Debug.log("Postgres Admin Database Connection : Pass");
            errMsg = installData.langpack.getString("app.database.invalid.conn.details");
            this.getDBConnection(driver, url, installData.getVariable("AppDatabaseUsername"), installData.getVariable("AppDatabasePassword"));
            Debug.log("Postgres Application Database Connection : Pass");
        }
        catch (SQLException e) {
            Debug.error(errMsg);
            if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                System.err.println(errMsg);
                System.exit(-1);
            } else {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, errMsg, installData.langpack.getString("title.db.conn.err"), 2);
            }
            return false;
        }
        catch (Exception e) {
            Debug.error("Post panel action for Database panel failed " + e);
            return false;
        }
        try {
            sql = "select * from INFORMATION_SCHEMA.tables where table_schema='avaya_system_data' and  table_name='av_mgmt_pluginmgmt_ep'";
            resultSet = this.mStatement.executeQuery(sql);
            if (resultSet.next()) {
                installData.setVariable("createDBtables", "false");
                this.flag = true;
                Debug.log("Table av_mgmt_pluginmgmt_ep already present");
            } else {
                installData.setVariable("createDBtables", "true");
                Debug.log("Table av_mgmt_pluginmgmt_ep is not present");
            }
        }
        catch (Exception e) {
            installData.setVariable("createDBtables", "true");
            Debug.log("Table av_mgmt_pluginmgmt_ep is not present");
        }
        try {
            sql = "select * from av_mgmt_pluginmgmt_ep";
            resultSet = this.mStatement.executeQuery(sql);
            if (resultSet.next()) {
                installData.setVariable("installEP", "false");
                this.flag = true;
                Debug.log("Table av_mgmt_pluginmgmt_ep contains records");
            } else {
                installData.setVariable("installEP", "true");
                Debug.log("Table av_mgmt_pluginmgmt_ep is empty");
            }
        }
        catch (Exception e) {
            installData.setVariable("installEP", "true");
            Debug.log("Table av_mgmt_pluginmgmt_ep is not present");
        }
        try {
            sql = "select * from spm_application";
            resultSet = null;
            resultSet = this.mStatement.executeQuery(sql);
            if (resultSet.next()) {
                installData.setVariable("installSPMProfile", "false");
                this.flag = true;
                Debug.log("Table spm_application contains records");
            } else {
                installData.setVariable("installSPMProfile", "true");
                Debug.log("Table spm_application is not present");
            }
        }
        catch (Exception e) {
            installData.setVariable("installSPMProfile", "true");
            Debug.log("Table spm_application is not present");
        }
        try {
            sql = "select * from INFORMATION_SCHEMA.tables where table_schema='avaya_system_data' and table_name='schemaversion'";
            resultSet = null;
            resultSet = this.mStatement.executeQuery(sql);
            if (resultSet.next()) {
                installData.setVariable("upgradeNRPTable", "true");
                this.flag = true;
                Debug.log("Table schemaversion already present");
            } else {
                installData.setVariable("upgradeNRPTable", "false");
                Debug.log("Table schemaversion is not present");
            }
        }
        catch (Exception e) {
            installData.setVariable("upgradeNRPTable", "false");
            Debug.log("Table schemaversion is not present");
        }
        try {
            sql = "select count(*) from csuser";
            ResultSet resultSet1 = this.mStatement.executeQuery(sql);
            if (resultSet1 != null && resultSet1.next()) {
                if (resultSet1.getMetaData().getColumnCount() > 0 && resultSet1.getInt(1) > 0) {
                    installData.setVariable("popSeedData", "false");
                    Debug.log("Table csuser is populated");
                    this.flag = true;
                } else {
                    installData.setVariable("popSeedData", "true");
                    Debug.log("Table csuser is not populated");
                }
            }
        }
        catch (Exception e) {
            installData.setVariable("popSeedData", "true");
        }
        if (this.flag) {
            this.askQuestion(installData);
        }
        try {
            this.closeDBConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean oracleCheck(AutomatedInstallData installData) {
        ResultSet resultSet;
        String sql;
        String driver = "oracle.jdbc.driver.OracleDriver";
        String errMsg = installData.langpack.getString("admin.database.invalid.conn.details");
        String url = "jdbc:oracle:thin:@" + installData.getVariable("DatabaseHost") + ":" + installData.getVariable("DatabaseHostPort") + ":" + installData.getVariable("DatabaseName");
        try {
            this.getDBConnection(driver, url, installData.getVariable("DatabaseUsername"), installData.getVariable("DatabasePassword"));
            Debug.log("Oracle Admin Database Connection : Pass");
            errMsg = installData.langpack.getString("app.database.invalid.conn.details");
            this.getDBConnection(driver, url, installData.getVariable("AppDatabaseUsername"), installData.getVariable("AppDatabasePassword"));
            Debug.log("Oracle Application Database Connection : Pass");
        }
        catch (SQLException e) {
            Debug.error(errMsg);
            if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                System.err.println(errMsg);
                System.exit(-1);
            } else {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, errMsg, installData.langpack.getString("title.db.conn.err"), 2);
            }
            return false;
        }
        catch (Exception e) {
            Debug.error("Post panel action for Database panel failed " + e);
            return false;
        }
        try {
            sql = "select * from av_mgmt_pluginmgmt_ep";
            if (this.mStatement.execute(sql)) {
                installData.setVariable("createDBtables", "false");
                this.flag = true;
                Debug.log("Table av_mgmt_pluginmgmt_ep already present");
            } else {
                installData.setVariable("createDBtables", "true");
                Debug.log("Table av_mgmt_pluginmgmt_ep already present");
            }
        }
        catch (Exception e) {
            installData.setVariable("createDBtables", "true");
            Debug.log("Table av_mgmt_pluginmgmt_ep is not present");
        }
        try {
            sql = "select count(*) from av_mgmt_pluginmgmt_ep";
            resultSet = this.mStatement.executeQuery(sql);
            if (resultSet != null && resultSet.next()) {
                if (resultSet.getMetaData().getColumnCount() > 0 && resultSet.getInt(1) > 0) {
                    installData.setVariable("installEP", "false");
                    Debug.log("Table av_mgmt_pluginmgmt_ep contains records");
                } else {
                    installData.setVariable("installEP", "true");
                }
                this.flag = true;
            } else {
                installData.setVariable("installEP", "true");
                Debug.log("Table av_mgmt_pluginmgmt_ep already present");
            }
        }
        catch (Exception e) {
            installData.setVariable("installEP", "true");
            Debug.log("Table av_mgmt_pluginmgmt_ep is not present");
        }
        try {
            sql = "select count(*) from spm_application";
            resultSet = this.mStatement.executeQuery(sql);
            if (resultSet != null && resultSet.next()) {
                if (resultSet.getMetaData().getColumnCount() > 0 && resultSet.getInt(1) > 0) {
                    installData.setVariable("installSPMProfile", "false");
                    Debug.log("Table spm_application already present");
                } else {
                    installData.setVariable("installSPMProfile", "true");
                }
                this.flag = true;
            } else {
                installData.setVariable("installSPMProfile", "true");
                Debug.log("Table spm_application is not present");
            }
        }
        catch (Exception e) {
            installData.setVariable("installSPMProfile", "true");
            Debug.log("Table spm_application is not present");
        }
        try {
            sql = "select * from schemaversion";
            if (this.mStatement.execute(sql)) {
                installData.setVariable("upgradeNRPTable", "true");
                Debug.log("Table schemaversion already present");
                this.flag = true;
            } else {
                installData.setVariable("upgradeNRPTable", "false");
                Debug.log("Table schemaversion is not present");
            }
        }
        catch (Exception e) {
            installData.setVariable("upgradeNRPTable", "false");
            Debug.log("Table schemaversion is not present");
        }
        try {
            sql = "select count(*) from csuser";
            ResultSet resultSet1 = this.mStatement.executeQuery(sql);
            if (resultSet1 != null && resultSet1.next()) {
                if (resultSet1.getMetaData().getColumnCount() > 0 && resultSet1.getInt(1) > 0) {
                    installData.setVariable("popSeedData", "false");
                    installData.setVariable("createDBtables", "false");
                    Debug.log("Table csuser is populated");
                } else {
                    installData.setVariable("popSeedData", "true");
                    installData.setVariable("createDBtables", "true");
                    Debug.log("Table csuser is not populated");
                }
                this.flag = true;
            }
        }
        catch (Exception e) {
            installData.setVariable("createDBtables", "true");
            installData.setVariable("popSeedData", "true");
        }
        if (this.flag) {
            this.askQuestion(installData);
        }
        try {
            this.closeDBConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void getDBConnection(String jdbcDriver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        Class.forName(jdbcDriver, true, Installer.class.getClassLoader());
        this.mConnection = DriverManager.getConnection(url, username, password);
        this.mStatement = this.mConnection.createStatement();
    }

    private void closeDBConnection() throws SQLException {
        if (this.mStatement != null) {
            this.mStatement.close();
        }
        if (this.mConnection != null) {
            this.mConnection.close();
        }
    }

    public void askQuestion(AutomatedInstallData installData) {
        if (installData.getVariable("ClusterInstallation") != null && AvayaInstaller.panther.installationMode.equals("gui") && (installData.getVariable("ClusterInstallation").equals("false") || installData.getVariable("FirstClusterNode").equals("true"))) {
            ++AvayaInstallData.install_warnings_count;
            Debug.warn(installData.langpack.getString("database.exists.question"));
        }
    }

    public boolean addOracleDriverInClasspath(AutomatedInstallData installData) {
        try {
            String oracleClientLibPath = installData.getVariable("ORACLE_CLIENT_LOC") + File.separator + "ojdbc14.jar";
            if (!new File(oracleClientLibPath).exists()) {
                throw new Exception();
            }
            File fl = new File(oracleClientLibPath);
            AvayaInstallerBase.addURLToClasspath(fl.toURL());
        }
        catch (Exception ex) {
            Debug.fatal("Loading of database driver file failed.");
            if (AvayaInstaller.panther.getInstallationMode().equals("unattended")) {
                System.err.println(installData.langpack.getString("oracle.jar.failed"));
                System.exit(-1);
            } else {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, installData.langpack.getString("oracle.jar.failed"), installData.langpack.getString("fatal.error"), 2);
            }
            return false;
        }
        return true;
    }
}

