/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.avaya.panther.panels.SimpleProcessingClient;
import com.avaya.panther.util.ValidatorUtil;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.NotEmptyValidator;
import java.util.HashMap;
import java.util.List;

public class AvayaPortValidator
implements Validator {
    static HashMap<String, String> existPortMap = new HashMap();
    static List alreadySelectedPacksList = null;

    public boolean validate(ProcessingClient field) {
        AutomatedInstallData installData = AutomatedInstallData.getInstance();
        String fieldVarName = installData.getAttribute("specRuleFieldVarName") + "";
        if (alreadySelectedPacksList != installData.selectedPacks) {
            existPortMap.clear();
            alreadySelectedPacksList = installData.selectedPacks;
        }
        boolean isValid = true;
        try {
            String panelId = this.getCurrPanelId(installData);
            if (!new NotEmptyValidator().validate(field)) {
                installData.setVariable("msgId", "true");
                return false;
            }
            if (panelId != null && fieldVarName != null) {
                String portKey = panelId + fieldVarName;
                this.refreshPortMap(portKey);
                if (!new ValidatorUtil().validatePortFormat(field.getText().trim())) {
                    installData.setVariable("PortFieldValidationError", installData.langpack.getString("port.range.validate.txt"));
                    SimpleProcessingClient.setErrorMsg(installData.getVariable("PortFieldValidationError"));
                    validatorMap.put(this.getClass().getName(), true);
                    return false;
                }
                if (!new ValidatorUtil().validateOSPortFormat(field.getText().trim())) {
                    installData.setVariable("PortFieldValidationError", installData.langpack.getString("port.osrange.range.validate.txt"));
                    validatorMap.put(this.getClass().getName(), false);
                    SimpleProcessingClient.setErrorMsg(installData.getVariable("PortFieldValidationError"));
                    return false;
                }
                if (existPortMap != null && existPortMap.containsValue(field.getText().trim())) {
                    installData.setVariable("PortFieldValidationError", installData.langpack.getString("port.already.used.validate.txt"));
                    validatorMap.put(this.getClass().getName(), false);
                    SimpleProcessingClient.setErrorMsg(installData.getVariable("PortFieldValidationError"));
                    return false;
                }
                existPortMap.put(portKey, field.getText().trim());
                return true;
            }
        }
        catch (Exception ex) {
            isValid = false;
        }
        return isValid;
    }

    private void refreshPortMap(String portkey) {
        if (portkey != null && existPortMap != null && existPortMap.containsKey(portkey)) {
            existPortMap.remove(portkey);
        }
    }

    private String getCurrPanelId(AutomatedInstallData installData) {
        int curPanelNumber = installData.curPanelNumber;
        List panelsOrderList = installData.panelsOrder;
        Panel panel = null;
        if (panelsOrderList != null) {
            panel = (Panel)panelsOrderList.get(curPanelNumber);
        }
        return panel != null ? panel.getPanelid() : null;
    }
}

